/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.projectbrowser;

import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.projectbrowser.InternalFrameListenerProjectBrowser;
import ciss.phase_viewer.projectbrowser.ProjectBrowserMenuBar;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowser;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserNode;
import ciss.phase_viewer.projectbrowser.projectstatemanipulator.ProjectStateChangeEvent;
import ciss.phase_viewer.projectbrowser.projectstatemanipulator.ProjectStateChangeListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.JSplitPane;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ProjectBrowser
extends InternalFrameChase
implements ProjectStateChangeListener,
Serializable {
    private static Logger logger = Logger.getLogger(ProjectBrowser.class.getName());
    private String myproj = System.getProperty("user.home") + System.getProperty("file.separator") + ".phase-viewer" + System.getProperty("file.separator") + "my_projects.xml";
    private JSplitPane splitpane;
    private Document doc;
    private ProjectDirBrowser dirbrowser;
    private ProjectDirBrowserNode associatedNode;
    private Vector projectManipulators = new Vector();
    private ProjectInfo projectInfo;

    public ProjectBrowser(Dimension dim, ProjectInfo projectInfo) {
        super(projectInfo.getProjectName() + " (" + projectInfo.getProjectType() + ")", true, true, true, true, dim, projectInfo.getProjectType());
        this.projectInfo = projectInfo;
        projectInfo.setParent(this);
        this.init();
    }

    public void setAssociatedNode(ProjectDirBrowserNode node) {
        this.associatedNode = node;
    }

    public ProjectDirBrowserNode getAssociatedNode() {
        return this.associatedNode;
    }

    public void selectFromProjects() {
        if (this.associatedNode == null) {
            return;
        }
        this.associatedNode.getDirBrowser().getTree().scrollPathToVisible(new TreePath(this.associatedNode.getPath()));
        this.associatedNode.getDirBrowser().getTree().setSelectionPath(new TreePath(this.associatedNode.getPath()));
    }

    public void registerProjectManipulators(ProjectManipulator manip) {
        this.projectManipulators.addElement(manip);
    }

    public boolean isLoaded(Class clazz) {
        String cname = clazz.getName();
        for (int i = 0; i < this.projectManipulators.size(); ++i) {
            String regName = this.projectManipulators.elementAt(i).getClass().getName();
            if (!regName.equals(cname)) continue;
            return true;
        }
        return false;
    }

    public ProjectManipulator getProjectManipulator(String cname) {
        for (int i = 0; i < this.projectManipulators.size(); ++i) {
            String regName = this.projectManipulators.elementAt(i).getClass().getName();
            if (!regName.equals(cname)) continue;
            return (ProjectManipulator)this.projectManipulators.elementAt(i);
        }
        return null;
    }

    protected boolean imClosing() {
        boolean ret = true;
        for (int i = 0; i < this.projectManipulators.size(); ++i) {
            Object obj = this.projectManipulators.elementAt(i);
            if (obj == null || !((ProjectManipulator)obj).postProcess()) continue;
            ret = false;
        }
        return ret;
    }

    public void recreate() {
        this.setTitle(this.projectInfo.getProjectName() + " (" + this.projectInfo.getProjectType() + ")");
        Container container = this.getContentPane();
        Component[] comps = container.getComponents();
        if (comps == null || comps.length == 0) {
            return;
        }
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] == null || !(comps[i] instanceof ProjectManipulator)) continue;
            ((ProjectManipulator)comps[i]).recreate();
        }
    }

    public void projectStateChanged(ProjectStateChangeEvent e) {
    }

    public ProjectDirBrowser getDirBrowser() {
        return this.dirbrowser;
    }

    private void init() {
        this.setJMenuBar(new ProjectBrowserMenuBar(this));
        this.addInternalFrameListener(new InternalFrameListenerProjectBrowser(this));
    }

    public void setProjectManipulator(ProjectManipulator manip) {
        Container container = this.getContentPane();
        container.removeAll();
        container.add(manip);
    }

    public ProjectDirBrowserNode getRootNode() {
        return this.dirbrowser.getRootNode();
    }

    public ProjectDirBrowserNode getSelectedNode() {
        return this.dirbrowser.getSelectedNode();
    }

    public static Document getDocument(File myproj_file) {
        Element root;
        Document docu;
        URL myproj_url;
        if (myproj_file.exists()) {
            try {
                myproj_url = new URL("file://localhost/" + myproj_file.getAbsolutePath());
            }
            catch (MalformedURLException ex) {
                logger.warn("malformed url found. using default.");
                myproj_url = ProjectBrowser.class.getResource("/ciss/phase_viewer/projectbrowser/my_projects.xml");
            }
        } else {
            myproj_url = ProjectBrowser.class.getResource("/ciss/phase_viewer/projectbrowser/my_projects.xml");
        }
        if ((docu = ProjectBrowser.createDoc(myproj_url)) == null) {
            logger.warn("invalid 'my_projects' file... using default");
            myproj_url = ProjectBrowser.class.getResource("/ciss/phase_viewer/projectbrowser/my_projects.xml");
            docu = ProjectBrowser.createDoc(myproj_url);
        }
        if (!(root = docu.getRootElement()).getName().equals("projects")) {
            logger.warn("not a valid my_projects file... using default");
            myproj_url = ProjectBrowser.class.getResource("/ciss/phase_viewer/projectbrowser/my_projects.xml");
            docu = ProjectBrowser.createDoc(myproj_url);
        }
        return docu;
    }

    private static Document createDoc(URL url) {
        Document docu = null;
        SAXBuilder builder = new SAXBuilder();
        try {
            docu = builder.build(url);
        }
        catch (JDOMException jde) {
            logger.error("failed to parse " + url);
            logger.error("unrecoverable error.");
        }
        catch (IOException ioe) {
            logger.error("failed to parse " + url);
            logger.error("unrecoverable error.");
        }
        logger.debug("doc: " + docu);
        return docu;
    }
}

