/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.primitiveguis.tableforinputinterface;

import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.common.CheckBoxTableCellRenderer;
import ciss.phase_viewer.common.Command;
import ciss.phase_viewer.common.ConstParameters;
import ciss.phase_viewer.common.ExcelAdapter;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeListener;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTableColumns;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTableSpec;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTableSpecManager;
import ciss.phase_viewer.inputinterface.inputinterfacetable.RightClickItems;
import ciss.phase_viewer.primitiveguis.ToolTippedCombo;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableModelForInputInterface;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableModelForNonTabularData;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableRightClickListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.DecimalFormat;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class TableForInputInterface
extends JTable
implements ItemListener,
ActionListener,
CaretListener,
PopupMenuListener {
    private static Logger logger = Logger.getLogger(TableForInputInterface.class.getName());
    private String[] idents;
    private Vector tableData;
    private String[] inputSpecifications;
    private InputInterface inputInterface;
    private InputInterfaceTableSpecManager manager;
    private InputInterfaceTableSpec tableSpec;
    private InputInterfaceTableColumns[] tableCols;
    private int[] mapSpecCol;
    private EventListener eventListener;
    private JPanel panel;
    private CheckBoxTable cbtable;
    private DecimalFormat formater = ConstParameters.formater;
    private boolean non_tabular = false;
    private boolean row_oriented = false;
    private String[] row_oriented_columns;
    private int columnIndex = 0;
    private AtomCoords coords;
    private Font cellFont;
    private TableModelListener[] tlisteners;
    private Vector tableRightClickListeners;

    public TableForInputInterface(String[] inputSpecifications, InputInterface inputInterface, int[] mapSpecCol, EventListener eventListener) {
        this.inputSpecifications = inputSpecifications;
        this.inputInterface = inputInterface;
        this.mapSpecCol = mapSpecCol;
        this.eventListener = eventListener;
        this.columnIndex = 0;
        this.init();
        this.createAll();
    }

    public TableForInputInterface(AtomCoords coords, String[] inputSpecifications, InputInterface inputInterface, int[] mapSpecCol, EventListener eventListener) {
        this.coords = coords;
        this.inputSpecifications = inputSpecifications;
        this.inputInterface = inputInterface;
        this.mapSpecCol = mapSpecCol;
        this.eventListener = eventListener;
        this.columnIndex = 0;
        this.init();
        this.createAll();
    }

    public TableForInputInterface(String[] inputSpecifications, InputInterface inputInterface, EventListener eventListener) {
        this.inputSpecifications = inputSpecifications;
        this.inputInterface = inputInterface;
        this.eventListener = eventListener;
        this.columnIndex = 0;
        this.init();
        this.createAll();
    }

    public TableForInputInterface(String[] inputSpecifications, InputInterface inputInterface, int[] mapSpecCol, EventListener eventListener, int columnIndex) {
        this.inputSpecifications = inputSpecifications;
        this.inputInterface = inputInterface;
        this.mapSpecCol = mapSpecCol;
        this.eventListener = eventListener;
        this.columnIndex = columnIndex;
        this.init();
        this.createAll();
    }

    public TableForInputInterface(String[] inputSpecifications, InputInterface inputInterface, int[] mapSpecCol, EventListener eventListener, int columnIndex, Font cellFont) {
        this.inputSpecifications = inputSpecifications;
        this.inputInterface = inputInterface;
        this.mapSpecCol = mapSpecCol;
        this.eventListener = eventListener;
        this.columnIndex = columnIndex;
        this.cellFont = cellFont;
        this.init();
        this.createAll();
    }

    public TableForInputInterface(String[] inputSpecifications, InputInterface inputInterface, EventListener eventListener, int columnIndex) {
        this.inputSpecifications = inputSpecifications;
        this.inputInterface = inputInterface;
        this.eventListener = eventListener;
        this.columnIndex = columnIndex;
        this.init();
        this.createAll();
    }

    public void itemStateChanged(ItemEvent e) {
        Command command = (Command)e.getSource();
        command.execute(e);
    }

    public void actionPerformed(ActionEvent e) {
        Command command = (Command)e.getSource();
        command.execute(e);
    }

    public void caretUpdate(CaretEvent e) {
        Command command = (Command)e.getSource();
        command.execute(e);
    }

    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        Command command = (Command)e.getSource();
        command.execute(e);
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    public void removeListeners() {
        this.tlisteners = ((DefaultTableModel)this.getModel()).getTableModelListeners();
        if (this.tlisteners != null) {
            for (int i = 0; i < this.tlisteners.length; ++i) {
                ((DefaultTableModel)this.getModel()).removeTableModelListener(this.tlisteners[i]);
            }
        }
    }

    public void restoreListeners() {
        if (this.tlisteners != null) {
            for (int i = 0; i < this.tlisteners.length; ++i) {
                ((DefaultTableModel)this.getModel()).addTableModelListener(this.tlisteners[i]);
            }
        }
    }

    public JPanel getPanel() {
        this.createPanel();
        return this.panel;
    }

    public boolean hasData(boolean[] ignore) {
        boolean hasdata = false;
        TableModel model = this.getModel();
        int icol = model.getColumnCount();
        int irow = model.getRowCount();
        for (int i = 0; i < irow; ++i) {
            for (int j2 = 0; j2 < icol; ++j2) {
                String data;
                if (ignore != null && ignore[j2] || (data = (String)model.getValueAt(i, j2)) == null || data.trim().length() == 0) continue;
                hasdata = true;
            }
        }
        return hasdata;
    }

    private void init() {
        logger.debug("at init(): " + this.inputSpecifications[0]);
        ExcelAdapter ea = new ExcelAdapter(this);
        this.manager = this.inputInterface.getInputInterfaceTableSpecManager();
        if (this.manager != null) {
            this.tableSpec = this.manager.getTableSpec(this.inputSpecifications[0], this.columnIndex);
            if (this.tableSpec != null) {
                this.tableCols = this.tableSpec.getTableColumns();
            } else {
                return;
            }
        }
        if (this.mapSpecCol == null && this.tableCols != null) {
            int len = this.tableCols.length;
            this.mapSpecCol = new int[len];
            for (int i = 0; i < len; ++i) {
                this.mapSpecCol[i] = i;
            }
        }
        this.non_tabular = this.tableSpec.nonTabular();
        if (this.non_tabular) {
            this.row_oriented = this.tableSpec.isRowOriented();
            this.row_oriented_columns = this.tableSpec.getColumnNamesForNonTabularData();
        }
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.setModel(this.getTableModel());
        this.revalidate();
        this.repaint();
        if (this.eventListener instanceof ListSelectionListener) {
            this.getSelectionModel().addListSelectionListener((ListSelectionListener)this.eventListener);
        }
    }

    private boolean isColumnEmpty(int rowIndex) {
        for (int j2 = 1; j2 < ConstParameters.COLNAME_ATOM.length; ++j2) {
            String length = (String)this.getModel().getValueAt(rowIndex, j2);
            if (length != null && length.trim().length() == 0) continue;
            return false;
        }
        return true;
    }

    private void createAll() {
        if (this.manager != null && this.inputInterface != null) {
            int[] inds = this.getApplyToAllIndices();
            if (inds != null && inds.length != 0) {
                logger.debug("creating checkbox table...");
                logger.debug("column count... " + this.getColumnCount());
                logger.debug("indices...");
                for (int i = 0; i < inds.length; ++i) {
                    logger.debug(new Integer(inds[i]));
                }
                this.cbtable = new CheckBoxTable(inds, this.getModel().getColumnCount());
            }
            this.createTable();
            this.createPanel();
        }
    }

    private void createPanel() {
        this.panel.removeAll();
        int row = this.getRowCount();
        if (row == 1 && this.getModel() instanceof TableModelForNonTabularData) {
            this.panel.setLayout(new GridLayout(2, 1));
        } else {
            this.panel.setLayout(new BoxLayout(this.panel, 1));
        }
        this.panel.add(this.getTableHeader());
        if (this.cbtable != null) {
            this.panel.add(this.cbtable);
        }
        this.panel.add(this);
        logger.debug("tableheader..." + this.getTableHeader());
        logger.debug("inputspec: " + this.inputSpecifications[0]);
    }

    private int[] getApplyToAllIndices() {
        Vector<Integer> indvec = new Vector<Integer>();
        for (int i = 0; i < this.mapSpecCol.length; ++i) {
            logger.debug("cols: " + this.tableCols[this.mapSpecCol[i]]);
            if (!this.tableCols[this.mapSpecCol[i]].hasApplytoAll()) continue;
            indvec.addElement(new Integer(i));
        }
        if (indvec == null || indvec.size() == 0) {
            return null;
        }
        int[] ret = new int[indvec.size()];
        for (int i = 0; i < indvec.size(); ++i) {
            ret[i] = (Integer)indvec.elementAt(i);
        }
        return ret;
    }

    public void updateCellEditor(int col) {
        if (this.non_tabular) {
            return;
        }
        if (col < this.getColumnCount()) {
            TableColumn colu = this.getColumnModel().getColumn(col);
            this.setCellEditor(colu, this.tableCols[this.mapSpecCol[col]], col);
        }
    }

    private void createTable() {
        int numCols = this.getColumnCount();
        ColumnHeaderToolTips toolTips = new ColumnHeaderToolTips();
        for (int i = 0; i < numCols; ++i) {
            TableColumn col = this.getColumnModel().getColumn(i);
            if (!this.non_tabular) {
                this.setCellEditor(col, this.tableCols[this.mapSpecCol[i]], i);
                this.setToolTip(toolTips, col, this.tableCols[this.mapSpecCol[i]]);
                continue;
            }
            this.setEditorsAndRenderes();
        }
        this.addMouseListener(new RowMouseListener());
        this.setTableHeader(new TableHeader(this, this.tableCols, this.mapSpecCol));
        this.getTableHeader().addMouseMotionListener(toolTips);
        logger.debug("done creating table for: " + this.inputSpecifications[0]);
    }

    private void setEditorsAndRenderes() {
        int rowStart;
        MyTableCellRenderer dtcr = new MyTableCellRenderer();
        dtcr.setHorizontalAlignment(0);
        MyTableCellRenderer dtcr2 = new MyTableCellRenderer();
        JTextField tf = new JTextField();
        tf.setEditable(false);
        JTextField tf2 = new JTextField();
        tf2.setEditable(true);
        DefaultCellEditor dce = new DefaultCellEditor(tf);
        DefaultCellEditor dce2 = new DefaultCellEditor(tf2);
        int icol = this.getModel().getColumnCount();
        this.columnModel.getColumn(0).setCellRenderer(dtcr);
        this.columnModel.getColumn(0).setCellEditor(dce);
        for (int i = rowStart = 1; i < icol; ++i) {
            this.columnModel.getColumn(i).setCellRenderer(dtcr2);
            this.columnModel.getColumn(i).setCellEditor(dce2);
        }
    }

    private void setToolTip(ColumnHeaderToolTips toolTips, TableColumn col, InputInterfaceTableColumns tableCol) {
        String toolTip = tableCol.getToolTip();
        if (toolTip != null && toolTip.trim().length() != 0) {
            toolTips.setToolTip(col, tableCol.getToolTip());
        }
    }

    private void setCellEditor(TableColumn col, InputInterfaceTableColumns tableCol, int colnum) {
        String type = tableCol.getCellEditor();
        String defaultValue = tableCol.getDefaultValue();
        logger.debug("default value: " + defaultValue);
        boolean editable = tableCol.isEditable();
        if (type.equals(InputInterfaceTableColumns.TEXT_FIELD)) {
            JTextField textField = null;
            textField = tableCol.hasApplytoAll() ? new TextFieldApplyToAll(defaultValue, this.cbtable, this, colnum, this) : new JTextField(defaultValue);
            textField.setEnabled(editable);
            col.setCellEditor(new DefaultCellEditor(textField));
        } else if (type.equals(InputInterfaceTableColumns.COMBO_BOX)) {
            ToolTippedCombo combo = null;
            if (!this.validChoices(tableCol.getChoices())) {
                if (tableCol.hasApplytoAll()) {
                    col.setCellEditor(new DefaultCellEditor(new TextFieldApplyToAll(defaultValue, this.cbtable, this, colnum, this)));
                } else {
                    col.setCellEditor(new DefaultCellEditor(new JTextField()));
                }
                return;
            }
            if (tableCol.hasApplytoAll()) {
                combo = new ComboBoxApplyToAll(tableCol.getChoices(), this.cbtable, this, colnum, this);
            } else {
                combo = new ToolTippedCombo(tableCol.getChoices());
                String[] tips = new String[tableCol.getChoices().length];
                for (int i = 0; i < tableCol.getChoices().length; ++i) {
                    tips[i] = tableCol.getToolTipAssociatedWithChoice(i);
                }
                combo.setToolTips(tips);
            }
            combo.setEditable(editable);
            col.setCellEditor(new DefaultCellEditor(combo));
        } else if (type.equals(InputInterfaceTableColumns.CHECK_BOX)) {
            JCheckBox checkBox = null;
            checkBox = tableCol.hasApplytoAll() ? new CheckBoxApplyToAll(false, this.cbtable, this, colnum, this) : new JCheckBox("", (boolean)new Boolean(defaultValue));
            checkBox.setEnabled(editable);
            checkBox.setHorizontalAlignment(0);
            col.setCellEditor(new DefaultCellEditor(checkBox));
            col.setCellRenderer(new CheckBoxTableCellRenderer());
        }
    }

    private boolean validChoices(String[] test2) {
        if (test2 == null || test2.length == 0) {
            return false;
        }
        return test2.length != 1 || test2[0].trim().length() != 0;
    }

    protected void doApplyToAll(Object selectedItem, int colInd) {
        int numRow = this.getRowCount();
        int numCols = this.getColumnCount();
        DefaultTableModel mod = (DefaultTableModel)this.getModel();
        ((TableModelForInputInterface)mod).notifyInputInterfaceChangeListeners(false);
        int swi = numRow - 1;
        if (swi < 0) {
            swi = 0;
        }
        for (int i = 0; i < numRow; ++i) {
            int nullCount = 0;
            for (int j2 = 0; j2 < numCols; ++j2) {
                Object obj = this.getModel().getValueAt(i, j2);
                if (obj == null) {
                    ++nullCount;
                    continue;
                }
                if (obj.toString().trim().length() != 0) continue;
                ++nullCount;
            }
            if (nullCount == numCols) {
                ((TableModelForInputInterface)mod).notifyInputInterfaceChangeListeners(true);
                mod.setValueAt(mod.getValueAt(0, 0), 0, 0);
                logger.debug("done 'apply_to_all'");
                return;
            }
            logger.debug("setting " + selectedItem + " at " + i + ", " + colInd);
            mod.setValueAt(selectedItem, i, colInd);
        }
        ((TableModelForInputInterface)mod).notifyInputInterfaceChangeListeners(true);
        mod.setValueAt(mod.getValueAt(0, 0), 0, 0);
    }

    public void updateAll() {
        this.setModel(this.getTableModel());
        this.revalidate();
        this.repaint();
        this.createAll();
    }

    public void addTableRightClickListener(TableRightClickListener listener) {
        if (this.tableRightClickListeners == null) {
            this.tableRightClickListeners = new Vector();
        }
        this.tableRightClickListeners.addElement(listener);
    }

    protected void deleteColumn(int col) {
        int i;
        int[] tmp = new int[this.mapSpecCol.length - 1];
        int icount = 0;
        for (i = 0; i < this.mapSpecCol.length; ++i) {
            if (i == col) continue;
            tmp[icount] = this.mapSpecCol[i];
            ++icount;
        }
        this.mapSpecCol = new int[tmp.length];
        for (i = 0; i < this.mapSpecCol.length; ++i) {
            this.mapSpecCol[i] = tmp[i];
        }
        this.setModel(this.getTableModel());
        this.revalidate();
        this.repaint();
        this.createAll();
    }

    protected void addColumn(String name) {
        int i;
        int addInd = -1;
        for (int i2 = 0; i2 < this.tableCols.length; ++i2) {
            if (!this.tableCols[i2].getName().equals(name)) continue;
            addInd = i2;
            break;
        }
        int[] tmp = new int[this.mapSpecCol.length + 1];
        for (i = 0; i < this.mapSpecCol.length; ++i) {
            tmp[i] = this.mapSpecCol[i];
        }
        tmp[this.mapSpecCol.length] = addInd;
        this.mapSpecCol = new int[this.mapSpecCol.length + 1];
        for (i = 0; i < this.mapSpecCol.length; ++i) {
            this.mapSpecCol[i] = tmp[i];
        }
        this.inputInterface.removeInputInterfaceEntryChangeListener((InputInterfaceEntryChangeListener)((Object)this.getModel()));
        this.setModel(this.getTableModel());
        this.revalidate();
        this.repaint();
        this.createAll();
    }

    private TableModelForInputInterface getTableModel() {
        TableModelForInputInterface tmfi = null;
        tmfi = this.coords == null ? TableModelForInputInterface.getInstance(this.inputSpecifications, this.inputInterface, this.mapSpecCol, this.eventListener, this.non_tabular, this.columnIndex) : TableModelForInputInterface.getInstance(this.coords, this.inputSpecifications, this.inputInterface.getInputInterfaceTableSpecManager(), this.mapSpecCol, this.eventListener, this);
        tmfi.setParentTable(this);
        return tmfi;
    }

    class TextFieldApplyToAll
    extends JTextField
    implements Command {
        private Logger logger;
        private JTable cbTable;
        private TableForInputInterface dataTable;
        private int lookAt;

        public TextFieldApplyToAll(String text, JTable cbTable, TableForInputInterface dataTable, int lookAt, EventListener listener) {
            super(text);
            this.logger = Logger.getLogger(CheckBoxApplyToAll.class.getName());
            super.addCaretListener((CaretListener)listener);
            this.cbTable = cbTable;
            this.dataTable = dataTable;
            this.lookAt = lookAt;
        }

        public void execute(EventObject e) {
            try {
                String tmp;
                Object obj = this.cbTable.getModel().getValueAt(0, this.lookAt);
                if (obj == null) {
                    this.logger.debug("obj is null at " + this.lookAt);
                    return;
                }
                if (((Boolean)obj).booleanValue() && (tmp = this.getText()) != null) {
                    this.dataTable.doApplyToAll(tmp, this.lookAt);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    class CheckBoxApplyToAll
    extends JCheckBox
    implements Command,
    CheckBoxTableListener {
        private Logger logger = Logger.getLogger(CheckBoxApplyToAll.class.getName());
        private JTable cbTable;
        private TableForInputInterface dataTable;
        private int lookAt;

        public CheckBoxApplyToAll(boolean onoff, JTable cbTable, TableForInputInterface dataTable, int lookAt, EventListener listener) {
            super.setSelected(onoff);
            super.addActionListener((ActionListener)listener);
            this.cbTable = cbTable;
            this.dataTable = dataTable;
            this.lookAt = lookAt;
            ((CheckBoxTable)cbTable).addListener(this);
        }

        public void execute(EventObject e) {
        }

        public void checkBoxChecked(int index) {
            if (this.lookAt == index) {
                this.dataTable.doApplyToAll(((CheckBoxTable)this.cbTable).isSelected(this.lookAt), this.lookAt);
            }
        }
    }

    class ComboBoxApplyToAll
    extends ToolTippedCombo
    implements Command {
        private Logger logger;
        private JTable cbTable;
        private TableForInputInterface dataTable;
        private int lookAt;

        public ComboBoxApplyToAll(String[] list, JTable cbTable, TableForInputInterface dataTable, int lookAt, EventListener listener) {
            super(list);
            this.logger = Logger.getLogger(ComboBoxApplyToAll.class.getName());
            super.addPopupMenuListener((PopupMenuListener)listener);
            this.cbTable = cbTable;
            this.dataTable = dataTable;
            this.lookAt = lookAt;
        }

        public void execute(EventObject e) {
            this.logger.debug("cbtable: " + this.cbTable);
            this.logger.debug("cbtable.getModel(): " + this.cbTable.getModel());
            this.logger.debug("cbtable.getModel.getValueAt(0,lookAt): " + this.cbTable.getModel().getValueAt(0, this.lookAt));
            try {
                Object obj = this.cbTable.getModel().getValueAt(0, this.lookAt);
                if (obj == null) {
                    this.logger.debug("obj is null at " + this.lookAt);
                    return;
                }
                if (((Boolean)obj).booleanValue() && this.isPopupVisible()) {
                    this.dataTable.doApplyToAll(this.getSelectedItem(), this.lookAt);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    class CheckBoxTable
    extends JTable {
        private int[] indeces;
        private int numcols = 0;
        private Vector listeners;
        private JCheckBox[] checkBoxes;

        public CheckBoxTable(int[] indeces, int numcols) {
            this.indeces = indeces;
            this.numcols = numcols;
            this.init();
        }

        void addListener(CheckBoxTableListener listener) {
            if (this.listeners == null) {
                this.listeners = new Vector();
            }
            this.listeners.add(listener);
        }

        boolean isSelected(int colind) {
            Component comp = ((DefaultCellEditor)this.getColumnModel().getColumn(colind).getCellEditor()).getComponent();
            if (!(comp instanceof JCheckBox)) {
                return false;
            }
            return ((JCheckBox)comp).isSelected();
        }

        private void init() {
            this.setSelectionForeground(Color.white);
            this.setSelectionBackground(Color.white);
            this.setAutoResizeMode(0);
            this.setModel(new DefaultTableModel(1, this.numcols));
            this.revalidate();
            this.repaint();
            JCheckBox checkBox = new JCheckBox("apply to all");
            checkBox.setHorizontalAlignment(0);
            checkBox.setSelected(false);
            DefaultCellEditor editorCB = new DefaultCellEditor(checkBox);
            this.checkBoxes = new JCheckBox[this.indeces.length];
            for (int i = 0; i < this.indeces.length && i < this.getColumnCount(); ++i) {
                this.checkBoxes[i] = new CheckBoxTableCellRenderer("apply to all");
                this.getColumnModel().getColumn(this.indeces[i]).setCellRenderer(new CheckBoxTableCellRenderer("apply to all"));
                this.getColumnModel().getColumn(this.indeces[i]).setCellEditor(editorCB);
                checkBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent arg0) {
                        if (CheckBoxTable.this.listeners != null) {
                            for (int i = 0; i < CheckBoxTable.this.listeners.size(); ++i) {
                                ((CheckBoxTableListener)CheckBoxTable.this.listeners.get(i)).checkBoxChecked(CheckBoxTable.this.getSelectedColumn());
                            }
                        }
                    }
                });
            }
            JTextField tf = new JTextField("");
            tf.setEnabled(false);
            DefaultCellEditor editorTF = new DefaultCellEditor(tf);
            for (int i = 0; i < this.numcols; ++i) {
                TableColumn column = this.getColumnModel().getColumn(i);
                boolean is_cb = false;
                for (int j2 = 0; j2 < this.indeces.length; ++j2) {
                    if (this.indeces[j2] != i) continue;
                    is_cb = true;
                    break;
                }
                if (is_cb) continue;
                this.getColumnModel().getColumn(i).setCellEditor(editorTF);
            }
        }
    }

    static interface CheckBoxTableListener {
        public void checkBoxChecked(int var1);
    }

    class ColumnHeaderToolTips
    extends MouseMotionAdapter {
        TableColumn curCol;
        Map tips = new HashMap();

        ColumnHeaderToolTips() {
        }

        public void setToolTip(TableColumn col, String tooltip) {
            if (tooltip == null) {
                this.tips.remove(col);
            } else {
                this.tips.put(col, tooltip);
            }
        }

        public void mouseMoved(MouseEvent evt) {
            TableColumn col = null;
            JTableHeader header = (JTableHeader)evt.getSource();
            JTable table = header.getTable();
            TableColumnModel colModel = table.getColumnModel();
            int vColIndex = colModel.getColumnIndexAtX(evt.getX());
            if (vColIndex >= 0) {
                col = colModel.getColumn(vColIndex);
            }
            if (col != this.curCol) {
                header.setToolTipText((String)this.tips.get(col));
                this.curCol = col;
            }
        }
    }

    class ColumnHeaderMouseListener
    extends MouseAdapter {
        protected ColumnHeaderMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            Command command = (Command)e.getSource();
            command.execute(e);
        }
    }

    class ColumnHeaderCheckBox
    extends JCheckBoxMenuItem {
        private boolean column_visible;
        private TableForInputInterface table;

        protected ColumnHeaderCheckBox(TableForInputInterface table, String title, boolean column_visible) {
            super(title);
            this.column_visible = true;
            this.column_visible = column_visible;
            this.table = table;
            this.addActionListener(new ColumnHeaderCheckBoxListener(title));
        }

        class ColumnHeaderCheckBoxListener
        implements ActionListener {
            private String name;

            protected ColumnHeaderCheckBoxListener(String name) {
                this.name = name;
            }

            public void actionPerformed(ActionEvent e) {
                int col = ColumnHeaderCheckBox.this.table.getColumnCount();
                if (!ColumnHeaderCheckBox.this.getState()) {
                    for (int i = 0; i < col; ++i) {
                        if (!ColumnHeaderCheckBox.this.table.getColumnName(i).equals(this.name)) continue;
                        ColumnHeaderCheckBox.this.table.deleteColumn(i);
                        return;
                    }
                } else {
                    ColumnHeaderCheckBox.this.table.addColumn(this.name);
                }
            }
        }
    }

    class TableHeader
    extends JTableHeader
    implements Command {
        private Logger logger;
        private TableColumnModel model;
        private InputInterfaceTableColumns[] columns;
        private TableForInputInterface table;
        int[] map;

        protected TableHeader(TableForInputInterface table, InputInterfaceTableColumns[] columns, int[] map) {
            super(table.getColumnModel());
            this.logger = Logger.getLogger(TableHeader.class.getName());
            this.table = table;
            this.model = table.getColumnModel();
            this.columns = columns;
            this.map = map;
            this.addMouseListener(new ColumnHeaderMouseListener());
        }

        public void execute(EventObject e) {
            if (e instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)e;
                this.logger.debug("at: tableheader...");
                if (me.getButton() == 3) {
                    this.logger.debug("right-clicked table header...");
                    this.showMenu((MouseEvent)e);
                }
            }
        }

        private void showMenu(MouseEvent e) {
            JPopupMenu popup = new JPopupMenu();
            int numCol = this.model.getColumnCount();
            for (int i = 0; i < this.columns.length; ++i) {
                if (!this.columns[i].isHideable()) continue;
                ColumnHeaderCheckBox item = new ColumnHeaderCheckBox(this.table, this.columns[i].getName(), true);
                boolean vis = false;
                for (int j2 = 0; j2 < numCol; ++j2) {
                    if (!((String)this.model.getColumn(j2).getHeaderValue()).equalsIgnoreCase(this.columns[i].getName().trim())) continue;
                    vis = true;
                    break;
                }
                item.setState(vis);
                popup.add(item);
            }
            if (popup.getComponentCount() > 0) {
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    class RightClickMenu
    extends JMenuItem {
        private MouseEvent me;
        private String name;

        protected RightClickMenu(MouseEvent me, RightClickItems item) {
            super(item.getText());
            this.setToolTipText(item.getToolTip());
            this.me = me;
            this.name = item.getName();
            this.init();
        }

        private void init() {
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    RightClickMenu.this.doRightClickItem(RightClickMenu.this.me, RightClickMenu.this.name);
                }
            });
        }

        private void doRightClickItem(MouseEvent e, String name) {
            logger.debug("clicked item");
            logger.debug("you're at row: " + TableForInputInterface.this.rowAtPoint(e.getPoint()));
            if (TableForInputInterface.this.tableRightClickListeners == null) {
                return;
            }
            for (int i = 0; i < TableForInputInterface.this.tableRightClickListeners.size(); ++i) {
                ((TableRightClickListener)TableForInputInterface.this.tableRightClickListeners.elementAt(i)).tableRightClicked(e.getPoint(), name);
            }
        }
    }

    class RowMouseListener
    extends MouseAdapter {
        JPopupMenu popup;

        protected RowMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            if (TableForInputInterface.this.inputInterface.getInputInterfaceTableSpecManager().getTableSpec(TableForInputInterface.this.inputSpecifications[0]).getRightClickItems() == null) {
                return;
            }
            this.processClick(e);
        }

        private void processClick(MouseEvent e) {
            if (e.getButton() == 3) {
                this.popup = new JPopupMenu();
                RightClickItems[] items = TableForInputInterface.this.inputInterface.getInputInterfaceTableSpecManager().getTableSpec(TableForInputInterface.this.inputSpecifications[0]).getRightClickItems();
                this.createMenu(e, items);
                if (this.popup.getComponentCount() > 0) {
                    this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }

        private void createMenu(MouseEvent e, RightClickItems[] items) {
            for (int i = 0; i < items.length; ++i) {
                this.popup.add(new RightClickMenu(e, items[i]));
            }
        }
    }

    class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        MyTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (TableForInputInterface.this.cellFont != null) {
                cell.setFont(TableForInputInterface.this.cellFont);
            }
            return cell;
        }
    }
}

