/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.primitiveguis;

import ciss.phase_viewer.filebrowser.FileBrowserUtils;
import ciss.phase_viewer.inputinterface.filestate.FileStateChangeEvent;
import ciss.phase_viewer.inputinterface.filestate.FileStateListener;
import ciss.phase_viewer.inputinterface.filestate.FileStateObserver;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class ComboButton
extends JPanel
implements FileStateListener {
    private Logger logger = Logger.getLogger(ComboButton.class.getName());
    private String dir;
    private String[] filters;
    private JComboBox comboBox;
    private JButton button;

    public ComboButton(String dir, String filter) {
        this.dir = dir;
        this.filters = new String[]{filter};
        this.setLayout(new BoxLayout(this, 0));
        FileStateObserver obs = new FileStateObserver(dir, this.filters);
        this.init();
        obs.addFileStateListener(this);
    }

    public ComboButton(String dir, String[] filters) {
        this.dir = dir;
        this.filters = filters;
        this.setLayout(new BoxLayout(this, 0));
        FileStateObserver obs = new FileStateObserver(dir, filters);
        this.init();
        obs.addFileStateListener(this);
    }

    private void init() {
        String[] files = new File(this.dir).list();
        if (files != null && files.length > 0) {
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < files.length; ++i) {
                for (int j2 = 0; j2 < this.filters.length; ++j2) {
                    if (!files[i].matches(this.filters[j2])) continue;
                    vector.addElement(files[i]);
                }
            }
            if (vector.size() != 0) {
                this.comboBox = new JComboBox(vector);
                this.button = new JButton("view");
                this.button.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        FileBrowserUtils.bootProgram(false, ComboButton.this.dir + System.getProperty("file.separator") + ComboButton.this.comboBox.getSelectedItem().toString().trim());
                    }
                });
                this.add(this.comboBox);
                this.add(this.button);
            }
        }
    }

    public void recreate() {
        this.removeAll();
        this.init();
    }

    public void fileStateChanged(FileStateChangeEvent fe) {
        this.logger.debug(fe);
        this.recreate();
        this.revalidate();
    }
}

