/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.mainpanel;

import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.mainpanel.Chase;
import ciss.phase_viewer.mainpanel.ChaseGUI;
import ciss.phase_viewer.mainpanel.FrameChase;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import ciss.phase_viewer.ssh.hosts.HostList;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class ChaseInitializer
extends FrameChase {
    private Logger logger = Logger.getLogger(ChaseInitializer.class.getName());
    private ChaseGUI chase;
    private String initBaseDir = System.getProperty("user.home") + System.getProperty("file.separator") + "phase-viewer-projects";
    private Container container;
    private JTextField text;
    private JButton btn;
    private JCheckBox loadSample = new JCheckBox("load samples");
    private JCheckBox overwriteSettings = new JCheckBox("overwrite existing settings");
    private String baseDir;
    private GlobalProperties gp = PropertiesManager.getGlobalProperties(0);
    private Vector pathSelectors = new Vector();

    public ChaseInitializer(ChaseGUI chase) {
        super("initial configuration", new Dimension(400, 400));
        this.chase = chase;
        this.init();
    }

    private void init() {
        this.container = this.getContentPane();
        this.container.setLayout(new BoxLayout(this.container, 1));
        this.container.add(this.baseDirPanel());
        this.container.add(this.createPanelExternal());
        this.loadSample.setSelected(true);
        this.overwriteSettings.setSelected(true);
        JPanel psamp = new JPanel();
        psamp.setBorder(new TitledBorder("samples"));
        psamp.add(this.loadSample);
        this.container.add(psamp);
        this.container.add(this.overwriteSettings);
        this.container.add(this.buttons());
        this.pack();
        int scrx = ChaseGUI.getScreenWidth();
        int scry = ChaseGUI.getScreenHeight();
        int centerx = scrx / 2 - this.getSize().width / 2;
        int centery = scry / 2 - this.getSize().height / 2;
        this.setLocation(centerx, centery);
        this.setVisible(true);
        this.requestFocus();
    }

    private JPanel buttons() {
        JPanel pbtn = new JPanel();
        JButton ok = new JButton("ok");
        pbtn.add(ok);
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ChaseInitializer.this.doInitialization();
                ChaseInitializer.this.chase.setLoadSample(ChaseInitializer.this.loadSample.isSelected());
                ChaseInitializer.this.setVisible(false);
                ChaseInitializer.this.gp.storeProperty();
                ChaseInitializer.this.dispose();
            }
        });
        return pbtn;
    }

    private JPanel baseDirPanel() {
        JPanel p = new JPanel();
        p.add(new PathSelector(this.initBaseDir, "base directory", new PathSelectorAction(){

            void doIt(String text) {
                ChaseInitializer.this.baseDir = text;
                if (ChaseInitializer.this.baseDir == null || ChaseInitializer.this.baseDir.trim().length() == 0) {
                    ChaseInitializer.this.logger.error("invalid base directory... using default.");
                    ChaseInitializer.this.baseDir = ChaseInitializer.this.initBaseDir;
                }
                HostInfo localHost = HostList.getHostList().getHostInfo("localhost");
                localHost.setProperty("basedir", ChaseInitializer.this.baseDir);
                if (!new File(ChaseInitializer.this.baseDir).mkdirs()) {
                    ChaseInitializer.this.logger.error("failed to create initial root project directory...");
                }
                HostList.getHostList().save();
            }
        }));
        return p;
    }

    private String getGSPath(String os) {
        if (!os.startsWith("windows")) {
            return "gs";
        }
        File[] root = File.listRoots();
        for (int i = 0; i < root.length; ++i) {
            File[] gssubdir;
            File[] gsdir;
            File[] foo;
            if (root[i].getAbsolutePath().toLowerCase().startsWith("a:") || (foo = root[i].listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.equalsIgnoreCase("program files");
                }
            })) == null || foo.length == 0 || ((gsdir = foo[0].listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.equalsIgnoreCase("gs");
                }
            })) == null || gsdir.length == 0) && ((gsdir = root[i].listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.equalsIgnoreCase("gs");
                }
            })) == null || gsdir.length == 0) || (gssubdir = gsdir[0].listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith("gs");
                }
            })) == null || gsdir.length == 0) continue;
            String ret = gssubdir[gssubdir.length - 1] + System.getProperty("file.separator") + "bin" + System.getProperty("file.separator") + "gswin32c.exe";
            if (new File(ret).exists()) {
                return ret;
            }
            String ret64 = gssubdir[gssubdir.length - 1] + System.getProperty("file.separator") + "bin" + System.getProperty("file.separator") + "gswin64c.exe";
            if (!new File(ret64).exists()) continue;
            return ret64;
        }
        return "";
    }

    private JPanel createPanelExternal() {
        JPanel pext = new JPanel();
        pext.setLayout(new BoxLayout(pext, 1));
        String editor = this.gp.getProperty("editor");
        String gs = this.gp.getProperty("gs");
        String os = System.getProperty("os.name").toLowerCase();
        editor = os.startsWith("windows") ? "NOTEPAD" : "emacs";
        gs = this.getGSPath(os);
        pext.add(new PathSelector(editor, "external editor", new PathSelectorAction(){

            void doIt(String text) {
                if (text != null && text.trim().length() != 0) {
                    ChaseInitializer.this.gp.setProperty("editor", text);
                    ChaseInitializer.this.gp.storeProperty();
                }
            }
        }, false));
        pext.add(new PathSelector(gs, "ghostscript", new PathSelectorAction(){

            void doIt(String text) {
                if (text != null && text.trim().length() != 0) {
                    ChaseInitializer.this.gp.setProperty("gs", text);
                    ChaseInitializer.this.gp.storeProperty();
                }
            }
        }, false));
        return pext;
    }

    private void doInitialization() {
        for (int i = 0; i < this.pathSelectors.size(); ++i) {
            PathSelector selector = (PathSelector)this.pathSelectors.get(i);
            selector.doAction();
        }
        if (this.overwriteSettings.isSelected()) {
            Chase.generateDefaultDotChaseDir(true);
        }
        Thread th = new Thread(new PPCopier());
        th.start();
    }

    abstract class PathSelectorAction {
        PathSelectorAction() {
        }

        abstract void doIt(String var1);
    }

    class PathSelector
    extends JPanel {
        private JTextField textField = new JTextField(30);
        private JButton jButton = new JButton("choose...");
        private PathSelectorAction action;
        private boolean dir = true;
        private String title;
        private String initPath;

        PathSelector(String initPath, String title, PathSelectorAction action, boolean dir) {
            this.dir = dir;
            this.initPath = initPath;
            this.title = title;
            this.action = action;
            this.init();
        }

        PathSelector(String initPath, String title, PathSelectorAction action) {
            this.action = action;
            this.initPath = initPath;
            this.title = title;
            this.init();
        }

        private void init() {
            this.setLayout(new BoxLayout(this, 0));
            this.setBorder(new TitledBorder(this.title));
            this.textField.setText(this.initPath);
            this.add(this.textField);
            this.add(this.jButton);
            this.jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    JFileChooser chooser = new JFileChooser();
                    chooser.setDialogType(0);
                    if (PathSelector.this.dir) {
                        chooser.setFileSelectionMode(1);
                    } else {
                        chooser.setFileSelectionMode(0);
                    }
                    if (chooser.showDialog(ChaseInitializer.this.container, "open") != 0) {
                        return;
                    }
                    PathSelector.this.textField.setText(chooser.getSelectedFile().getAbsolutePath());
                }
            });
            ChaseInitializer.this.pathSelectors.addElement(this);
        }

        void doAction() {
            this.action.doIt(this.textField.getText());
        }
    }

    class PPCopier
    implements Runnable {
        private JProgressBar bar;
        private File tmppseudoFile;
        private String ppdir;
        private JFrame fr;
        private Timer timer;

        PPCopier() {
        }

        public void run() {
            this.ppdir = System.getProperty("pviewer.home") + System.getProperty("file.separator") + "pp";
            File dataDir = new File(ChaseInitializer.this.baseDir + System.getProperty("file.separator") + "data");
            if (dataDir.mkdirs()) {
                this.progressBar();
                File pseudoFile = new File(dataDir.getAbsolutePath() + System.getProperty("file.separator") + "pseudopotential");
                this.tmppseudoFile = new File(dataDir.getAbsolutePath() + System.getProperty("file.separator") + "pp");
                Utils.copyDir(new File(this.ppdir), dataDir);
                File ppdirFile = new File(dataDir.getAbsolutePath() + System.getProperty("file.separator") + "pp");
                ppdirFile.renameTo(pseudoFile);
            }
            if (this.fr != null) {
                this.fr.setVisible(false);
                this.fr.dispose();
            }
            ChaseInitializer.this.chase.init();
            this.timer.stop();
        }

        private void progressBar() {
            int numpp = new File(this.ppdir).listFiles().length;
            this.bar = new JProgressBar(0, numpp);
            this.bar.setValue(0);
            this.bar.setStringPainted(true);
            this.bar.setPreferredSize(new Dimension(300, 20));
            this.fr = new JFrame();
            this.fr.setTitle("copying PseudoPotential files...");
            this.fr.getContentPane().add(this.bar);
            this.fr.pack();
            int scrx = ChaseGUI.getScreenWidth();
            int scry = ChaseGUI.getScreenHeight();
            int centerx = scrx / 2 - this.fr.getSize().width / 2;
            int centery = scry / 2 - this.fr.getSize().height / 2;
            this.fr.setLocation(centerx, centery);
            this.fr.setVisible(true);
            this.timer = new Timer(0, new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    PPCopier.this.update();
                }
            });
            this.timer.start();
        }

        private void update() {
            File[] files;
            if (this.tmppseudoFile.exists() && (files = this.tmppseudoFile.listFiles()) != null) {
                this.bar.setValue(files.length);
            }
        }
    }
}

