/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.common;

import ciss.phase_viewer.acviewer.ACVData;
import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.AtomList;
import ciss.phase_viewer.common.ConstParameters;
import ciss.phase_viewer.common.MyThread;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.settings.PropertiesManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import org.apache.log4j.Logger;

public class CoordsViewerBooter {
    public static int BIOSTATION_VIEWER = 1;
    public static int INTERNAL_VIEWER = 0;
    private static Logger logger = Logger.getLogger(CoordsViewerBooter.class.getName());
    private Vector frames;
    private AtomCoords coords;
    private int choice = INTERNAL_VIEWER;
    private String parentDir;
    private ACVData acvdata;

    public CoordsViewerBooter() {
    }

    public CoordsViewerBooter(ACVData acvdata) {
        this.frames = acvdata.getFrames();
        this.parentDir = acvdata.getParentDir();
        this.acvdata = acvdata;
        this.choice = this.choice;
    }

    public CoordsViewerBooter(ACVData acvdata, int choice) {
        this.frames = acvdata.getFrames();
        this.parentDir = acvdata.getParentDir();
        this.acvdata = acvdata;
        this.choice = choice;
    }

    public CoordsViewerBooter(Vector frames, String parentDir, int choice) {
        this.frames = frames;
        this.parentDir = parentDir;
        this.choice = choice;
    }

    public void boot() {
        if (this.choice == 0) {
            this.bootACViewer();
        } else if (this.choice == 1) {
            this.bootBSViewer();
        }
    }

    private void bootACViewer() {
        MainPanel mPanel = new MainPanel(this.acvdata);
        try {
            mPanel.display3D();
        }
        catch (Exception exception) {
            logger.warn("failed to show atomic configuration");
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bootBSViewer() {
        double[][] Dpos = this.coords.getPosDouble();
        if (Dpos == null) {
            logger.warn("atom coordinates == null!");
            return;
        }
        String dir = new String();
        dir = this.parentDir != null ? this.parentDir : System.getProperty("user.dir");
        String xyzFile = dir + System.getProperty("file.separator") + "AtomicConfig.xyz";
        logger.debug("xyzFile: " + xyzFile);
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new BufferedWriter(new FileWriter(xyzFile)));
            int NumAt = this.coords.getNumAt();
            AtomList list = this.coords.getAtomList();
            writer.println(NumAt);
            writer.println("xyz-file");
            logger.debug("atom coords ...");
            for (int i = 0; i < NumAt; ++i) {
                String element = list.getAtomAt(i).getElementName();
                writer.println(element + " " + Dpos[i][0] + " " + Dpos[i][1] + " " + Dpos[i][2]);
                logger.debug(element + " " + Dpos[i][0] + " " + Dpos[i][1] + " " + Dpos[i][2]);
            }
        }
        catch (IOException ie) {
            logger.error("failed to create temporary xyz-file");
            return;
        }
        finally {
            writer.close();
        }
        String bsviewer = System.getProperty("pviewer.home") + System.getProperty("file.separator") + PropertiesManager.getGlobalProperties(0).getProperty("BioStationViewer");
        logger.debug("bsvpath: " + bsviewer);
        if (bsviewer == null) {
            logger.warn("couldn't find BioStationViewer");
            return;
        }
        if (!new File(bsviewer).exists()) {
            logger.warn("could not find BioStationViewer");
            return;
        }
        String bsvexe = Utils.getPathDQ(ConstParameters.getJavaPath()) + " -jar " + Utils.getPathDQ(bsviewer) + " -f " + Utils.getPathDQ(xyzFile);
        MyThread mt = new MyThread(bsvexe);
    }
}

