/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord.io;

import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.Cell;
import ciss.phase_viewer.atomcoord.io.Importer;
import ciss.phase_viewer.common.Utils;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class CrystalStudioASCIIImporter
implements Importer {
    private Logger logger = Logger.getLogger(CrystalStudioASCIIImporter.class.getName());
    private BufferedReader reader = null;
    private AtomCoords coords;
    private boolean readCell = false;
    private boolean isCart = false;
    private int unit = 2;
    private Vector elemSpec = new Vector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AtomCoords[] getAtomCoordsFrom(String fileName) {
        this.coords = new AtomCoords();
        try {
            try {
                this.reader = new BufferedReader(new FileReader(fileName));
                String line = "";
                while ((line = this.reader.readLine()) != null) {
                    if (this.parseLine(line.trim())) continue;
                    AtomCoords[] atomCoordsArray = null;
                    return atomCoordsArray;
                }
            }
            catch (IOException ioe) {
                this.logger.error("failed read from : " + fileName);
                ioe.printStackTrace();
            }
            finally {
                try {
                    this.reader.close();
                }
                catch (IOException io) {}
            }
            this.coords.convert(6, 8);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        if (this.coords.getNumAt() == 0) return null;
        return new AtomCoords[]{this.coords};
    }

    private boolean parseLine(String line) {
        if (line.startsWith("#") || line.length() == 0) {
            return true;
        }
        if (!this.readCell && line.startsWith("Original")) {
            try {
                String avec = this.reader.readLine();
                String bvec = this.reader.readLine();
                String cvec = this.reader.readLine();
                this.logger.debug("avec, bvec, cvec: ");
                this.logger.debug(avec);
                this.logger.debug(bvec);
                this.logger.debug(cvec);
                String[] av = avec.trim().split("\\s+");
                String[] bv = bvec.trim().split("\\s+");
                String[] cv = cvec.trim().split("\\s+");
                double[] dav = new double[3];
                double[] dbv = new double[3];
                double[] dcv = new double[3];
                try {
                    for (int i = 0; i < 3; ++i) {
                        dav[i] = Double.parseDouble(av[i]);
                        dbv[i] = Double.parseDouble(bv[i]);
                        dcv[i] = Double.parseDouble(cv[i]);
                    }
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
                catch (ArrayIndexOutOfBoundsException aobe) {
                    return false;
                }
                Cell cell = new Cell(av, bv, cv);
                this.coords.setCell(cell);
                String cellang = this.reader.readLine();
                this.logger.debug("cell ang: " + cellang);
                String cart_and_unit = this.reader.readLine();
                String[] dat = cart_and_unit.trim().split("\\s+");
                if (dat[0].equalsIgnoreCase("cartesian")) {
                    this.isCart = true;
                } else if (dat[0].equalsIgnoreCase("fractional")) {
                    this.isCart = false;
                }
                if (dat.length >= 2 && dat[1].length() >= 1) {
                    String stru = dat[1].substring(1, dat[1].length() - 1);
                    if (stru.equalsIgnoreCase("angstrom")) {
                        this.unit = 2;
                    } else if (stru.equalsIgnoreCase("bohr")) {
                        this.unit = 1;
                    }
                }
                String[] spec = this.reader.readLine().trim().split(",");
                for (int i = 0; i < spec.length; ++i) {
                    Elem el = new Elem();
                    String[] spec_ = spec[i].trim().split("\\s+");
                    for (int j = 0; j < spec_.length; ++j) {
                        if (Utils.isNumber(spec_[j])) {
                            el.numAtoms = Integer.parseInt(spec_[j]);
                            continue;
                        }
                        if (j != 0 && !Utils.isNumber(spec_[j])) {
                            el.bondType = spec_[j];
                            continue;
                        }
                        el.elemName = spec_[j].indexOf("+") >= 0 ? spec_[j].split("\\+")[0] : (spec_[j].indexOf("-") >= 0 ? spec_[j].split("\\-")[0] : spec_[j]);
                    }
                    this.logger.debug("elem spec: " + el);
                    this.elemSpec.add(el);
                }
                this.readCell = true;
            }
            catch (ArrayIndexOutOfBoundsException aiobe) {
                this.logger.error("not enough data: " + line);
                return false;
            }
            catch (IOException ioe) {
                this.logger.error("failed read");
                return false;
            }
            catch (NumberFormatException nfe) {
                this.logger.error("could not convert " + line + " to a number.");
                return false;
            }
            catch (NullPointerException npe) {
                this.logger.error("not enough data.");
                return false;
            }
            this.coords.isCart(this.isCart);
            this.coords.setUnit(this.unit);
            try {
                for (int i = 0; i < this.elemSpec.size(); ++i) {
                    Elem e = (Elem)this.elemSpec.get(i);
                    String elemName = e.elemName;
                    for (int j = 0; j < e.numAtoms; ++j) {
                        String[] co = this.reader.readLine().trim().split("\\s+");
                        double[] tmpdouble = new double[3];
                        for (int k = 0; k < co.length; ++k) {
                            this.logger.debug("pos " + k + " : " + co[k]);
                            try {
                                tmpdouble[k] = Double.parseDouble(co[k]);
                                continue;
                            }
                            catch (NumberFormatException exc) {
                                return true;
                            }
                        }
                        Atom atom = new Atom(elemName, tmpdouble);
                        this.coords.getAtomList().addAtom(atom);
                    }
                }
            }
            catch (IOException ioe) {
                this.logger.error("not enough data.");
                return false;
            }
        }
        return true;
    }

    public boolean isImportable(String fileName) {
        return !new File(fileName).isDirectory();
    }

    public void createOptionsPanel(boolean heavy, PropertyChangeListener listener, String fileName) {
    }

    public FileFilter getFileFilter() {
        return new FileFilter(){

            public boolean accept(File f) {
                return true;
            }

            public String getDescription() {
                return "Crystal Studio file";
            }
        };
    }

    public String getType() {
        return "Crystal Studio file";
    }

    public boolean hasOptions() {
        return false;
    }

    public void setOptions(HashMap options) {
    }

    class Elem {
        String elemName = "X";
        int numAtoms = 0;
        String bondType = "";

        Elem() {
        }

        public String toString() {
            return "elementName: " + this.elemName + " num.atoms: " + String.valueOf(this.numAtoms) + " bond type: " + this.bondType;
        }
    }
}

