/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord.io;

import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.io.ChaseFileFilter;
import ciss.phase_viewer.atomcoord.io.Exporter;
import ciss.phase_viewer.jdom.XMLUtils;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;

public class ChaseExporter
implements Exporter {
    private Logger logger = Logger.getLogger(ChaseExporter.class.getName());

    public void createOptionsPanel(boolean heavy, PropertyChangeListener listener, String fileName) {
    }

    public boolean writeAtomCoordsTo(AtomCoords[] coords, String fileName) {
        this.logger.info("exporting atomic coordinates in 'phase-viewer' format to file " + fileName);
        if (coords == null || coords.length == 0) {
            this.logger.error("no coordinates to export.");
            return false;
        }
        String version = "";
        try {
            Document foo = XMLUtils.getDocumentFromURL(ChaseExporter.class.getResource("/ciss/phase_viewer/main/properties.xml"));
            version = " version " + foo.getRootElement().getChildTextTrim("version");
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        Document document = new Document();
        Element root = new Element("chase_atomic_coordinates");
        document.setRootElement(root);
        root.setAttribute(new Attribute("creator", "PHASE-Viewer" + version));
        root.setAttribute(new Attribute("numframes", String.valueOf(coords.length)));
        for (int i = 0; i < coords.length; ++i) {
            this.logger.info("doing frame no. " + i);
            root.addContent(coords[i].getXMLElement(i));
        }
        XMLUtils.saveDocumentTo(document, fileName);
        this.logger.info("...done.");
        return true;
    }

    public boolean hasOptions() {
        return false;
    }

    public String getType() {
        return "phase-viewer";
    }

    public FileFilter getFileFilter() {
        return new ChaseFileFilter();
    }

    public void setOptions(HashMap options) {
    }
}

