/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord;

import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.Cell;
import ciss.phase_viewer.common.TaggedString;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.mainpanel.ChaseProgressMonitor;
import ciss.phase_viewer.mainpanel.ProgressInfo;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Nfdynm2AtomCoords
implements ProgressInfo {
    private static Logger logger = Logger.getLogger(Nfdynm2AtomCoords.class.getName());
    public static final int OFF = 0;
    public static final int ON = 1;
    private String fileName;
    private final String HASH = "#";
    private final String SPACE = "[\\s]+";
    private String[] avec = new String[3];
    private String[] bvec = new String[3];
    private String[] cvec = new String[3];
    private int NTyp = 1;
    private int NAtom = 1;
    private int NAtomNow = 0;
    private Vector atomSpecies = new Vector();
    private Vector speciesName = new Vector();
    private AtomCoords coords;
    private Cell cell;
    private int cellCount = 0;
    private Vector frames = new Vector();
    private int periodic = 0;
    private int natm0 = 0;
    private int istart;
    private int iend;
    private int igap;
    private int iframeNow;
    private int nFrames = -1;
    private boolean dryrun = false;
    private boolean isDone = false;
    private LineNumberReader lreader;

    public Nfdynm2AtomCoords(String fileName) {
        this.fileName = fileName;
        this.coords = new AtomCoords();
        this.coords.isCart(true);
        this.coords.setUnit(1);
        this.setDefault();
    }

    public Nfdynm2AtomCoords(String fileName, int periodic) {
        this.fileName = fileName;
        this.coords = new AtomCoords();
        this.coords.isCart(true);
        this.coords.setUnit(1);
        this.periodic = periodic;
        this.setDefault();
        logger.debug("num frames: " + this.frames.size());
    }

    public void setStartEndGap(int istart, int iend, int igap) {
        this.istart = istart;
        this.iend = iend;
        this.igap = igap;
    }

    private void setDefault() {
        this.istart = 0;
        this.iend = this.getNumFrames();
        this.igap = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse() {
        this.frames = new Vector();
        this.iframeNow = 0;
        try {
            FileReader freader = new FileReader(this.fileName);
            this.lreader = new LineNumberReader(freader);
            ChaseProgressMonitor monitor = ChaseProgressMonitor.getMonitor();
            monitor.setProgress(this);
            String str = new String();
            while ((str = this.lreader.readLine()) != null) {
                if (this.parseString(str)) continue;
                logger.warn("failed parse at line: " + this.lreader.getLineNumber());
            }
        }
        catch (IOException e) {
            logger.warn("failed read from file " + this.fileName);
        }
        finally {
            this.isDone = true;
            try {
                this.lreader.close();
            }
            catch (Exception exc) {
                logger.error(exc);
            }
        }
    }

    private boolean parseString(String str) {
        if (str.trim().startsWith("#")) {
            return this.parseHeader(str.trim());
        }
        if (str.trim().startsWith("cps")) {
            return true;
        }
        return this.parseData(str.trim());
    }

    private boolean parseHeader(String str) {
        char[] cha = str.toCharArray();
        String data = new String();
        for (int i = 1; i < cha.length; ++i) {
            data = data + String.valueOf(cha[i]);
        }
        if ((data = data.trim()).startsWith("a_vector") || data.startsWith("b_vector") || data.startsWith("c_vector")) {
            int i;
            String[] vec = data.split("=");
            if (vec.length <= 1) {
                logger.warn("invalid cell data");
                return false;
            }
            String vector = vec[1].trim();
            String[] vals = vector.split("[\\s]+");
            if (vals.length <= 2) {
                logger.warn("invalid cell data");
                return false;
            }
            for (i = 0; i < 3; ++i) {
                vals[i] = vals[i].trim();
            }
            logger.debug("got cell vector: " + vals[0] + " " + vals[1] + " " + vals[2]);
            try {
                for (i = 0; i < 3; ++i) {
                    Double.parseDouble(vals[i]);
                }
            }
            catch (NumberFormatException nfe) {
                logger.warn("cell vector is not a number");
                return false;
            }
            if (data.startsWith("a_vector")) {
                for (i = 0; i < 3; ++i) {
                    this.avec[i] = vals[i];
                }
                ++this.cellCount;
            } else if (data.startsWith("b_vector")) {
                for (i = 0; i < 3; ++i) {
                    this.bvec[i] = vals[i];
                }
                ++this.cellCount;
            } else if (data.startsWith("c_vector")) {
                for (i = 0; i < 3; ++i) {
                    this.cvec[i] = vals[i];
                }
                ++this.cellCount;
            }
            if (this.cellCount == 3) {
                this.cell = new Cell(this.avec, this.bvec, this.cvec);
                this.coords.setCell(this.cell);
            }
            return true;
        }
        if (data.startsWith("ntyp")) {
            String[] ntyp = data.split("=");
            if (ntyp.length <= 2) {
                logger.warn("invalid specification for ntyp and/or natm");
                return false;
            }
            String nty = ntyp[1].trim();
            String[] nt = nty.split("[\\s]+");
            if (nt.length <= 1) {
                logger.warn("invalid specification for ntyp and/or natm");
                return false;
            }
            try {
                this.NTyp = Integer.parseInt(nt[0].trim());
                this.NAtom = Integer.parseInt(ntyp[2].trim());
            }
            catch (NumberFormatException nfe) {
                logger.warn("either ntyp or natm was not a number");
                return false;
            }
            logger.debug("ntyp: " + this.NTyp + " natm: " + this.NAtom);
            return true;
        }
        if (data.startsWith("(natm->type)")) {
            int i;
            String[] species = data.split("[\\s]+");
            if (species.length <= 1) {
                logger.warn("no specification for atom species");
                return false;
            }
            for (i = 1; i < species.length; ++i) {
                this.atomSpecies.addElement(species[i]);
            }
            for (i = 0; i < this.atomSpecies.size(); ++i) {
                logger.debug("species for atom " + i + " is " + this.atomSpecies.get(i));
            }
            return true;
        }
        if (data.startsWith("(speciesname)")) {
            String[] names = data.split("[\\s]+");
            if (names.length <= 3) {
                logger.warn("invalid specification for species name");
                return false;
            }
            String tag = names[1];
            String value = names[3];
            logger.debug("tag & value for species: " + tag + " " + value);
            TaggedString ts = new TaggedString(tag, value);
            this.speciesName.addElement(ts);
            return true;
        }
        return true;
    }

    private boolean parseData(String str) {
        ++this.NAtomNow;
        String[] data = str.split("[\\s]+");
        if (data.length <= 4) {
            logger.warn("invalid data");
            return false;
        }
        String[] xyz = new String[3];
        String type = new String();
        try {
            int index = Integer.parseInt(data[0].trim()) - 1;
            type = (String)this.atomSpecies.get(index);
        }
        catch (NumberFormatException nfe) {
            logger.warn("found a non-numeric index");
            return false;
        }
        String elementName = this.getElementName(type);
        if (elementName == null) {
            logger.warn("inconsistentcy found among species name and data");
            return false;
        }
        try {
            for (int i = 1; i < 4; ++i) {
                Double.parseDouble(data[i].trim());
            }
        }
        catch (NumberFormatException nfe) {
            logger.warn("xyz-data is not a number");
            return false;
        }
        xyz[0] = data[1].trim();
        xyz[1] = data[2].trim();
        xyz[2] = data[3].trim();
        String[] force = new String[3];
        if (data.length >= 7) {
            force[0] = data[4].trim();
            force[1] = data[5].trim();
            force[2] = data[6].trim();
        }
        logger.debug("got data for atom no. " + this.NAtomNow + " : " + elementName + " " + xyz[0] + " " + xyz[1] + " " + xyz[2]);
        if (this.targetFrame()) {
            Atom atom = new Atom(elementName, xyz, force);
            this.coords.getAtomList().addAtom(atom);
        }
        if (this.NAtomNow == this.NAtom) {
            if (this.targetFrame()) {
                this.coords.convert(6, 8);
                this.frames.addElement(this.coords);
            }
            this.coords = new AtomCoords();
            this.coords.setUnit(1);
            this.coords.isCart(true);
            this.coords.setCell(this.cell);
            this.NAtomNow = 0;
            ++this.iframeNow;
        }
        return true;
    }

    private boolean targetFrame() {
        if (this.dryrun) {
            return false;
        }
        if (this.iframeNow < this.istart || this.iframeNow > this.iend) {
            return false;
        }
        return this.iframeNow % this.igap == 0;
    }

    private String getElementName(String type) {
        int numSpecies = this.speciesName.size();
        for (int i = 0; i < numSpecies; ++i) {
            TaggedString ts = (TaggedString)this.speciesName.get(i);
            if (!ts.getTag().trim().equals(type.trim())) continue;
            return ts.getValue();
        }
        return null;
    }

    public AtomCoords getFrameAt(int i) {
        if (this.frames == null || this.frames.size() == 0) {
            this.parse();
        }
        if (i < 0) {
            return (AtomCoords)this.frames.elementAt(this.frames.size() - 1);
        }
        int framenum = i;
        if (this.frames.size() <= i) {
            framenum = this.frames.size() - 1;
        }
        return (AtomCoords)this.frames.elementAt(framenum);
    }

    public Vector getFrames() {
        if (this.frames == null || this.frames.size() == 0) {
            this.parse();
        }
        return this.frames;
    }

    public int getNumFrames() {
        if (this.frames != null && this.frames.size() > 0) {
            return this.frames.size();
        }
        if (this.nFrames >= 1) {
            return this.nFrames;
        }
        this.dryrun = true;
        this.parse();
        this.dryrun = false;
        this.nFrames = this.iframeNow;
        return this.nFrames;
    }

    public boolean isDone() {
        return this.isDone;
    }

    public String getNameOfProgress() {
        return "converting F_DYNM ...";
    }

    public int getLength() {
        return Utils.getNumLines(this.fileName);
    }

    public String getCurrentMessage() {
        return null;
    }

    public int getCurrent() {
        int ret = -1;
        try {
            ret = this.lreader.getLineNumber();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public void done() {
    }
}

