/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord;

import ciss.phase_viewer.atomcoord.AtomEditor;
import ciss.phase_viewer.atomcoord.AtomEditorEditors;
import ciss.phase_viewer.common.Utils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;

class AtomEditorCheckBox
extends JCheckBox
implements AtomEditorEditors {
    private String name;
    private AtomEditor parent;
    private ActionListener[] listeners;

    AtomEditorCheckBox(String name, boolean bini, AtomEditor parent) {
        this.setSelected(bini);
        this.name = name;
        this.parent = parent;
        this.addListener();
    }

    public void removeListeners() {
        this.listeners = this.getActionListeners();
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.length; ++i) {
            this.removeActionListener(this.listeners[i]);
        }
    }

    public void restoreListeners() {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.length; ++i) {
            this.addActionListener(this.listeners[i]);
        }
    }

    private void addListener() {
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AtomEditorCheckBox.this.parent.doIt();
            }
        });
    }

    public String getValue() {
        return this.isSelected() ? "1" : "0";
    }

    public String getIdentifiers() {
        return this.name;
    }

    public void setValue(String value) {
        boolean bval = Utils.getBool(value);
        this.setSelected(bval);
    }
}

