/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.scenegraphelements;

import ciss.phase_viewer.acviewer.geom.Plane;
import ciss.phase_viewer.acviewer.geom.Sorter;
import ciss.phase_viewer.atomcoord.VolumetricData;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.apache.log4j.Logger;

public class PartitionedCell {
    private Logger logger = Logger.getLogger(PartitionedCell.class.getName());
    private Point3f[] vertices = new Point3f[8];
    private float[] vertexValues = new float[8];
    private int[][] sides = new int[][]{{0, 1}, {1, 2}, {2, 3}, {3, 0}, {4, 5}, {5, 6}, {6, 7}, {7, 4}, {0, 4}, {1, 5}, {2, 6}, {3, 7}};
    private int[][] planes = new int[][]{{0, 1, 2, 3}, {4, 5, 6, 7}, {0, 8, 4, 9}, {1, 10, 5, 9}, {2, 11, 6, 10}, {3, 11, 7, 8}};
    private static final int[][] sidePlaneTable = new int[][]{{0, 2}, {0, 3}, {0, 4}, {0, 5}, {1, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 5}, {2, 3}, {3, 4}, {4, 5}};
    private float[][][][] coordinates;
    private float[][][] value;
    private Plane[] clippingPlane;
    private float[] origin = new float[]{0.0f, 0.0f, 0.0f};
    private double epsilon = 1.0E-5;

    public PartitionedCell(float[][][][] coordinates, float[][][] value) {
        this.coordinates = coordinates;
        this.value = value;
    }

    public boolean setData(int a, int b, int c) {
        int a1 = a + 1;
        int b1 = b + 1;
        int c1 = c + 1;
        this.vertices[0] = new Point3f(this.coordinates[a][b][c]);
        this.vertices[1] = new Point3f(this.coordinates[a1][b][c]);
        this.vertices[2] = new Point3f(this.coordinates[a1][b1][c]);
        this.vertices[3] = new Point3f(this.coordinates[a][b1][c]);
        this.vertices[4] = new Point3f(this.coordinates[a][b][c1]);
        this.vertices[5] = new Point3f(this.coordinates[a1][b][c1]);
        this.vertices[6] = new Point3f(this.coordinates[a1][b1][c1]);
        this.vertices[7] = new Point3f(this.coordinates[a][b1][c1]);
        boolean foo = true;
        if (this.value != null) {
            this.vertexValues[0] = this.value[a][b][c];
            this.vertexValues[1] = this.value[a1][b][c];
            this.vertexValues[2] = this.value[a1][b1][c];
            this.vertexValues[3] = this.value[a][b1][c];
            this.vertexValues[4] = this.value[a][b][c1];
            this.vertexValues[5] = this.value[a1][b][c1];
            this.vertexValues[6] = this.value[a1][b1][c1];
            this.vertexValues[7] = this.value[a][b1][c1];
            for (int i = 0; i < this.vertexValues.length; ++i) {
                if (this.vertexValues[i] == VolumetricData.meaninglessValue) continue;
                foo = true;
            }
        }
        return foo;
    }

    public void setClippingPlane(Plane[] clippingPlane) {
        this.clippingPlane = clippingPlane;
    }

    public void setClippingPlane(Plane[] clippingPlane, float[] origin) {
        this.clippingPlane = clippingPlane;
        this.origin = origin;
    }

    private boolean planeCrosses(Plane plane) {
        float dw;
        Point3f origin = plane.getOrigin();
        Point3f norm = plane.getNormalVector();
        Vector3f normal = new Vector3f((Tuple3f)norm);
        float d = this.vertices[0].distance(this.vertices[6]);
        if (d < (dw = this.vertices[2].distance(this.vertices[4]))) {
            d = dw;
        }
        if (d < (dw = this.vertices[3].distance(this.vertices[5]))) {
            d = dw;
        }
        if (d < (dw = this.vertices[1].distance(this.vertices[7]))) {
            d = dw;
        }
        d /= 2.0f;
        float cellCenterX = 0.0f;
        for (int i = 0; i < 8; ++i) {
            cellCenterX += this.vertices[i].x;
        }
        cellCenterX /= 8.0f;
        float cellCenterY = 0.0f;
        for (int i = 0; i < 8; ++i) {
            cellCenterY += this.vertices[i].y;
        }
        cellCenterY /= 8.0f;
        float cellCenterZ = 0.0f;
        for (int i = 0; i < 8; ++i) {
            cellCenterZ += this.vertices[i].z;
        }
        Vector3f p = new Vector3f(cellCenterX - origin.x, cellCenterY - origin.y, (cellCenterZ /= 8.0f) - origin.z);
        float h = Math.abs(p.dot(normal));
        return h < d;
    }

    public int doPlaneCross(Plane plane, Vector valueVector, Vector posVector) {
        int i;
        if (!this.planeCrosses(plane)) {
            return -1;
        }
        int sizeh = 0;
        boolean crossed = false;
        Vector<float[]> tmppos = new Vector<float[]>();
        Vector<Float> tmpval = new Vector<Float>();
        for (int i2 = 0; i2 < this.sides.length; ++i2) {
            int[] vertind = this.sides[i2];
            Point3f p1 = this.vertices[vertind[0]];
            Point3f p2 = this.vertices[vertind[1]];
            float v1 = this.vertexValues[vertind[0]];
            float v2 = this.vertexValues[vertind[1]];
            float d1 = plane.getDistanceFrom(p1);
            float d2 = plane.getDistanceFrom(p2);
            if (d1 == 0.0f && d2 != 0.0f) {
                tmppos.addElement(new float[]{p1.x, p1.y, p1.z});
                tmpval.addElement(new Float(v1));
                continue;
            }
            if (d2 == 0.0f && d1 != 0.0f) {
                tmppos.addElement(new float[]{p2.x, p2.y, p2.z});
                tmpval.addElement(new Float(v2));
                continue;
            }
            if (d2 == 0.0f && d1 == 0.0f) {
                tmppos.addElement(new float[]{p1.x, p1.y, p1.z});
                tmppos.addElement(new float[]{p2.x, p2.y, p2.z});
                tmpval.addElement(new Float(v1));
                tmpval.addElement(new Float(v2));
                continue;
            }
            if (!(d1 < 0.0f && d2 > 0.0f) && (!(d1 > 0.0f) || !(d2 < 0.0f))) continue;
            float ad1 = Math.abs(d1);
            float ad2 = Math.abs(d2);
            float scale = ad1 / (ad1 + ad2);
            Point3f p3 = new Point3f();
            Point3f tmp = new Point3f();
            tmp.sub((Tuple3f)p2, (Tuple3f)p1);
            p3.scaleAdd(scale, (Tuple3f)tmp, (Tuple3f)p1);
            tmppos.addElement(new float[]{p3.x, p3.y, p3.z});
            float v3 = v1 + scale * (v2 - v1);
            tmpval.addElement(new Float(v3));
        }
        if (tmppos.size() < 3) {
            return -1;
        }
        Vector vec = Sorter.radiallyClockWise(tmppos, tmpval, false);
        if (vec == null) {
            return -1;
        }
        sizeh = vec.size() / 2;
        Vector<float[]> tmpposvec = new Vector<float[]>();
        Vector<Float> tmpvalvec = new Vector<Float>();
        for (i = 0; i < sizeh; ++i) {
            float[] p = (float[])vec.elementAt(i);
            tmpposvec.addElement(p);
        }
        for (i = 0; i < sizeh; ++i) {
            Float fl = (Float)vec.elementAt(i + sizeh);
            tmpvalvec.addElement(fl);
        }
        if (this.clippingPlane != null && this.clippingPlane.length != 0) {
            this.doClip(tmpposvec, tmpvalvec);
        }
        if (tmpposvec.size() < 3) {
            return -1;
        }
        for (i = 0; i < tmpposvec.size(); ++i) {
            posVector.addElement(new Point3f((float[])tmpposvec.get(i)));
        }
        for (i = 0; i < tmpvalvec.size(); ++i) {
            valueVector.addElement(tmpvalvec.get(i));
        }
        return tmpposvec.size();
    }

    private void doClip(Vector posVector, Vector valueVector) {
        int i;
        if (posVector.size() == 1) {
            return;
        }
        float[][] points = new float[posVector.size()][];
        Object[] vals = new Float[valueVector.size()];
        float dbg = 1.0f;
        posVector.copyInto((Object[])points);
        valueVector.copyInto(vals);
        boolean changed = false;
        Point3f genten = new Point3f(0.0f, 0.0f, 0.0f);
        Point3f orig = new Point3f(this.origin);
        for (int i2 = 0; i2 < points.length; ++i2) {
            float newval;
            float scale;
            Point3f newPoint;
            int ind;
            Point3f p1 = new Point3f(points[i2]);
            int secondIndex = i2 + 1;
            if (i2 == points.length - 1) {
                secondIndex = 0;
            }
            Point3f p2 = new Point3f(points[secondIndex]);
            int count1 = 0;
            int count2 = 0;
            float nearest1 = 10000.0f;
            float nearest2 = 10000.0f;
            Plane nearestPlane1 = null;
            Plane nearestPlane2 = null;
            int nearestPlaneIndex1 = -1;
            int nearestPlaneIndex2 = -1;
            for (int j = 0; j < this.clippingPlane.length; ++j) {
                Plane pl = this.clippingPlane[j];
                float dg = pl.getDistanceFrom(genten);
                float d1 = pl.getDistanceFrom(p1);
                float d2 = pl.getDistanceFrom(p2);
                if (Math.abs(nearest1) > Math.abs(d1)) {
                    nearest1 = d1;
                    nearestPlane1 = pl;
                }
                if (Math.abs(nearest2) > Math.abs(d2)) {
                    nearest2 = d2;
                    nearestPlane2 = pl;
                }
                if (d1 > 0.0f && dg > 0.0f || d1 < 0.0f && dg < 0.0f) {
                    ++count1;
                }
                if (!(d2 > 0.0f && dg > 0.0f) && (!(d2 < 0.0f) || !(dg < 0.0f))) continue;
                ++count2;
            }
            nearest1 = nearestPlane1.getDistanceFrom(p1);
            nearest2 = nearestPlane2.getDistanceFrom(p2);
            if (count1 == this.clippingPlane.length && count2 == this.clippingPlane.length) continue;
            if (count1 != this.clippingPlane.length && count2 != this.clippingPlane.length) {
                int ind2;
                changed = true;
                int ind1 = posVector.indexOf(points[i2]);
                if (ind1 >= 0) {
                    posVector.remove(ind1);
                    valueVector.remove(ind1);
                }
                if ((ind2 = posVector.indexOf(points[secondIndex])) < 0) continue;
                posVector.remove(ind2);
                valueVector.remove(ind2);
                continue;
            }
            changed = true;
            if (count1 != this.clippingPlane.length) {
                ind = posVector.indexOf(points[i2]);
                if (ind >= 0) {
                    posVector.remove(ind);
                    valueVector.remove(ind);
                }
                newPoint = new Point3f();
                newPoint.sub((Tuple3f)p1, (Tuple3f)p2);
                scale = Math.abs(nearest2) / (Math.abs(nearest1) + Math.abs(nearest2));
                newPoint.scale(scale);
                Point3f foo = new Point3f();
                foo.add((Tuple3f)newPoint, (Tuple3f)p2);
                newval = (((Float)vals[i2]).floatValue() - ((Float)vals[secondIndex]).floatValue()) * scale + ((Float)vals[secondIndex]).floatValue();
                posVector.add(new float[]{foo.x, foo.y, foo.z});
                valueVector.add(new Float(newval));
                continue;
            }
            if (count2 == this.clippingPlane.length) continue;
            ind = posVector.indexOf(points[secondIndex]);
            if (ind >= 0) {
                posVector.remove(ind);
                valueVector.remove(ind);
            }
            newPoint = new Point3f();
            newPoint.sub((Tuple3f)p2, (Tuple3f)p1);
            scale = Math.abs(nearest1) / (Math.abs(nearest1) + Math.abs(nearest2));
            newPoint.scale(scale);
            Point3f foo = new Point3f();
            foo.add((Tuple3f)newPoint, (Tuple3f)p1);
            newval = (((Float)vals[secondIndex]).floatValue() - ((Float)vals[i2]).floatValue()) * scale + ((Float)vals[i2]).floatValue();
            posVector.add(new float[]{foo.x, foo.y, foo.z});
            valueVector.add(new Float(newval));
        }
        if (!changed) {
            return;
        }
        Vector vec = Sorter.radiallyClockWise(posVector, valueVector, false);
        posVector.clear();
        valueVector.clear();
        if (vec == null) {
            return;
        }
        int sizeh = vec.size() / 2;
        for (i = 0; i < sizeh; ++i) {
            float[] p = (float[])vec.elementAt(i);
            posVector.addElement(p);
        }
        for (i = 0; i < sizeh; ++i) {
            Float fl = (Float)vec.elementAt(i + sizeh);
            valueVector.addElement(fl);
        }
    }
}

