/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.scenegraphelements;

import ciss.phase_viewer.acviewer.scenegraphelements.DynamicallyEditable;
import ciss.phase_viewer.acviewer.scenegraphelements.SceneGraphElement;
import java.awt.event.InputEvent;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.apache.log4j.Logger;

public abstract class DynamicallyEditableTG
extends SceneGraphElement
implements DynamicallyEditable {
    private Logger logger = Logger.getLogger(DynamicallyEditableTG.class.getName());
    protected TransformGroup transformBuffer;
    protected BranchGroup buffer;

    protected boolean isDynamicallyEditable() {
        return true;
    }

    protected boolean initializationNecessary() {
        return true;
    }

    protected boolean intermediateStateNecessary() {
        return true;
    }

    protected boolean finalizationNecessary() {
        return true;
    }

    public void dynamicallyEditInitialize(TransformGroup parent) {
        if (!this.isDynamicallyEditable() || !this.initializationNecessary()) {
            return;
        }
    }

    public void dynamicallyEditIntermediateState(Transform3D diff, TransformGroup parent, InputEvent event) {
        if (!this.isDynamicallyEditable() || !this.intermediateStateNecessary()) {
            return;
        }
        this.logger.debug("dynamically editing scene (intermediate state) ");
        this.preIntermediateState(diff, parent, event);
        Transform3D parentTransform = new Transform3D();
        parent.getTransform(parentTransform);
        Vector3d parentTranslate = new Vector3d();
        Matrix3d parentRotate = new Matrix3d();
        parentTransform.get(parentRotate, parentTranslate);
        parentTransform.invert();
        Vector3d diffTranslate = new Vector3d();
        Matrix3d diffRotate = new Matrix3d();
        diff.get(diffRotate, diffTranslate);
        Transform3D bufferTransform = new Transform3D();
        this.transformBuffer.getTransform(bufferTransform);
        Vector3d bufferTranslate = new Vector3d();
        Matrix3d bufferRotate = new Matrix3d();
        bufferTransform.get(bufferRotate, bufferTranslate);
        Point3d point = new Point3d();
        point.x = diffTranslate.x + parentTranslate.x;
        point.y = diffTranslate.y + parentTranslate.y;
        point.z = diffTranslate.z + parentTranslate.z;
        parentTransform.transform(point);
        bufferTranslate.x += point.x;
        bufferTranslate.y += point.y;
        bufferTranslate.z += point.z;
        bufferTransform.setTranslation(bufferTranslate);
        bufferTransform.setRotation(bufferRotate);
        this.transformBuffer.setTransform(bufferTransform);
        this.buffer.detach();
        parent.addChild((Node)this.buffer);
        this.postIntermediateState(diff, parent, event);
    }

    protected void postIntermediateState(Transform3D diff, TransformGroup parent, InputEvent event) {
    }

    protected void preIntermediateState(Transform3D diff, TransformGroup parent, InputEvent event) {
    }

    public void dynamicallyEditFinalize(TransformGroup parent) {
        if (!this.isDynamicallyEditable() || !this.finalizationNecessary()) {
            return;
        }
    }

    public TransformGroup getTransformBuffer() {
        return this.transformBuffer;
    }

    public BranchGroup getBuffer() {
        return this.buffer;
    }

    public abstract void createBuffer();
}

