/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.geom;

import ciss.phase_viewer.acviewer.geom.AngComp;
import ciss.phase_viewer.common.VectorOperations;
import java.util.Arrays;
import java.util.Vector;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3f;
import org.apache.log4j.Logger;

public class Sorter {
    private static Logger logger = Logger.getLogger(Sorter.class.getName());

    private Sorter() {
    }

    public static Point3f[] radiallyClockWise(Point3f[] data) {
        if (data == null) {
            return null;
        }
        Vector<float[]> vec = new Vector<float[]>();
        for (int i = 0; i < data.length; ++i) {
            float[] fld = new float[]{data[i].x, data[i].y, data[i].z};
            vec.addElement(fld);
        }
        Vector retvec = Sorter.radiallyClockWise(vec, null);
        float[][] fret = new float[retvec.size()][];
        retvec.copyInto((Object[])fret);
        Point3f[] pret = new Point3f[fret.length];
        for (int i = 0; i < fret.length; ++i) {
            pret[i] = new Point3f(fret[i]);
        }
        return pret;
    }

    public static Vector radiallyClockWise(Vector data, Vector associatedData) {
        return Sorter.radiallyClockWise(data, associatedData, false);
    }

    public static Vector radiallyClockWise(Vector data, Vector associatedData, boolean counterClockWise) {
        int i;
        int i2;
        int i3;
        float verySmall = 1.0E-6f;
        float small = 0.001f;
        if (data == null || data.size() <= 2) {
            return null;
        }
        Object[] fdata = new Object[data.size()];
        data.copyInto(fdata);
        float[] f0 = (float[])fdata[0];
        int dim = f0.length;
        Object[] assobj = null;
        if (associatedData != null && associatedData.size() != 0) {
            assobj = new Object[associatedData.size()];
            associatedData.copyInto(assobj);
        }
        float[][] buff = new float[data.size()][f0.length];
        for (i3 = 0; i3 < buff.length; ++i3) {
            for (int j = 0; j < dim; ++j) {
                buff[i3][j] = 0.0f;
            }
        }
        for (i3 = 0; i3 < data.size(); ++i3) {
            float[] fld = (float[])data.get(i3);
            for (int j = 0; j < dim; ++j) {
                buff[i3][j] = fld[j];
            }
        }
        int ind1 = 0;
        int ind2 = 1;
        boolean xissame = true;
        boolean yissame = true;
        boolean zissame = true;
        for (int i4 = 0; i4 < fdata.length - 1; ++i4) {
            float[] flidat = (float[])fdata[i4];
            for (int j = i4 + 1; j < fdata.length; ++j) {
                float[] fljdat = (float[])fdata[j];
                for (int k = 0; k < fljdat.length; ++k) {
                    if (Math.abs(flidat[0] - fljdat[0]) > verySmall) {
                        xissame = false;
                    }
                    if (Math.abs(flidat[1] - fljdat[1]) > verySmall) {
                        yissame = false;
                    }
                    if (!(Math.abs(flidat[2] - fljdat[2]) > verySmall)) continue;
                    zissame = false;
                }
            }
        }
        float[] f1 = (float[])fdata[1];
        float[] nor = VectorOperations.getNormalVector(f0, f1);
        Transform3D t3d = new Transform3D();
        t3d.rotX(0.5235987755982988);
        t3d.rotY(0.5235987755982988);
        for (int i5 = 0; i5 < buff.length; ++i5) {
            Point3f p = new Point3f(buff[i5][0], buff[i5][1], buff[i5][2]);
            Point3f out = new Point3f();
            t3d.transform(p, out);
            buff[i5][0] = out.x;
            buff[i5][1] = out.y;
            buff[i5][2] = out.z;
        }
        if (xissame) {
            ind1 = 1;
            ind2 = 2;
        }
        if (yissame) {
            ind1 = 0;
            ind2 = 2;
        }
        float[] origin = new float[dim];
        for (i2 = 0; i2 < dim; ++i2) {
            origin[i2] = 0.0f;
        }
        for (i2 = 0; i2 < buff.length; ++i2) {
            for (int j = 0; j < dim; ++j) {
                int n = j;
                origin[n] = origin[n] + buff[i2][j];
            }
        }
        i2 = 0;
        while (i2 < dim) {
            int n = i2++;
            origin[n] = origin[n] / (float)data.size();
        }
        float[] ref = new float[dim];
        for (int i6 = 0; i6 < ref.length; ++i6) {
            ref[i6] = buff[0][i6] - origin[i6];
        }
        float norm0 = VectorOperations.norm(ref);
        if (norm0 == 0.0f) {
            int i7 = 0;
            while (i7 < ref.length) {
                int n = i7++;
                ref[n] = ref[n] + verySmall;
            }
            norm0 = VectorOperations.norm(ref);
        }
        Object[] comp = new AngComp[data.size()];
        Object obj = null;
        if (assobj != null) {
            obj = assobj[0];
        }
        comp[0] = new AngComp(f0, obj, 0.0f, counterClockWise);
        for (int i8 = 1; i8 < buff.length; ++i8) {
            float cosine;
            float[] refi = new float[dim];
            for (int j = 0; j < dim; ++j) {
                refi[j] = buff[i8][j] - origin[j];
            }
            float normi = VectorOperations.norm(refi);
            if (normi == 0.0f) {
                normi = 1.0E-8f;
            }
            if ((cosine = VectorOperations.dotProduct(refi, ref) / (normi * norm0)) > 1.0f) {
                cosine = 1.0f;
            }
            if (cosine < -1.0f) {
                cosine = -1.0f;
            }
            float ang = (float)Math.acos(cosine);
            float foo = ref[ind1] * refi[ind2] - refi[ind1] * ref[ind2];
            if (foo < 0.0f) {
                ang = (float)Math.PI * 2 - ang;
            }
            float[] fldata = (float[])data.get(i8);
            Object obje = null;
            if (assobj != null) {
                obje = assobj[i8];
            }
            comp[i8] = new AngComp(fldata, obje, ang, counterClockWise);
        }
        Arrays.sort(comp);
        Vector<Object> retvec = new Vector<Object>();
        for (i = 0; i < comp.length; ++i) {
            retvec.addElement(((AngComp)comp[i]).getVal());
            logger.debug("i, ang: " + i + "," + (double)((AngComp)comp[i]).getAngle() * 57.29577951308232);
        }
        if (assobj != null) {
            for (i = 0; i < comp.length; ++i) {
                retvec.addElement(((AngComp)comp[i]).getAssociatedData());
            }
        }
        return retvec;
    }
}

