/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jfree.data.statistics.BoxAndWhiskerItem;

public class BoxAndWhiskerCalculator {
    public static BoxAndWhiskerItem calculateBoxAndWhiskerStatistics(List values) {
        Collections.sort(values);
        double mean = BoxAndWhiskerCalculator.calculateMean(values);
        double median = BoxAndWhiskerCalculator.calculateMedian(values);
        double q1 = BoxAndWhiskerCalculator.calculateQ1(values);
        double q3 = BoxAndWhiskerCalculator.calculateQ3(values);
        double interQuartileRange = q3 - q1;
        double upperOutlierThreshold = q3 + interQuartileRange * 1.5;
        double lowerOutlierThreshold = q1 - interQuartileRange * 1.5;
        double upperFaroutThreshold = q3 + interQuartileRange * 2.0;
        double lowerFaroutThreshold = q1 - interQuartileRange * 2.0;
        double minRegularValue = Double.POSITIVE_INFINITY;
        double maxRegularValue = Double.NEGATIVE_INFINITY;
        double minOutlier = Double.POSITIVE_INFINITY;
        double maxOutlier = Double.NEGATIVE_INFINITY;
        ArrayList<Number> outliers = new ArrayList<Number>();
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object == null || !(object instanceof Number)) continue;
            Number number = (Number)object;
            double value = number.doubleValue();
            if (value > upperOutlierThreshold) {
                outliers.add(number);
                if (!(value > maxOutlier) || !(value <= upperFaroutThreshold)) continue;
                maxOutlier = value;
                continue;
            }
            if (value < lowerOutlierThreshold) {
                outliers.add(number);
                if (!(value < minOutlier) || !(value >= lowerFaroutThreshold)) continue;
                minOutlier = value;
                continue;
            }
            minRegularValue = minRegularValue == Double.NaN ? value : Math.min(minRegularValue, value);
            if (maxRegularValue == Double.NaN) {
                maxRegularValue = value;
                continue;
            }
            maxRegularValue = Math.max(maxRegularValue, value);
        }
        minOutlier = Math.min(minOutlier, minRegularValue);
        maxOutlier = Math.max(maxOutlier, maxRegularValue);
        return new BoxAndWhiskerItem(new Double(mean), new Double(median), new Double(q1), new Double(q3), new Double(minRegularValue), new Double(maxRegularValue), new Double(minOutlier), new Double(maxOutlier), outliers);
    }

    public static double calculateMean(List values) {
        double result = Double.NaN;
        int count = 0;
        double total = 0.0;
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object == null || !(object instanceof Number)) continue;
            Number number = (Number)object;
            total += number.doubleValue();
            ++count;
        }
        if (count > 0) {
            result = total / (double)count;
        }
        return result;
    }

    public static double calculateMedian(List values) {
        return BoxAndWhiskerCalculator.calculateMedian(values, 0, values.size() - 1);
    }

    public static double calculateMedian(List values, int start, int end) {
        double result = Double.NaN;
        int count = end - start + 1;
        if (count > 0) {
            if (count % 2 == 1) {
                if (count > 1) {
                    Number value = (Number)values.get(start + (count - 1) / 2);
                    result = value.doubleValue();
                } else {
                    Number value = (Number)values.get(start);
                    result = value.doubleValue();
                }
            } else {
                Number value1 = (Number)values.get(start + count / 2 - 1);
                Number value2 = (Number)values.get(start + count / 2);
                result = (value1.doubleValue() + value2.doubleValue()) / 2.0;
            }
        }
        return result;
    }

    public static double calculateQ1(List values) {
        double result = Double.NaN;
        int count = values.size();
        if (count > 0) {
            result = count % 2 == 1 ? (count > 1 ? BoxAndWhiskerCalculator.calculateMedian(values, 0, count / 2) : BoxAndWhiskerCalculator.calculateMedian(values, 0, 0)) : BoxAndWhiskerCalculator.calculateMedian(values, 0, count / 2);
        }
        return result;
    }

    public static double calculateQ3(List values) {
        double result = Double.NaN;
        int count = values.size();
        if (count > 0) {
            result = count % 2 == 1 ? (count > 1 ? BoxAndWhiskerCalculator.calculateMedian(values, count / 2 + 1, count - 1) : BoxAndWhiskerCalculator.calculateMedian(values, 0, 0)) : BoxAndWhiskerCalculator.calculateMedian(values, count / 2 + 1, count - 1);
        }
        return result;
    }
}

