/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.jfree.chart.plot.PieLabelRecord;

public class PieLabelDistributor {
    private List labels;
    private double minGap = 4.0;
    static Logger logger = Logger.getLogger((Class)(class$org$jfree$chart$plot$PieLabelDistributor == null ? (class$org$jfree$chart$plot$PieLabelDistributor = PieLabelDistributor.class$("org.jfree.chart.plot.PieLabelDistributor")) : class$org$jfree$chart$plot$PieLabelDistributor));
    static /* synthetic */ Class class$org$jfree$chart$plot$PieLabelDistributor;

    public PieLabelDistributor(int labelCount) {
        this.labels = new ArrayList(labelCount);
    }

    public PieLabelRecord getPieLabelRecord(int index) {
        return (PieLabelRecord)this.labels.get(index);
    }

    public void addPieLabelRecord(PieLabelRecord record) {
        this.labels.add(record);
    }

    public int getItemCount() {
        return this.labels.size();
    }

    public void distributeLabels(double minY, double height) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entered distributeLabels() method.");
            logger.debug((Object)this.toString());
        }
        this.sort();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"After sorting...");
            logger.debug((Object)this.toString());
        }
        if (this.isOverlap()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"First overlapping label test triggered.");
            }
            this.adjustInwards();
        }
        if (this.isOverlap()) {
            double y = minY;
            double sumOfLabelHeights = 0.0;
            for (int i = 0; i < this.labels.size(); ++i) {
                sumOfLabelHeights += this.getPieLabelRecord(i).getLabelHeight();
            }
            double gap = height - sumOfLabelHeights;
            if (this.labels.size() > 1) {
                gap /= (double)(this.labels.size() - 1);
            }
            for (int i = 0; i < this.labels.size(); ++i) {
                PieLabelRecord record = this.getPieLabelRecord(i);
                record.setAllocatedY(y += record.getLabelHeight() / 2.0);
                y = y + record.getLabelHeight() / 2.0 + gap;
            }
        }
    }

    private boolean isOverlap() {
        double y = 0.0;
        for (int i = 0; i < this.labels.size(); ++i) {
            PieLabelRecord plr = this.getPieLabelRecord(i);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("y = " + y + ", plr.getLowerY() = " + plr.getLowerY()));
            }
            if (y > plr.getLowerY()) {
                return true;
            }
            y = plr.getUpperY();
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("y is now " + y));
        }
        return false;
    }

    protected void adjustInwards() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering adjustInwards() method.");
        }
        int lower = 0;
        for (int upper = this.labels.size() - 1; upper > lower; ++lower, --upper) {
            double adjust;
            if (lower < upper - 1) {
                PieLabelRecord r0 = this.getPieLabelRecord(lower);
                PieLabelRecord r1 = this.getPieLabelRecord(lower + 1);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("r0.getAllocatedY() = " + r0.getAllocatedY()));
                    logger.debug((Object)("r1.getAllocatedY() = " + r1.getAllocatedY()));
                }
                if (r1.getLowerY() < r0.getUpperY()) {
                    adjust = r0.getUpperY() - r1.getLowerY() + this.minGap;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Adjust r1 DOWN by " + adjust));
                    }
                    r1.setAllocatedY(r1.getAllocatedY() + adjust);
                }
            }
            PieLabelRecord r2 = this.getPieLabelRecord(upper - 1);
            PieLabelRecord r3 = this.getPieLabelRecord(upper);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("r2.getAllocatedY() = " + r2.getAllocatedY()));
                logger.debug((Object)("r3.getAllocatedY() = " + r3.getAllocatedY()));
            }
            if (!(r2.getUpperY() > r3.getLowerY())) continue;
            adjust = r2.getUpperY() - r3.getLowerY() + this.minGap;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adjust r2 UP by " + adjust));
            }
            r2.setAllocatedY(r2.getAllocatedY() - adjust);
        }
    }

    public void sort() {
        Collections.sort(this.labels);
    }

    public String toString() {
        String result = "";
        for (int i = 0; i < this.labels.size(); ++i) {
            result = result + this.getPieLabelRecord(i).toString() + "\n";
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

