/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.projectbrowser.projectdirbrowser;

import java.awt.Dimension;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jp.advancesoft.chase.projectbrowser.ProjectBrowser;
import jp.advancesoft.chase.projectbrowser.ProjectInfo;
import jp.advancesoft.chase.projectbrowser.ProjectManipulator;
import jp.advancesoft.chase.projectbrowser.projectcreator.NewProjectCreator;
import jp.advancesoft.chase.projectbrowser.projectcreator.NewSubProjectCreator;
import jp.advancesoft.chase.projectbrowser.projectcreator.ProjectRemover;
import jp.advancesoft.chase.projectbrowser.projectcreator.ProjectStateChangeEvent;
import jp.advancesoft.chase.projectbrowser.projectcreator.ProjectStateChangeListener;
import jp.advancesoft.chase.projectbrowser.projectdirbrowser.MouseAdapterProjectDirBrowser;
import jp.advancesoft.chase.projectbrowser.projectdirbrowser.MyTreeModelListener;
import jp.advancesoft.chase.projectbrowser.projectdirbrowser.ProjectDirBrowserNode;
import jp.advancesoft.chase.projectbrowser.projectdirbrowser.ProjectDirBrowserNodeChangeEvent;
import jp.advancesoft.chase.projectbrowser.projectdirbrowser.ProjectDirBrowserNodeChangeListener;
import jp.advancesoft.chase.projectbrowser.projectdirbrowser.ProjectDirBrowserRenderer;
import jp.advancesoft.chase.settings.GlobalProperties;
import jp.advancesoft.chase.settings.PropertiesManager;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class ProjectDirBrowser
extends JPanel
implements ProjectDirBrowserNodeChangeListener,
ProjectStateChangeListener {
    private Logger logger = Logger.getLogger(ProjectDirBrowser.class.getName());
    private JSplitPane splitpane;
    private JTree tree;
    private DefaultTreeModel treeModel;
    private ProjectDirBrowserNode rootNode;
    private ProjectBrowser parent;
    private Document doc;
    private String myproj = System.getProperty("user.home") + System.getProperty("file.separator") + ".chase" + System.getProperty("file.separator") + "my_projects.xml";
    private boolean reuse = true;
    private GlobalProperties gp = PropertiesManager.getGlobalProperties(0);

    public ProjectDirBrowser(String title) {
        this.setBorder(new TitledBorder(title));
        this.setLayout(new BoxLayout(this, 1));
        this.reuse = new Boolean(this.gp.getProperty("project_browser_reuse_window"));
        this.init();
    }

    public void setProjectBrowser(ProjectBrowser parent) {
        this.parent = parent;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void nodeSelected(ProjectDirBrowserNodeChangeEvent e) {
        ProjectManipulator component;
        ProjectInfo proj;
        ProjectDirBrowserNode node;
        block9: {
            if (e == null) return;
            if (e.getSource() == null) {
                return;
            }
            node = (ProjectDirBrowserNode)e.getSource();
            proj = node.getProjectInfo();
            component = null;
            if (proj != null && (component = ProjectManipulator.createProjectManipulator(proj)) == null) {
                return;
            }
            if (!this.reuse) {
                if (node.getProjectBrowser() == null || !node.getProjectBrowser().isVisible()) {
                    this.parent = new ProjectBrowser(new Dimension(800, 600), proj);
                    break block9;
                } else {
                    if (node.getProjectBrowser().isSelected()) return;
                    try {
                        node.getProjectBrowser().setSelected(true);
                        return;
                    }
                    catch (PropertyVetoException vpe) {
                        // empty catch block
                    }
                    return;
                }
            }
            if (this.parent == null || !this.parent.isVisible()) {
                this.parent = new ProjectBrowser(new Dimension(800, 600), proj);
            }
            this.parent.setTitle(proj.getProjectName());
        }
        if (component != null) {
            component.init();
            this.parent.setProjectManipulator(component);
            this.parent.registerProjectManipulators(component);
        }
        proj.setParent(this.parent);
        node.setProjectBrowser(this.parent);
        this.parent.revalidate();
    }

    public void projectStateChanged(ProjectStateChangeEvent e) {
        this.updateTree();
        String selectMe = e.select();
        if (selectMe != null && selectMe.length() != 0) {
            TreePath path = this.tree.getNextMatch(selectMe, this.tree.getSelectionRows()[0], Position.Bias.Forward);
            this.tree.setSelectionPath(path);
            this.logger.debug("new proj path: " + path);
        }
    }

    private void updateTree() {
        this.tree.revalidate();
        this.tree.repaint();
    }

    public ProjectInfo getSelectedProject() {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            this.logger.warn("no project selected.");
            return null;
        }
        Object o2 = path.getLastPathComponent();
        ProjectInfo ret = null;
        if (o2 instanceof ProjectDirBrowserNode) {
            ret = ((ProjectDirBrowserNode)o2).getProjectInfo();
        }
        return ret;
    }

    public ProjectInfo getRootProject() {
        TreePath path = this.tree.getPathForRow(0);
        Object o2 = path.getPathComponent(0);
        ProjectInfo ret = null;
        if (o2 instanceof ProjectDirBrowserNode) {
            ret = ((ProjectDirBrowserNode)o2).getProjectInfo();
        }
        return ret;
    }

    public ProjectDirBrowserNode getRootNode() {
        return this.rootNode;
    }

    public ProjectDirBrowserNode getSelectedNode() {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            this.logger.warn("no project selected.");
            return null;
        }
        Object o2 = path.getLastPathComponent();
        ProjectDirBrowserNode ret = null;
        if (o2 instanceof ProjectDirBrowserNode) {
            ret = (ProjectDirBrowserNode)o2;
        }
        return ret;
    }

    public JTree getTree() {
        return this.tree;
    }

    public void saveTo(File file) {
        try {
            this.logger.debug("saving output.");
            FileWriter writer = new FileWriter(System.getProperty("user.home") + System.getProperty("file.separator") + "foobar.xml");
            XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
            outputter.output(this.doc, (Writer)writer);
        }
        catch (IOException ioe) {
            this.logger.error("failed to save file transfer scheme to disk.");
            ioe.printStackTrace();
            return;
        }
    }

    public static TreePath getPath(TreeNode node) {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        while (node != null) {
            list.add(node);
            node = node.getParent();
        }
        Collections.reverse(list);
        return new TreePath(list.toArray());
    }

    private void init() {
        this.doc = ProjectBrowser.getDocument(new File(this.myproj));
        Element root = this.doc.getRootElement();
        this.rootNode = new ProjectDirBrowserNode(root, this);
        this.rootNode.addProjectDirBrowserNodeChangeListener(this);
        this.logger.debug(this.rootNode);
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.treeModel.addTreeModelListener(new MyTreeModelListener());
        this.tree = new JTree(this.treeModel);
        this.tree.addMouseListener(new MouseAdapterProjectDirBrowser(this));
        this.tree.setCellRenderer(new ProjectDirBrowserRenderer());
        this.tree.setShowsRootHandles(true);
        JScrollPane scrpane = new JScrollPane(this.tree);
        this.addToTree(root, this.rootNode);
        TreePath path = this.tree.getPathForRow(0);
        this.tree.expandPath(path);
        this.setExpanded(this.rootNode);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(scrpane);
        super.add(p);
    }

    private void setExpanded(ProjectDirBrowserNode node) {
        int numChild = node.getChildCount();
        for (int i = 0; i < numChild; ++i) {
            ProjectDirBrowserNode cnode = (ProjectDirBrowserNode)node.getChildAt(i);
            if (cnode.isExpanded()) {
                this.logger.debug("node is expanded...");
                this.tree.scrollPathToVisible(new TreePath(cnode.getPath()));
            }
            if (cnode.isSelected()) {
                this.logger.debug("node is selected...");
                this.tree.setSelectionPath(new TreePath(cnode.getPath()));
                cnode.selectMe();
            }
            this.setExpanded(cnode);
        }
    }

    private void addToTree(Element element, ProjectDirBrowserNode node) {
        String hasSub = element.getAttributeValue("hassub");
        boolean bhasSub = false;
        if (hasSub != null) {
            bhasSub = new Boolean(hasSub);
        }
        if (bhasSub) {
            List list = element.getChildren();
            for (int i = 0; i < list.size(); ++i) {
                this.logger.debug("processing nodes for element: " + list.get(i));
                Element tmpelement = (Element)list.get(i);
                String disp = tmpelement.getAttributeValue("display");
                boolean bdisp = false;
                if (disp != null) {
                    bdisp = new Boolean(disp);
                }
                if (!bdisp) continue;
                ProjectDirBrowserNode tmpnode = new ProjectDirBrowserNode(tmpelement, this);
                tmpnode.addProjectDirBrowserNodeChangeListener(this);
                this.addToTree(tmpelement, tmpnode);
                node.add(tmpnode);
            }
        }
    }

    public void clear() {
        this.rootNode.removeAllChildren();
        this.treeModel.reload();
    }

    public void removeCurrentNode() {
        ProjectDirBrowserNode currentNode;
        ProjectDirBrowserNode parent;
        TreePath currentSelection = this.tree.getSelectionPath();
        if (currentSelection != null && (parent = (ProjectDirBrowserNode)(currentNode = (ProjectDirBrowserNode)currentSelection.getLastPathComponent()).getParent()) != null) {
            this.treeModel.removeNodeFromParent(currentNode);
            currentNode.getProjectElement().getParentElement().removeContent(currentNode.getProjectElement());
            return;
        }
    }

    public ProjectDirBrowserNode addObject(Object child) {
        ProjectDirBrowserNode parentNode = null;
        TreePath parentPath = this.tree.getSelectionPath();
        parentNode = parentPath == null ? this.rootNode : (ProjectDirBrowserNode)parentPath.getLastPathComponent();
        return this.addObject(parentNode, child, true);
    }

    public ProjectDirBrowserNode addObject(ProjectDirBrowserNode parent, Object child) {
        return this.addObject(parent, child, false);
    }

    public ProjectDirBrowserNode addObject(ProjectDirBrowserNode parent, Object child, boolean shouldBeVisible) {
        ProjectDirBrowserNode childNode = null;
        Element proj = parent.getProjectElement();
        ProjectInfo info = parent.getProjectInfo();
        if (child instanceof ProjectDirBrowserNode) {
            childNode = (ProjectDirBrowserNode)child;
        }
        if (parent == null) {
            parent = this.rootNode;
        }
        this.treeModel.insertNodeInto(childNode, parent, parent.getChildCount());
        try {
            proj.addContent(childNode.getProjectElement());
        }
        catch (Exception e) {
            // empty catch block
        }
        info.addSubProjectInfo(childNode.getProjectInfo());
        if (shouldBeVisible) {
            this.tree.scrollPathToVisible(new TreePath(childNode.getPath()));
        }
        return childNode;
    }

    public void bootProjectCreator() {
        ProjectDirBrowserNode nd = this.getSelectedNode();
        if (nd == null) {
            nd = this.getRootNode();
        }
        NewProjectCreator cr = new NewProjectCreator(nd, this);
        cr.addProjectStateChangeListener(this);
    }

    public void bootProjectRemover() {
        ProjectDirBrowserNode nd = this.getSelectedNode();
        if (nd == null) {
            this.logger.info("project dir not selected.");
            return;
        }
        if (nd == this.getRootNode()) {
            this.logger.info("root node can't be removed.");
            return;
        }
        if (nd.getProjectInfo().getInfoType() == 2) {
            this.logger.info("use `remove sub project' to remove sub projects.");
            return;
        }
        ProjectRemover rm = new ProjectRemover("remove project", nd, this);
        rm.addProjectStateChangeListener(this);
    }

    public void bootSubProjectRemover() {
        ProjectDirBrowserNode nd = this.getSelectedNode();
        if (nd == null) {
            this.logger.info("project dir not selected.");
            return;
        }
        if (nd == this.getRootNode()) {
            this.logger.info("root node can't be removed.");
            return;
        }
        if (nd.getProjectInfo().getInfoType() == 1) {
            this.logger.info("use `remove project' to remove projects.");
            return;
        }
        ProjectRemover rm = new ProjectRemover("remove sub project", nd, this);
        rm.addProjectStateChangeListener(this);
    }

    public void bootSubProjectCreator() {
        ProjectDirBrowserNode nd = this.getSelectedNode();
        if (nd == null) {
            this.logger.error("project not selected.");
            return;
        }
        if (nd == this.getRootNode()) {
            this.logger.info("sub projects can't be created under root node.");
            return;
        }
        NewSubProjectCreator cr = new NewSubProjectCreator(nd, this);
        cr.addProjectStateChangeListener(this);
    }

    public void saveMyProjects() {
        this.setShouldBeVisible(this.getRootNode());
        try {
            FileWriter writer = new FileWriter(this.myproj);
            XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
            outputter.output(this.doc, (Writer)writer);
        }
        catch (IOException ioe) {
            this.logger.error("failed to save file transfer scheme to disk.");
            ioe.printStackTrace();
            return;
        }
    }

    private void setShouldBeVisible(TreeNode node) {
        TreePath path = new TreePath(((DefaultMutableTreeNode)node).getPath());
        JTree tree = this.getTree();
        if (node instanceof ProjectDirBrowserNode) {
            Element elem = ((ProjectDirBrowserNode)node).getProjectElement();
            String shouldbevisible = "false";
            if (tree.isExpanded(path)) {
                shouldbevisible = "true";
            }
            elem.setAttribute(new Attribute("shouldbevisible", shouldbevisible));
            String selected = "false";
            if (tree.isPathSelected(path)) {
                selected = "true";
            }
            elem.setAttribute(new Attribute("selected", selected));
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.setShouldBeVisible(node.getChildAt(i));
        }
    }
}

