/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.phase;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import jp.advancesoft.chase.atomcoord.AtomCoords;
import jp.advancesoft.chase.common.Command;
import jp.advancesoft.chase.common.ConstParameters;
import jp.advancesoft.chase.common.CoordsViewerBooter;
import jp.advancesoft.chase.common.MyMessageBox;
import jp.advancesoft.chase.inputinterface.InputInterface;
import jp.advancesoft.chase.inputinterface.InputInterfacePrimitiveEntry;
import jp.advancesoft.chase.phase.AtomTableInputInterface;
import jp.advancesoft.chase.phase.ChoicePanelPhase;
import jp.advancesoft.chase.phase.ChoicePanelPhaseUnit;
import jp.advancesoft.chase.phase.ExportButton;
import jp.advancesoft.chase.phase.ImportButton;
import jp.advancesoft.chase.phase.PhaseInputFrame;
import jp.advancesoft.chase.phase.TableForNonTabularData;
import jp.advancesoft.chase.phase.TableModelForAtomPanel;
import jp.advancesoft.chase.settings.PropertiesManager;
import org.apache.log4j.Logger;

class AtomConfigPanel
extends JPanel
implements TableModelListener,
ActionListener {
    private static Logger logger = Logger.getLogger(AtomConfigPanel.class.getName());
    private InputInterface inputInterface;
    private ChoicePanelPhase p_coord;
    private String[] coordsys;
    private String[] units_length = new String[]{PhaseInputFrame.NO_SELECTION, "bohr", "angstrom", "nm"};
    private MyMessageBox mbox;
    private boolean validcell = true;
    private AtomCoords coords;
    private JComboBox p_cell_scheme;
    private int icellscheme;
    private JScrollPane[] scr;
    private String[] inputSpecs0;
    private String[] inputSpecs1;
    private Vector fullNameVector0;
    private Vector fullNameVector1;
    private JPanel p_cell;
    private TableModel[] tblmod_cell = new TableModel[2];
    private TableModelForAtomPanel tblmod;
    private JCheckBox cbautoconvert;
    private TableForNonTabularData[] tnt = new TableForNonTabularData[2];
    private AtomTableInputInterface tbl_atom;
    private JComboBox cpViewer;
    private ChoicePanelPhaseUnit unitchoice;

    protected AtomConfigPanel(InputInterface inputInterface, AtomCoords coords) {
        this.inputInterface = inputInterface;
        this.coords = coords;
        this.createLengthScalePanel();
        this.createCellPanel();
        this.createAtomConfigPanel();
    }

    private void createLengthScalePanel() {
        String struc = "structure.";
        String[] unitspec = new String[]{struc + "unit_cell.units", struc + "atom_list.atoms.units"};
        String[] unitChoice = new String[]{PhaseInputFrame.NO_SELECTION, "bohr", "angstrom", "nm"};
        this.unitchoice = new ChoicePanelPhaseUnit(unitspec, this.inputInterface, "length units", unitChoice, this);
        this.add(this.unitchoice);
        this.unitchoice.getComboBox().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AtomConfigPanel.this.coords.setUnit(AtomConfigPanel.this.unitchoice.getComboBox().getSelectedIndex());
            }
        });
        this.unitchoice.getComboBox().setSelectedIndex(this.unitchoice.getComboBox().getSelectedIndex());
    }

    private void createAtomConfigPanel() {
        AtomConfigPanel p_atom_all = this;
        p_atom_all.setLayout(new BoxLayout(p_atom_all, 1));
        JPanel p_atom = new JPanel();
        p_atom.setLayout(new BoxLayout(p_atom, 1));
        String[] atmtable = new String[]{"structure.atom_list.atoms.table"};
        this.tbl_atom = new AtomTableInputInterface(atmtable, this.inputInterface);
        String numatMax = PropertiesManager.getGlobalProperties(2).getProperty("NUMAT_MAX_PHASE");
        this.tblmod = new TableModelForAtomPanel(this.tbl_atom, ConstParameters.COLNAME_ATOM, Integer.parseInt(numatMax), this, this.coords);
        String[] ign = new String[]{"No."};
        this.tblmod.ignoreOnSave(ign, 1);
        this.tbl_atom.setModel(this.tblmod);
        this.tbl_atom.init();
        JPanel panelAtom = new JPanel();
        panelAtom.setLayout(new BoxLayout(panelAtom, 1));
        panelAtom.add(this.tbl_atom.getPanel());
        JScrollPane scrPane = new JScrollPane();
        scrPane.getViewport().setView(panelAtom);
        scrPane.setPreferredSize(new Dimension(380, 500));
        p_atom_all.add(scrPane);
        JPanel p_strbtn = new JPanel();
        p_strbtn.setLayout(new FlowLayout(1));
        ImportButton imp = new ImportButton("Import", this.tbl_atom, this.tblmod, this.tnt, this.tblmod_cell, this.coords, this.unitchoice.getComboBox(), this);
        ExportButton exp = new ExportButton("Export", this.coords, this);
        p_strbtn.add(imp);
        p_strbtn.add(exp);
        this.coordsys = new String[]{PhaseInputFrame.NO_SELECTION, "internal", "cartesian"};
        String[] csspec = new String[]{"structure.atom_list.coordinate_system"};
        this.p_coord = new ChoicePanelPhase(csspec, this.inputInterface, "coordinate system", this.coordsys, this);
        this.coords.isCart(this.coordsys[this.p_coord.getComboBox().getSelectedIndex()].equals(this.coordsys[2]));
        this.p_coord.getComboBox().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AtomConfigPanel.this.coords.isCart(AtomConfigPanel.this.coordsys[AtomConfigPanel.this.p_coord.getComboBox().getSelectedIndex()].equals(AtomConfigPanel.this.coordsys[2]));
                logger.debug("isCart: " + AtomConfigPanel.this.coords.isCart());
            }
        });
        p_strbtn.add(this.p_coord);
        JPanel viewerPanel = new JPanel();
        viewerPanel.setBorder(new TitledBorder("view atomic configuration"));
        JButton viewerbtn = new JButton("View");
        String[] viewerChoice = new String[]{"internal viewer", "BioStationViewer"};
        this.cpViewer = new JComboBox<String>(viewerChoice);
        viewerPanel.add(viewerbtn);
        viewerPanel.add(this.cpViewer);
        p_strbtn.add(viewerPanel);
        p_atom_all.add(p_strbtn);
        p_atom_all.setBorder(new TitledBorder("atomic configuration"));
        viewerbtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String parentDir = new File(AtomConfigPanel.this.inputInterface.getFile()).getParent();
                Vector<AtomCoords> cv = new Vector<AtomCoords>();
                cv.addElement(AtomConfigPanel.this.coords);
                CoordsViewerBooter cvb = new CoordsViewerBooter(cv, parentDir, AtomConfigPanel.this.cpViewer.getSelectedIndex());
                cvb.boot();
            }
        });
        this.coords.setModels(this.tblmod, this.tblmod_cell);
    }

    private void createCellPanel() {
        int i;
        String[] fullName;
        String inp;
        int i2;
        AtomConfigPanel p_cell_all = this;
        p_cell_all.setLayout(new BoxLayout(p_cell_all, 1));
        this.p_cell = new JPanel();
        this.p_cell.setLayout(new BoxLayout(this.p_cell, 0));
        String uncell = "structure.unit_cell.";
        this.inputSpecs0 = new String[]{uncell + "a_vector", uncell + "b_vector", uncell + "c_vector"};
        this.inputSpecs1 = new String[]{uncell + "a", uncell + "b", uncell + "c", uncell + "alpha", uncell + "beta", uncell + "gamma"};
        this.fullNameVector0 = new Vector();
        for (i2 = 0; i2 < this.inputSpecs0.length; ++i2) {
            inp = this.inputSpecs0[i2];
            logger.debug("inp: " + inp);
            fullName = inp.split("\\.");
            this.fullNameVector0.addElement(fullName);
        }
        this.fullNameVector1 = new Vector();
        for (i2 = 0; i2 < this.inputSpecs1.length; ++i2) {
            inp = this.inputSpecs1[i2];
            logger.debug("inp: " + inp);
            fullName = inp.split("\\.");
            this.fullNameVector1.addElement(fullName);
        }
        Object[] colname_cell0 = new String[]{"", "x", "y", "z"};
        Object[][] celldata0 = new String[][]{{"a_vector", "", "", ""}, {"b_vector", "", "", ""}, {"c_vector", "", "", ""}};
        Object[] colname_cell1 = new String[]{"", "a", "b", "c", "alpha", "beta", "gamma"};
        Object[][] celldata1 = new String[][]{{"celldata", "", "", "", "", "", ""}};
        this.tnt = new TableForNonTabularData[2];
        this.tnt[0] = new TableForNonTabularData(this.inputSpecs0, this.inputInterface, celldata0, colname_cell0, this.coords);
        this.tnt[0].setRowOriented();
        this.tnt[1] = new TableForNonTabularData(this.inputSpecs1, this.inputInterface, celldata1, colname_cell1, this.coords);
        this.scr = new JScrollPane[2];
        for (i = 0; i < 2; ++i) {
            this.tblmod_cell[i] = this.tnt[i].getModel();
            this.tnt[i].setInputToModel();
            this.tnt[i].getModel().addTableModelListener(this);
            this.tnt[i].setColumnSelectionAllowed(true);
            this.tnt[i].setRowSelectionAllowed(true);
            this.scr[i] = new JScrollPane();
            this.scr[i].getViewport().setView(this.tnt[i]);
            this.scr[i].setPreferredSize(new Dimension(380, 200));
        }
        p_cell_all.add(this.p_cell);
        for (i = 0; i < 2; ++i) {
            AbstractTableModel am = (AbstractTableModel)this.tnt[i].getModel();
            am.fireTableDataChanged();
        }
        JPanel pcellscheme = new JPanel();
        pcellscheme.setLayout(new BoxLayout(pcellscheme, 0));
        pcellscheme.setBorder(new TitledBorder("cell scheme"));
        this.cbautoconvert = new JCheckBox("automatic conversion");
        String[] cell_scheme = new String[]{"a_vector,b_vector,c_vector", "a,b,c,alpha,beta,gamma"};
        this.p_cell_scheme = new JComboBox<String>(cell_scheme);
        p_cell_all.add(pcellscheme);
        p_cell_all.setBorder(new TitledBorder("cellvector"));
        this.p_cell_scheme.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AtomConfigPanel.this.icellscheme = AtomConfigPanel.this.p_cell_scheme.getSelectedIndex();
                logger.debug("changing cell scheme to no. " + AtomConfigPanel.this.icellscheme);
                if (AtomConfigPanel.this.cbautoconvert.isSelected()) {
                    if (AtomConfigPanel.this.coords.convertCell(AtomConfigPanel.this.p_cell_scheme.getSelectedIndex())) {
                        AtomConfigPanel.this.coords.updateTable(AtomConfigPanel.this.tblmod, AtomConfigPanel.this.tblmod_cell);
                    } else {
                        logger.warn("failed to convert cell");
                    }
                }
                AtomConfigPanel.this.updateTableCell();
            }
        });
        pcellscheme.add(this.p_cell_scheme);
        pcellscheme.add(this.cbautoconvert);
        this.p_cell_scheme.setSelectedIndex(0);
        if (this.tnt[1].hasData()) {
            this.p_cell_scheme.setSelectedIndex(1);
        }
    }

    public void tableChanged(TableModelEvent e) {
        Command command = (Command)e.getSource();
        command.execute(e);
    }

    public void actionPerformed(ActionEvent e) {
        Command command = (Command)e.getSource();
        command.execute(e);
    }

    private void updateTableCell() {
        this.p_cell.removeAll();
        this.p_cell.add(this.scr[this.icellscheme]);
        this.updateInputInterface();
        this.revalidate();
    }

    private void updateInputInterface() {
        InputInterfacePrimitiveEntry entry;
        String ident;
        String[] fullName;
        int i;
        for (i = 0; i < this.fullNameVector0.size(); ++i) {
            this.inputInterface.selectRoot();
            fullName = (String[])this.fullNameVector0.get(i);
            for (int j2 = 0; j2 < fullName.length - 1; ++j2) {
                ident = fullName[j2];
                if (!this.inputInterface.selectBlock(ident)) {
                    logger.debug("couldn't select block: " + ident);
                    continue;
                }
                logger.debug("selected block: " + ident);
            }
            entry = this.inputInterface.getPrimitiveEntry(fullName[fullName.length - 1]);
            if (this.p_cell_scheme.getSelectedIndex() == 1) {
                entry.ignoreMe(true);
            } else {
                entry.ignoreMe(false);
            }
            this.inputInterface.selectRoot();
        }
        for (i = 0; i < this.fullNameVector1.size(); ++i) {
            this.inputInterface.selectRoot();
            fullName = (String[])this.fullNameVector1.get(i);
            for (int j3 = 0; j3 < fullName.length - 1; ++j3) {
                ident = fullName[j3];
                if (!this.inputInterface.selectBlock(ident)) {
                    logger.debug("couldn't select block: " + ident);
                    continue;
                }
                logger.debug("selected block: " + ident);
            }
            entry = this.inputInterface.getPrimitiveEntry(fullName[fullName.length - 1]);
            if (this.p_cell_scheme.getSelectedIndex() == 0) {
                entry.ignoreMe(true);
            } else {
                entry.ignoreMe(false);
            }
            this.inputInterface.selectRoot();
        }
    }
}

