/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.mainpanel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import jp.advancesoft.chase.mainpanel.AbstractInternalFrameChase;
import jp.advancesoft.chase.mainpanel.ChaseDesktop;
import jp.advancesoft.chase.mainpanel.InternalFrameKeyListener;
import jp.advancesoft.chase.settings.GlobalProperties;
import jp.advancesoft.chase.settings.PropertiesManager;
import org.apache.log4j.Logger;

public class Desktop
extends JDesktopPane
implements ChaseDesktop {
    private static Logger logger = Logger.getLogger(Desktop.class.getName());
    private static Desktop desktop;
    private int widthCount = 0;
    private int heightCount = 0;
    private JScrollPane scrollpane;
    private GlobalProperties gp = PropertiesManager.getGlobalProperties(0);

    private Desktop() {
        String outline = this.gp.getProperty("outline_only");
        if (outline == null || !outline.trim().equals("false")) {
            this.setDragMode(1);
        }
    }

    public static JDesktopPane getDesktop() {
        if (desktop == null) {
            desktop = new Desktop();
        }
        return desktop;
    }

    public int getMaxLayer() {
        int layer = 0;
        JInternalFrame[] frames = this.getAllFrames();
        if (frames == null) {
            return layer;
        }
        for (int i = 0; i < frames.length; ++i) {
            int foo = frames[i].getLayer();
            if (foo <= layer) continue;
            layer = foo;
        }
        return layer;
    }

    public Component add(Component component) {
        if (component instanceof AbstractInternalFrameChase) {
            Component[] comps = ((JInternalFrame)component).getComponents();
            for (int i = 0; i < comps.length; ++i) {
                comps[i].addKeyListener(new InternalFrameKeyListener());
            }
        }
        return super.add(component);
    }

    public void setScrollPane(JScrollPane scrollpane_) {
        this.scrollpane = scrollpane_;
        this.scrollpane.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (Desktop.this.scrollpane.getHorizontalScrollBar().getValueIsAdjusting()) {
                    Desktop.this.deactivateHeavy();
                }
            }
        });
        this.scrollpane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (Desktop.this.scrollpane.getVerticalScrollBar().getValueIsAdjusting()) {
                    Desktop.this.deactivateHeavy();
                }
            }
        });
    }

    public JScrollPane getScrollPane() {
        return this.scrollpane;
    }

    private void deactivateHeavy() {
        JInternalFrame[] frames = this.getAllFrames();
        if (frames != null && frames.length > 0) {
            for (int i = 0; i < frames.length; ++i) {
                if (!((AbstractInternalFrameChase)frames[i]).isHeavyWeight()) continue;
                try {
                    frames[i].setSelected(false);
                    frames[i].setLayer(0);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void componentShown() {
        this.scrollBarUpdate();
    }

    public void componentResized() {
        this.scrollBarUpdate();
    }

    public void componentMoved() {
        this.scrollBarUpdate();
    }

    public void componentHidden() {
        this.scrollBarUpdate();
    }

    public void initialLocation(Component frameNow) {
        this.initialLocation(frameNow, 0);
    }

    public void selectLast() {
        JInternalFrame[] components = super.getAllFrames();
        if (components == null || components.length <= 1) {
            return;
        }
        int visibles = 0;
        for (int i = 0; i < components.length; ++i) {
            if (!components[i].isVisible()) continue;
            ++visibles;
        }
        if (visibles == 0) {
            return;
        }
        int numFrames = components.length;
        for (int i = numFrames - 1; i >= 0; --i) {
            JInternalFrame frame = components[i];
            if (!frame.isVisible() || frame.isIcon()) continue;
            try {
                frame.setSelected(true);
            }
            catch (Exception ex) {
                // empty catch block
            }
            return;
        }
    }

    public void initialLocation(Component frameNow, int location) {
        JInternalFrame[] components = super.getAllFrames();
        if (components == null || components.length <= 1) {
            return;
        }
        int visibles = 0;
        for (int i = 0; i < components.length; ++i) {
            if (!components[i].isVisible()) continue;
            ++visibles;
        }
        if (visibles == 0) {
            return;
        }
        String initial_position = this.gp.getProperty("initial_position");
        if (initial_position != null && initial_position.trim().equals("tile")) {
            this.tile(location, frameNow);
        } else {
            this.cascade(location, frameNow);
        }
    }

    private void tile(int location, Component frameNow) {
        logger.debug("setting initial location ...");
        int widthThis = this.getWidth();
        int heightThis = this.getHeight();
        Component framePre = this.getSelectedFrame();
        if (framePre == null && (framePre = ((Component[])super.getAllFrames())[0]) == null) {
            frameNow.setLocation(0, 0);
            return;
        }
        int hidari = framePre.getLocation().x;
        int migi = hidari + framePre.getSize().width;
        int ue = framePre.getLocation().y;
        int sita = ue + framePre.getSize().height;
        logger.debug("hidari, migi, ue, sita: " + hidari + " " + migi + " " + ue + " " + sita);
        if (location == 0) {
            float d;
            float a2 = (float)hidari / (float)widthThis;
            float b2 = (float)ue / (float)heightThis;
            float c2 = (float)(widthThis - migi) / (float)widthThis;
            if (c2 < 0.0f) {
                c2 = 0.0f;
            }
            if ((d = (float)(heightThis - sita) / (float)heightThis) < 0.0f) {
                d = 0.0f;
            }
            float comp = 0.0f;
            int index = 1;
            if (a2 > comp) {
                comp = a2;
                index = 1;
                ++this.widthCount;
            }
            if (b2 > comp) {
                comp = b2;
                index = 2;
                ++this.heightCount;
            }
            if (c2 > comp) {
                comp = c2;
                index = 3;
                ++this.widthCount;
            }
            if (d > comp) {
                comp = d;
                index = 4;
                ++this.heightCount;
            }
            if (this.widthCount == 2) {
                index = 4;
                this.widthCount = 0;
            }
            if (this.heightCount == 2) {
                index = 3;
                this.heightCount = 0;
            }
            logger.debug("a,b,c,d,index: " + index + " " + a2 + " " + b2 + " " + c2 + " " + d);
            if (index == 1) {
                frameNow.setLocation(hidari - frameNow.getSize().width, ue);
            } else if (index == 2) {
                frameNow.setLocation(hidari, ue - frameNow.getSize().height);
            } else if (index == 3) {
                frameNow.setLocation(migi, ue);
            } else if (index == 4) {
                frameNow.setLocation(hidari, sita);
            }
        } else if (location == 2) {
            frameNow.setLocation(hidari - frameNow.getSize().width, ue);
        } else if (location == 3) {
            frameNow.setLocation(migi, ue);
        } else if (location == 1) {
            this.center(frameNow);
        }
    }

    private void center(Component frameNow) {
        Component framePre = this.getSelectedFrame();
        if (framePre == null && (framePre = ((Component[])super.getAllFrames())[0]) == null) {
            frameNow.setLocation(0, 0);
            return;
        }
        int centerx = framePre.getLocation().x + framePre.getWidth() / 2;
        int centery = framePre.getLocation().y + framePre.getHeight() / 2;
        int locx = centerx - frameNow.getWidth() / 2;
        int locy = centery - frameNow.getHeight() / 2;
        frameNow.setLocation(locx, locy);
    }

    private void cascade(int location, Component frameNow) {
        logger.debug("setting initial location ...");
        int widthThis = this.getWidth();
        int heightThis = this.getHeight();
        Component framePre = this.getSelectedFrame();
        if (framePre == null && (framePre = ((Component[])super.getAllFrames())[0]) == null) {
            frameNow.setLocation(0, 0);
            return;
        }
        int hidari = framePre.getLocation().x;
        int migi = hidari + framePre.getSize().width;
        int ue = framePre.getLocation().y;
        int sita = ue + framePre.getSize().height;
        logger.debug("hidari, migi, ue, sita: " + hidari + " " + migi + " " + ue + " " + sita);
        if (location == 0) {
            int overlap_x = 20;
            int overlap_y = 20;
            String ox = this.gp.getProperty("overlap_x");
            String oy = this.gp.getProperty("overlap_y");
            if (ox != null) {
                try {
                    overlap_x = Integer.parseInt(ox);
                }
                catch (NumberFormatException nfe) {
                    overlap_x = 20;
                }
            }
            if (oy != null) {
                try {
                    overlap_y = Integer.parseInt(oy);
                }
                catch (NumberFormatException nfe) {
                    overlap_y = 20;
                }
            }
            int prex = framePre.getLocation().x;
            int prey = framePre.getLocation().y;
            int locx = prex + overlap_x;
            int locy = prey + overlap_y;
            frameNow.setLocation(locx, locy);
        } else if (location == 2) {
            frameNow.setLocation(hidari - frameNow.getSize().width, ue);
        } else if (location == 3) {
            frameNow.setLocation(migi, ue);
        } else if (location == 1) {
            this.center(frameNow);
        }
    }

    protected void scrollBarUpdate() {
        JInternalFrame[] frames = null;
        try {
            frames = super.getAllFrames();
        }
        catch (Exception ex) {
            return;
        }
        int numFrames = frames.length;
        int migi = 0;
        int imigi = 0;
        int sita = 0;
        int isita = 0;
        for (int i = 0; i < numFrames; ++i) {
            JInternalFrame frame = frames[i];
            int migi_ = frame.getLocation().x + frame.getSize().width;
            int sita_ = frame.getLocation().y + frame.getSize().height;
            if (migi_ > migi) {
                migi = migi_;
                imigi = i;
            }
            if (sita_ > sita) {
                sita = sita_;
                isita = i;
            }
            int hidari_ = frame.getLocation().x;
            int ue_ = frame.getLocation().y;
            int hidari = 0;
            int ue = 0;
            hidari = hidari_;
            ue = ue_;
            if (hidari_ < 0) {
                hidari = 0;
            }
            if (ue_ < 0) {
                ue = 0;
            }
            if (hidari == hidari_ && ue == ue_) continue;
            frame.setLocation(hidari, ue);
            frame.revalidate();
        }
        logger.debug("migi: " + migi);
        logger.debug("sita: " + sita);
        this.setPreferredSize(new Dimension(migi, sita));
        this.revalidate();
    }
}

