/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.share;

import org.cybergarage.x3d.SceneGraph;
import org.cybergarage.x3d.share.ShareWorldThread;
import org.cybergarage.x3d.util.Debug;

public abstract class ShareWorld
implements Runnable,
ShareWorldThread {
    private static final int defaultServerSocketPort = 7003;
    private SceneGraph mSceneGraph;
    private Boolean mThreadExecuteFlag = new Boolean(false);

    public ShareWorld() {
        this.setSceneGraph(null);
        this.setThreadExecuteFlag(false);
    }

    public ShareWorld(SceneGraph sg) {
        this();
        this.setSceneGraph(sg);
    }

    public static int getDefaultSeverSocketPort() {
        return 7003;
    }

    public void setSceneGraph(SceneGraph sg) {
        this.mSceneGraph = sg;
    }

    public SceneGraph getSceneGraph() {
        return this.mSceneGraph;
    }

    public boolean hasSceneGraph() {
        return this.mSceneGraph != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setThreadExecuteFlag(boolean flag) {
        Boolean bl = this.mThreadExecuteFlag;
        synchronized (bl) {
            this.mThreadExecuteFlag = new Boolean(flag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isThreadExecuting() {
        boolean flag = false;
        Boolean bl = this.mThreadExecuteFlag;
        synchronized (bl) {
            flag = this.mThreadExecuteFlag;
        }
        return flag;
    }

    public void executeThread() {
        Debug.message("executeThread");
        this.setThreadExecuteFlag(true);
        Thread clientThread = new Thread(this);
        Debug.message("  clientThread = " + clientThread);
        clientThread.start();
        Debug.message("  start");
    }

    public void stopThread() {
        this.setThreadExecuteFlag(false);
    }

    public void run() {
        while (this.isThreadExecuting()) {
            this.execute();
        }
    }
}

