/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import java.io.PrintWriter;
import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.field.MFInt32;
import org.cybergarage.x3d.field.SFBool;
import org.cybergarage.x3d.field.SFFloat;
import org.cybergarage.x3d.field.SFNode;
import org.cybergarage.x3d.node.ColorNode;
import org.cybergarage.x3d.node.CoordinateNode;
import org.cybergarage.x3d.node.Geometry3DNode;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.util.BoundingBox;

public class IndexedLineSetNode
extends Geometry3DNode {
    private static final String colorPerVertexFieldName = "colorPerVertex";
    private static final String coordIndexFieldName = "coordIndex";
    private static final String colorIndexFieldName = "colorIndex";
    private static final String lineWidthFieldName = "lineWidth";
    private static final String colorExposedFieldName = "color";
    private static final String coordExposedFieldName = "coord";
    private static final String coordIndexEventInName = "coordIndex";
    private static final String colorIndexEventInName = "colorIndex";
    private SFBool colorPerVertexField;
    private MFInt32 coordIndexField;
    private MFInt32 colorIndexField;
    private SFNode colorField;
    private SFNode coordField;
    private MFInt32 setCoordIndexField;
    private MFInt32 setColorIndexField;
    private SFFloat lineWidthField;

    public IndexedLineSetNode() {
        this.setHeaderFlag(false);
        this.setType(NodeType.INDEXEDLINESET);
        this.colorPerVertexField = new SFBool(true);
        this.colorPerVertexField.setName(colorPerVertexFieldName);
        this.addField(this.colorPerVertexField);
        this.coordIndexField = new MFInt32();
        this.coordIndexField.setName("coordIndex");
        this.addField(this.coordIndexField);
        this.colorIndexField = new MFInt32();
        this.colorIndexField.setName("colorIndex");
        this.addField(this.colorIndexField);
        this.lineWidthField = new SFFloat(1.0f);
        this.lineWidthField.setName(lineWidthFieldName);
        this.addField(this.lineWidthField);
        this.colorField = new SFNode();
        this.addExposedField(colorExposedFieldName, this.colorField);
        this.coordField = new SFNode();
        this.addExposedField(coordExposedFieldName, this.coordField);
        this.setCoordIndexField = new MFInt32();
        this.setCoordIndexField.setName("coordIndex");
        this.addEventIn(this.setCoordIndexField);
        this.setColorIndexField = new MFInt32();
        this.setColorIndexField.setName("colorIndex");
        this.addEventIn(this.setColorIndexField);
    }

    public IndexedLineSetNode(IndexedLineSetNode node) {
        this();
        this.setFieldValues(node);
    }

    public SFNode getColorField() {
        if (!this.isInstanceNode()) {
            return this.colorField;
        }
        return (SFNode)this.getExposedField(colorExposedFieldName);
    }

    public void updateColorField() {
        this.getColorField().setValue(this.getColorNodes());
    }

    public SFNode getCoordField() {
        if (!this.isInstanceNode()) {
            return this.coordField;
        }
        return (SFNode)this.getExposedField(coordExposedFieldName);
    }

    public void updateCoordField() {
        this.getCoordField().setValue(this.getCoordinateNodes());
    }

    public SFBool getColorPerVertexField() {
        if (!this.isInstanceNode()) {
            return this.colorPerVertexField;
        }
        return (SFBool)this.getField(colorPerVertexFieldName);
    }

    public void setColorPerVertex(boolean value) {
        this.getColorPerVertexField().setValue(value);
    }

    public void setColorPerVertex(String value) {
        this.getColorPerVertexField().setValue(value);
    }

    public boolean getColorPerVertex() {
        return this.getColorPerVertexField().getValue();
    }

    public boolean isColorPerVertex() {
        return this.getColorPerVertex();
    }

    public MFInt32 getCoordIndexField() {
        if (!this.isInstanceNode()) {
            return this.coordIndexField;
        }
        return (MFInt32)this.getField("coordIndex");
    }

    public void addCoordIndex(int value) {
        this.getCoordIndexField().addValue(value);
    }

    public int getNCoordIndices() {
        return this.getCoordIndexField().getSize();
    }

    public void setCoordIndex(int index, int value) {
        this.getCoordIndexField().set1Value(index, value);
    }

    public void setCoordIndices(String value) {
        this.getCoordIndexField().setValues(value);
    }

    public void setCoordIndices(String[] value) {
        this.getCoordIndexField().setValues(value);
    }

    public int getCoordIndex(int index) {
        return this.getCoordIndexField().get1Value(index);
    }

    public void removeCoordIndex(int index) {
        this.getCoordIndexField().removeValue(index);
    }

    public MFInt32 getColorIndexField() {
        if (!this.isInstanceNode()) {
            return this.colorIndexField;
        }
        return (MFInt32)this.getField("colorIndex");
    }

    public void addColorIndex(int value) {
        this.getColorIndexField().addValue(value);
    }

    public int getNColorIndices() {
        return this.getColorIndexField().getSize();
    }

    public void setColorIndex(int index, int value) {
        this.getColorIndexField().set1Value(index, value);
    }

    public void setColorIndices(String value) {
        this.getColorIndexField().setValues(value);
    }

    public void setColorIndices(String[] value) {
        this.getColorIndexField().setValues(value);
    }

    public int getColorIndex(int index) {
        return this.getColorIndexField().get1Value(index);
    }

    public void removeColorIndex(int index) {
        this.getColorIndexField().removeValue(index);
    }

    public SFFloat getLineWidthField() {
        if (!this.isInstanceNode()) {
            return this.lineWidthField;
        }
        return (SFFloat)this.getField(lineWidthFieldName);
    }

    public void setLineWidth(float value) {
        this.getLineWidthField().setValue(value);
    }

    public void setLineWidth(String value) {
        this.getLineWidthField().setValue(value);
    }

    public float getLineWidth() {
        return this.getLineWidthField().getValue();
    }

    public MFInt32 getSetCoordIndexField() {
        if (!this.isInstanceNode()) {
            return this.setCoordIndexField;
        }
        return (MFInt32)this.getEventIn("coordIndex");
    }

    public void addSetCoordIndex(int value) {
        this.getSetCoordIndexField().addValue(value);
    }

    public int getNSetCoordIndices() {
        return this.getSetCoordIndexField().getSize();
    }

    public void setSetCoordIndex(int index, int value) {
        this.getSetCoordIndexField().set1Value(index, value);
    }

    public void setSetCoordIndices(String value) {
        this.getSetCoordIndexField().setValues(value);
    }

    public void setSetCoordIndices(String[] value) {
        this.getSetCoordIndexField().setValues(value);
    }

    public int getSetCoordIndex(int index) {
        return this.getSetCoordIndexField().get1Value(index);
    }

    public void removeSetCoordIndex(int index) {
        this.getSetCoordIndexField().removeValue(index);
    }

    public int getNSetTriangleCoordIndices() {
        return this.getSetCoordIndexField().getNTriangleIndices();
    }

    public MFInt32 getSetColorIndexField() {
        if (!this.isInstanceNode()) {
            return this.setColorIndexField;
        }
        return (MFInt32)this.getEventIn("colorIndex");
    }

    public void addSetColorIndex(int value) {
        this.getSetColorIndexField().addValue(value);
    }

    public int getNSetColorIndices() {
        return this.getSetColorIndexField().getSize();
    }

    public void setSetColorIndex(int index, int value) {
        this.getSetColorIndexField().set1Value(index, value);
    }

    public void setSetColorIndices(String value) {
        this.getSetColorIndexField().setValues(value);
    }

    public void setSetColorIndices(String[] value) {
        this.getSetColorIndexField().setValues(value);
    }

    public int getSetColorIndex(int index) {
        return this.getSetColorIndexField().get1Value(index);
    }

    public void removeSetColorIndex(int index) {
        this.getSetColorIndexField().removeValue(index);
    }

    public boolean isChildNodeType(Node node) {
        return node.isColorNode() || node.isCoordinateNode();
    }

    public void initialize() {
        super.initialize();
        if (!this.isInitialized()) {
            this.updateBoundingBox();
            this.setInitializationFlag(true);
        }
        this.updateColorField();
        this.updateCoordField();
    }

    public void uninitialize() {
    }

    public void update() {
    }

    public int getNLines() {
        CoordinateNode coordinate = this.getCoordinateNodes();
        if (coordinate == null) {
            return 0;
        }
        int nTotalCoordIndex = 0;
        int nCoordIndex = 0;
        for (int n = 0; n < this.getNCoordIndices(); ++n) {
            if (this.getCoordIndex(n) != -1) {
                ++nCoordIndex;
            }
            if (this.getCoordIndex(n) != -1 && n != this.getNCoordIndices() - 1) continue;
            if (2 <= nCoordIndex) {
                nTotalCoordIndex += nCoordIndex - 1;
            }
            nCoordIndex = 0;
        }
        return nTotalCoordIndex;
    }

    public void outputContext(PrintWriter printStream, String indentString) {
        CoordinateNode coord;
        SFBool colorPerVertex = this.getColorPerVertexField();
        printStream.println(indentString + "\t" + "colorPerVertex " + colorPerVertex);
        ColorNode color = this.getColorNodes();
        if (color != null && 0 < color.getNColors()) {
            if (!color.isInstanceNode()) {
                String nodeName = color.getName();
                if (nodeName != null && 0 < nodeName.length()) {
                    printStream.println(indentString + "\t" + "color DEF " + color.getName() + " Color {");
                } else {
                    printStream.println(indentString + "\t" + "color Color {");
                }
                color.outputContext(printStream, indentString + "\t");
                printStream.println(indentString + "\t" + "}");
            } else {
                printStream.println(indentString + "\t" + "color USE " + color.getName());
            }
        }
        if ((coord = this.getCoordinateNodes()) != null && 0 < coord.getNPoints()) {
            if (!coord.isInstanceNode()) {
                String nodeName = coord.getName();
                if (nodeName != null && 0 < nodeName.length()) {
                    printStream.println(indentString + "\t" + "coord DEF " + coord.getName() + " Coordinate {");
                } else {
                    printStream.println(indentString + "\t" + "coord Coordinate {");
                }
                coord.outputContext(printStream, indentString + "\t");
                printStream.println(indentString + "\t" + "}");
            } else {
                printStream.println(indentString + "\t" + "coord USE " + coord.getName());
            }
        }
        if (0 < this.getNCoordIndices()) {
            MFInt32 coordIndex = this.getCoordIndexField();
            printStream.println(indentString + "\t" + "coordIndex [");
            coordIndex.outputIndex(printStream, indentString + "\t\t");
            printStream.println(indentString + "\t" + "]");
        }
        if (0 < this.getNColorIndices()) {
            MFInt32 colorIndex = this.getColorIndexField();
            printStream.println(indentString + "\t" + "colorIndex [");
            colorIndex.outputIndex(printStream, indentString + "\t\t");
            printStream.println(indentString + "\t" + "]");
        }
    }

    public void updateBoundingBox() {
        if (this.isInitialized()) {
            return;
        }
        CoordinateNode coordinate = this.getCoordinateNodes();
        if (coordinate == null) {
            this.setBoundingBoxCenter(0.0f, 0.0f, 0.0f);
            this.setBoundingBoxSize(-1.0f, -1.0f, -1.0f);
            return;
        }
        BoundingBox bbox = new BoundingBox();
        float[] point = new float[3];
        int nCoordinatePoint = coordinate.getNPoints();
        for (int n = 0; n < nCoordinatePoint; ++n) {
            coordinate.getPoint(n, point);
            bbox.addPoint(point);
        }
        this.setBoundingBoxCenter(bbox.getCenter());
        this.setBoundingBoxSize(bbox.getSize());
    }
}

