/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import java.io.PrintWriter;
import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.field.MFColor;
import org.cybergarage.x3d.node.GeometricPropertyNode;
import org.cybergarage.x3d.node.Node;

public class ColorNode
extends GeometricPropertyNode {
    private static final String colorFieldName = "color";
    private MFColor colorField;

    public ColorNode() {
        this.setHeaderFlag(false);
        this.setType(NodeType.COLOR);
        this.colorField = new MFColor();
        this.colorField.setName(colorFieldName);
        this.addExposedField(this.colorField);
    }

    public ColorNode(ColorNode node) {
        this();
        this.setFieldValues(node);
    }

    public MFColor gddColorField() {
        if (!this.isInstanceNode()) {
            return this.colorField;
        }
        return (MFColor)this.getExposedField(colorFieldName);
    }

    public void addColor(float[] color) {
        this.gddColorField().addValue(color);
    }

    public void addColor(float r, float g, float b2) {
        this.gddColorField().addValue(r, g, b2);
    }

    public int getNColors() {
        return this.gddColorField().getSize();
    }

    public void setColor(int index, float[] color) {
        this.gddColorField().set1Value(index, color);
    }

    public void setColor(int index, float r, float g, float b2) {
        this.gddColorField().set1Value(index, r, g, b2);
    }

    public void setColors(String value) {
        this.gddColorField().setValues(value);
    }

    public void setColors(String[] value) {
        this.gddColorField().setValues(value);
    }

    public void getColor(int index, float[] color) {
        this.gddColorField().get1Value(index, color);
    }

    public float[] getColor(int index) {
        float[] value = new float[3];
        this.getColor(index, value);
        return value;
    }

    public void removeColor(int index) {
        this.gddColorField().removeValue(index);
    }

    public boolean isChildNodeType(Node node) {
        return false;
    }

    public void initialize() {
        super.initialize();
    }

    public void uninitialize() {
    }

    public void update() {
    }

    public void outputContext(PrintWriter printStream, String indentString) {
        float[] color = new float[3];
        printStream.println(indentString + "\tcolor [");
        for (int n = 0; n < this.getNColors(); ++n) {
            this.getColor(n, color);
            if (n < this.getNColors() - 1) {
                printStream.println(indentString + "\t\t" + color[0] + " " + color[1] + " " + color[2] + ",");
                continue;
            }
            printStream.println(indentString + "\t\t" + color[0] + " " + color[1] + " " + color[2]);
        }
        printStream.println(indentString + "\t]");
    }
}

