/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.scripting.scripteditor;

import ciss.phase_viewer.pub.jeditsyntax.BatchFileTokenMarker;
import ciss.phase_viewer.pub.jeditsyntax.JEditTextArea;
import ciss.phase_viewer.pub.jeditsyntax.JavaTokenMarker;
import ciss.phase_viewer.pub.jeditsyntax.ShellScriptTokenMarker;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class ScriptEditor
extends JPanel {
    private Logger logger = Logger.getLogger(ScriptEditor.class.getName());
    private String scriptPath;
    private JEditTextArea area;

    public ScriptEditor(String scriptPath) {
        this.scriptPath = scriptPath;
        this.init();
    }

    private void init() {
        this.removeAll();
        this.setLayout(new BoxLayout(this, 1));
        this.area = new JEditTextArea();
        this.area.setPreferredSize(new Dimension(500, 300));
        String lower = this.scriptPath.toLowerCase();
        if (lower.endsWith(".bsh") || lower.endsWith(".java")) {
            this.area.setTokenMarker(new JavaTokenMarker());
        } else if (lower.endsWith(".bat")) {
            this.area.setTokenMarker(new BatchFileTokenMarker());
        } else if (lower.endsWith(".sh")) {
            this.area.setTokenMarker(new ShellScriptTokenMarker());
        }
        this.area.setCaretBlinkEnabled(true);
        String text = "";
        File file = new File(this.scriptPath);
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                text = text + line + System.getProperty("line.separator");
            }
            this.area.setText(text);
            reader.close();
        }
        catch (Exception exc) {
            // empty catch block
        }
        this.area.setCaretPosition(0);
        this.add(this.area);
    }

    public void reload() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save() {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(this.scriptPath));
            String text = this.area.getText();
            writer.write(text, 0, text.length());
            writer.close();
        }
        catch (IOException ioe) {
            this.logger.error("failed write to " + this.scriptPath);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException ioe) {}
        }
        return true;
    }
}

