/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.common;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Tail
extends TimerTask {
    private int numLines = 10;
    private long fileLength = Long.MAX_VALUE;
    private long lastModified = 0L;
    private long period = 1000L;
    private File file;
    private OutputStream out;
    private Timer timer;
    private Logger logger = Logger.getLogger(Tail.class.getName());
    private boolean initialized = false;
    private final byte[] ls = System.getProperty("line.separator").getBytes();

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            System.out.println("usage: java Tail fileName");
            System.exit(0);
        }
        Tail tail = new Tail(new File(args[0]), System.out);
        tail.doIt();
    }

    public Tail(File file, OutputStream out) {
        this.file = file;
        this.out = out;
    }

    public void doIt() {
        this.timer = new Timer();
        this.timer.schedule((TimerTask)this, 0L, this.period);
    }

    public void kill() {
        this.cancel();
        this.timer = null;
    }

    private void initTail(BufferedReader reader) throws IOException {
        String line = "";
        Vector<String> vec = new Vector<String>();
        while ((line = reader.readLine()) != null) {
            vec.add(line);
        }
        Object[] big = new String[vec.size()];
        vec.copyInto(big);
        this.lastModified = this.file.lastModified();
        int len = big.length - this.numLines;
        if (len < 0) {
            len = 0;
        }
        for (int i = len; i < big.length; ++i) {
            this.out.write(((String)big[i]).getBytes());
            this.out.write(System.getProperty("line.separator").getBytes());
        }
        this.fileLength = this.file.length();
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        BufferedReader reader = null;
        try {
            if (!this.file.exists()) {
                return;
            }
            reader = new BufferedReader(new FileReader(this.file));
            long currFileLength = this.file.length();
            if (this.fileLength > currFileLength && !this.initialized) {
                this.initTail(reader);
            }
            if (currFileLength == this.fileLength) {
                return;
            }
            String line = "";
            Vector<String> vec = new Vector<String>();
            reader.skip(this.fileLength);
            while ((line = reader.readLine()) != null) {
                vec.add(line);
            }
            if (vec.size() == 0) {
                return;
            }
            for (int i = 0; i < vec.size(); ++i) {
                this.out.write(vec.get(i).toString().getBytes());
                this.out.write(this.ls);
            }
            if (this.out instanceof BufferedOutputStream) {
                ((BufferedOutputStream)this.out).flush();
            }
            this.fileLength = currFileLength;
            this.lastModified = this.file.lastModified();
            return;
        }
        catch (IOException ioe) {
            this.logger.error("failed ...");
            ioe.printStackTrace();
            return;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

