/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.common;

import ciss.phase_viewer.common.ConstParameters;
import java.text.DecimalFormat;

public class ElementDef {
    private String symbol;
    private String atomicNumber;
    private String mass;
    private boolean hbond = false;
    private double maxHbondDistance = 0.0;
    private double covrad;
    private float[] color;
    private float radius;
    private DecimalFormat form = new DecimalFormat("0.00000");

    public ElementDef() {
    }

    public ElementDef(String symbol, String atomicNumber, String mass) {
        this.symbol = symbol;
        this.atomicNumber = atomicNumber;
        this.mass = mass;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public void setAtomicNumber(String atomicNumber) {
        this.atomicNumber = atomicNumber;
    }

    public void setMass(String mass) {
        this.mass = mass;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getAtomicNumber() {
        return this.atomicNumber;
    }

    public String getMass() {
        return this.mass;
    }

    public void hasHbond(boolean hbond) {
        this.hbond = hbond;
    }

    public boolean hasHbond() {
        return this.hbond;
    }

    public void setMaxHbondDistance(double maxHbondDistance) {
        this.maxHbondDistance = maxHbondDistance;
        this.hbond = maxHbondDistance > 0.0;
    }

    public double getMaxHbondDistance() {
        return this.maxHbondDistance;
    }

    public void setCovalentRadius(double covrad) {
        this.covrad = covrad;
    }

    public double getCovalentRadius() {
        return this.covrad;
    }

    public void setColor(float[] color) {
        this.color = color;
    }

    public float[] getColor() {
        return this.color;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public float getRadius() {
        return this.radius;
    }

    public String toString() {
        if (this.symbol == null || this.symbol.trim().length() == 0) {
            return "";
        }
        String ret = this.symbol + "            " + String.valueOf(this.radius) + "            " + String.valueOf(this.covrad) + "          " + String.valueOf(this.color[0]) + " " + String.valueOf(this.color[1]) + " " + String.valueOf(this.color[2]) + "      " + this.form.format(Double.parseDouble(this.mass) / ConstParameters.AMU);
        if (this.hbond) {
            ret = ret + "  " + String.valueOf(this.maxHbondDistance);
        }
        return ret;
    }
}

