/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord.io;

import ciss.phase_viewer.atomcoord.io.AtomCoordsIO;
import ciss.phase_viewer.atomcoord.io.Importable;
import ciss.phase_viewer.atomcoord.io.Importer;
import ciss.phase_viewer.common.ChaseFileChooser;
import ciss.phase_viewer.jdom.XMLUtils;
import ciss.phase_viewer.main.PluginLoader;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

public class ImportFileChooser
extends ChaseFileChooser
implements PropertyChangeListener {
    private Logger logger = Logger.getLogger(ImportFileChooser.class.getName());
    private Importable caller;
    private Importer[] importers;
    private Component parent;
    private String atomCoordsFile;

    public ImportFileChooser(Importable caller, Component parent) {
        super("atom", true);
        this.caller = caller;
        this.parent = parent;
        this.setDialogTitle("select atomic configuration file");
        this.setFileSelectionMode(0);
        this.setAcceptAllFileFilterUsed(false);
        this.init();
    }

    private void init() {
        this.createImporters();
        for (int i = 0; i < this.importers.length; ++i) {
            FileFilter filter = this.importers[i].getFileFilter();
            this.addChoosableFileFilter(filter);
        }
        this.setFileFilter(this.getChoosableFileFilters()[0]);
        if (this.showOpenDialog(this.parent) != 0) {
            return;
        }
        this.atomCoordsFile = this.getSelectedFile().getAbsolutePath();
        if (this.atomCoordsFile == null || this.atomCoordsFile.length() == 0 || !new File(this.atomCoordsFile).exists()) {
            this.logger.error("the file you've specified does not exist.");
            return;
        }
        int index = this.getSelectedFileFilterIndex();
        if (!this.importers[index].hasOptions()) {
            this.caller.coordsImported(this.importers[index].getAtomCoordsFrom(this.atomCoordsFile), this.importers[index].getType(), this.atomCoordsFile);
        } else {
            this.importers[index].createOptionsPanel(false, this, this.atomCoordsFile);
        }
    }

    private void createImporters() {
        int i;
        Document doc = XMLUtils.getDocumentFromURL(AtomCoordsIO.SUPPORTED_FILETYPE);
        Element root = doc.getRootElement();
        List list = root.getChildren("importer");
        Vector<String> vec = new Vector<String>();
        for (i = 0; i < list.size(); ++i) {
            String loadClass = ((Element)list.get(i)).getChildTextTrim("loadclass");
            vec.addElement(loadClass);
        }
        this.importers = new Importer[vec.size()];
        for (i = 0; i < vec.size(); ++i) {
            String load = (String)vec.get(i);
            this.importers[i] = (Importer)PluginLoader.instantiate(load, null);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        int index = this.getSelectedFileFilterIndex();
        this.caller.coordsImported(this.importers[index].getAtomCoordsFrom(this.atomCoordsFile), this.importers[index].getType(), this.atomCoordsFile);
    }
}

