/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer;

import ciss.phase_viewer.acviewer.ACVCaller;
import ciss.phase_viewer.acviewer.ACVData;
import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.Nfdynm2AtomCoords;
import ciss.phase_viewer.common.StringConstants;
import java.io.File;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ACViewer
implements ACVCaller {
    private static Logger logger = Logger.getLogger(ACViewer.class.getName());

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            System.out.println("Usage: java -jar ACViewer.jar F_DYNMfilename");
            System.exit(0);
        }
        String filename = args[0];
        Nfdynm2AtomCoords dynmParser = new Nfdynm2AtomCoords(filename);
        Vector frames = dynmParser.getFrames();
        ACViewer acv = new ACViewer();
        String parentDir = new File(filename).getParent();
        ACVData acvdata = new ACVData((ACVCaller)acv, frames, parentDir, null, StringConstants.phase_atom_tag);
        MainPanel mPanel = new MainPanel(acvdata);
        try {
            mPanel.display3D();
        }
        catch (Exception exception) {
            logger.warn("failed to show atomic configuration");
            exception.printStackTrace();
        }
    }

    public void save(AtomCoords coords) {
    }
}

