/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Viewer;

import AbinitMp.AbinitMpFile.TrajectoryFile;
import AbinitMp.Tool.GridBagLayoutPanel;
import AbinitMp.Tool.MyLabel;
import AbinitMp.Tool.MyPanel;
import AbinitMp.Tool.MyResourceBundle;
import AbinitMp.Viewer.MySwitchValueInterpolator;
import AbinitMp.Viewer.TrajectoryControlWindow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.media.j3d.Alpha;
import javax.media.j3d.Switch;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VideoControlPanel
extends MyPanel {
    private String[] buttonName = new String[]{"top", "back", "reverse", "stop", "play", "forward", "tail"};
    private static final int VIDEO_BUTTON_NUM = 7;
    private JButton[] videoButton = new JButton[7];
    private Icon[] icon = new Icon[7];
    private Icon[] icon_in = new Icon[7];
    private Icon[] icon_on = new Icon[7];
    public static final int TOP = 0;
    public static final int BACK = 1;
    public static final int REVERSE = 2;
    public static final int STOP = 3;
    public static final int PLAY = 4;
    public static final int FORWARD = 5;
    public static final int TAIL = 6;
    public static final int ANIMATION = 7;
    private JTextField videoIntervalText;
    private JTextField videoStepNoText = new JTextField("0", 3);
    private MyLabel energyLabel;
    private JSlider slider;
    private int mode = 1;
    private int switchNo = 0;
    private boolean sliderControl = true;
    private final Color color1 = new Color(255, 255, 40);
    private final Color color2 = new Color(68, 158, 255);
    public int playMode = 3;
    public int numStep = 0;
    public TrajectoryControlWindow trajectoryControlWindow;
    private MySwitchValueInterpolator sinterp = null;
    private Alpha alpha;
    private Switch switchGroup;
    private int loopCount = 1;

    public void drawStepNo(int n) {
        this.switchNo = n;
        this.videoStepNoText.setText(Integer.toString(n));
        this.sliderControl = false;
        this.slider.setValue(n);
        this.sliderControl = true;
        if (this.energyLabel != null) {
            this.energyLabel.setText(Float.toString(this.trajectoryControlWindow.trajectoryFile.data[n][0]));
        }
        this.trajectoryControlWindow.drawCurrentStepGraph(n);
        if (n == 0) {
            this.videoButton[2].setIcon(this.icon[2]);
            this.videoButton[2].setBackground(this.color1);
        }
        if (n == this.numStep - 1) {
            this.videoButton[4].setIcon(this.icon[4]);
            this.videoButton[4].setBackground(this.color1);
        }
    }

    public void createAnimationFile(File file) {
        this.playMode = 7;
        this.loopCount = 1;
        this.trajectoryControlWindow.viewer.getSceneViewer().startSaveImagefiles(file.getPath(), "image");
        this.setTopIndex();
        this.setAnimationIndex();
        this.mode = 1;
        this.setAlphaMode(this.mode);
        this.videoIntervalText.setText("1");
        this.setIntervalTime(1.0);
        this.setAlphaReset();
    }

    public VideoControlPanel(TrajectoryControlWindow trajectoryControlWindow) {
        GridBagLayoutPanel gridBagLayoutPanel;
        this.trajectoryControlWindow = trajectoryControlWindow;
        VideoCommand videoCommand = new VideoCommand();
        for (int i = 0; i < 7; ++i) {
            this.icon[i] = new ImageIcon(this.getClass().getResource("/AbinitMp/images/" + this.buttonName[i] + ".gif"));
            if (i != 3) {
                this.icon_in[i] = new ImageIcon(this.getClass().getResource("/AbinitMp/images/" + this.buttonName[i] + "_in.gif"));
            }
            if (i == 2 || i == 4) {
                this.icon_on[i] = new ImageIcon(this.getClass().getResource("/AbinitMp/images/" + this.buttonName[i] + "_on.gif"));
            }
            this.videoButton[i] = new JButton();
            this.videoButton[i].setToolTipText(this.buttonName[i]);
            this.videoButton[i].setActionCommand(this.buttonName[i]);
            this.videoButton[i].setBackground(this.color1);
            this.videoButton[i].setIcon(this.icon[i]);
            this.videoButton[i].setMargin(new Insets(-1, -1, -1, -1));
            if (i == 3) {
                this.videoButton[i].setPressedIcon(this.icon[i]);
            } else {
                this.videoButton[i].setPressedIcon(this.icon_in[i]);
            }
            this.videoButton[i].addActionListener(videoCommand);
        }
        JLabel jLabel = new JLabel(MyResourceBundle.getResourceString("VideoControlPanel.intervalTime"));
        JLabel jLabel2 = new JLabel(MyResourceBundle.getResourceString("VideoControlPanel.stepNo"));
        this.videoIntervalText = new JTextField("0.1", 3);
        this.setLayout(new BorderLayout());
        if (trajectoryControlWindow.trajectoryFile.type == 0) {
            this.energyLabel = new MyLabel();
            gridBagLayoutPanel = new GridBagLayoutPanel();
            gridBagLayoutPanel.layoutObject(new MyLabel(MyResourceBundle.getResourceString("VideoControlPanel.energy")), 0, 0, 1, 1, 1.0, 0.0);
            gridBagLayoutPanel.layoutObject(this.energyLabel, 1, 0, 1, 1, 1.0, 0.0);
            gridBagLayoutPanel.layoutObject(new JSeparator(), 0, 1, 0, 1, 1.0, 0.0);
            this.add((Component)gridBagLayoutPanel, "North");
        }
        this.videoStepNoText.addActionListener(new returnListener());
        gridBagLayoutPanel = new GridBagLayoutPanel();
        gridBagLayoutPanel.layoutObject(this.videoButton[0], 0, 0, 10, 5, 1.0, 0.0);
        gridBagLayoutPanel.layoutObject(this.videoButton[6], 20, 0, 10, 5, 1.0, 0.0);
        gridBagLayoutPanel.layoutObject(this.videoButton[2], 0, 5, 10, 5, 1.0, 0.0);
        gridBagLayoutPanel.layoutObject(this.videoButton[3], 10, 5, 10, 5, 1.0, 0.0);
        gridBagLayoutPanel.layoutObject(this.videoButton[4], 20, 5, 10, 5, 1.0, 0.0);
        gridBagLayoutPanel.layoutObject(this.videoButton[1], 0, 10, 10, 5, 1.0, 0.0);
        gridBagLayoutPanel.layoutObject(this.videoButton[5], 20, 10, 10, 5, 1.0, 0.0);
        gridBagLayoutPanel.layoutObject(jLabel, 5, 15, 15, 5, 1.0, 0.0);
        gridBagLayoutPanel.layoutObject(this.videoIntervalText, 20, 15, 10, 5, 1.0, 0.0);
        gridBagLayoutPanel.layoutObject(jLabel2, 5, 20, 15, 5, 1.0, 0.0);
        gridBagLayoutPanel.layoutObject(this.videoStepNoText, 20, 20, 10, 5, 1.0, 0.0);
        this.numStep = trajectoryControlWindow.trajectoryFile.stepNum;
        this.switchGroup = trajectoryControlWindow.trajectoryFile.getTrajectoryRoot();
        this.alpha = trajectoryControlWindow.trajectoryFile.getAlpha();
        this.sinterp = trajectoryControlWindow.trajectoryFile.getInterpolator();
        this.sinterp.setEnable(true);
        this.slider = new JSlider(0, this.numStep - 1, 0);
        this.slider.setPaintTicks(true);
        this.slider.setMajorTickSpacing(this.numStep / 2);
        this.slider.setPaintTrack(true);
        this.slider.setPaintLabels(true);
        this.slider.addChangeListener(new SliderListener());
        gridBagLayoutPanel.layoutObject(this.slider, 0, 25, 0, 1, 1.0, 0.0);
        this.add((Component)gridBagLayoutPanel, "Center");
    }

    public void reset(TrajectoryFile trajectoryFile) {
        this.numStep = trajectoryFile.stepNum;
        this.switchGroup = trajectoryFile.getTrajectoryRoot();
        this.alpha = trajectoryFile.getAlpha();
        this.sinterp = trajectoryFile.getInterpolator();
        this.sinterp.setEnable(true);
        this.setAlphaReset();
    }

    private void setIndex(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > this.numStep - 1) {
            n = this.numStep - 1;
        }
        this.sinterp.setFirstChildIndex(n);
        this.sinterp.setLastChildIndex(n);
        this.switchGroup.setWhichChild(n);
    }

    private void setStopIndex() {
        this.sinterp.setFirstChildIndex(this.switchGroup.getWhichChild());
        this.sinterp.setLastChildIndex(this.switchGroup.getWhichChild());
    }

    private void setPlayIndex() {
        this.sinterp.setFirstChildIndex(this.switchGroup.getWhichChild());
        this.sinterp.setLastChildIndex(this.numStep - 1);
    }

    private void setReverseIndex() {
        this.sinterp.setFirstChildIndex(0);
        this.sinterp.setLastChildIndex(this.switchGroup.getWhichChild());
    }

    private void setTopIndex() {
        this.sinterp.setFirstChildIndex(0);
        this.sinterp.setLastChildIndex(0);
    }

    private void setTailIndex() {
        this.sinterp.setFirstChildIndex(this.numStep - 1);
        this.sinterp.setLastChildIndex(this.numStep - 1);
    }

    private void setForwardIndex() {
        if (this.switchGroup.getWhichChild() != this.numStep - 1) {
            this.sinterp.setFirstChildIndex(this.switchGroup.getWhichChild() + 1);
            this.sinterp.setLastChildIndex(this.switchGroup.getWhichChild() + 1);
        } else {
            this.sinterp.setFirstChildIndex(this.switchGroup.getWhichChild());
            this.sinterp.setLastChildIndex(this.switchGroup.getWhichChild());
        }
    }

    private void setBackIndex() {
        if (this.switchGroup.getWhichChild() != 0) {
            this.sinterp.setFirstChildIndex(this.switchGroup.getWhichChild() - 1);
            this.sinterp.setLastChildIndex(this.switchGroup.getWhichChild() - 1);
        } else {
            this.sinterp.setFirstChildIndex(this.switchGroup.getWhichChild());
            this.sinterp.setLastChildIndex(this.switchGroup.getWhichChild());
        }
    }

    private void setAnimationIndex() {
        this.switchGroup.setWhichChild(0);
        this.sinterp.setFirstChildIndex(0);
        this.sinterp.setLastChildIndex(this.numStep - 1);
        this.sinterp.setAnimationInit();
    }

    private void setAlphaMode(int n) {
        this.alpha.setMode(n);
    }

    private void setAlphaReset() {
        this.alpha.setLoopCount(this.loopCount);
        this.alpha.setStartTime(System.currentTimeMillis());
    }

    public void setIntervalTime(double d) {
        this.alpha.setStartTime(System.currentTimeMillis());
        this.alpha.setIncreasingAlphaDuration((long)((int)(d * 1000.0 * (double)(this.numStep - this.switchGroup.getWhichChild()))));
        this.alpha.setDecreasingAlphaDuration((long)((int)(d * 1000.0 * (double)(this.switchGroup.getWhichChild() + 1))));
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public void setLoopCount(int n) {
        this.loopCount = n;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("main");
        jFrame.getContentPane().add(new VideoControlPanel(null));
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.setDefaultCloseOperation(3);
    }

    private class SliderListener
    implements ChangeListener {
        private SliderListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (VideoControlPanel.this.sliderControl) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                int n = jSlider.getValue();
                VideoControlPanel.this.sinterp.setFirstChildIndex(n);
                VideoControlPanel.this.sinterp.setLastChildIndex(n);
                VideoControlPanel.this.switchGroup.setWhichChild(n);
            }
        }
    }

    class returnListener
    extends AbstractAction {
        returnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextField jTextField = (JTextField)actionEvent.getSource();
            VideoControlPanel.this.setIndex(Integer.parseInt(jTextField.getText()));
        }
    }

    public class VideoCommand
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = ((JButton)actionEvent.getSource()).getActionCommand();
            double d = new Double(VideoControlPanel.this.videoIntervalText.getText());
            if (string.equals("reverse")) {
                VideoControlPanel.this.playMode = 2;
                if (VideoControlPanel.this.switchNo != 0) {
                    VideoControlPanel.this.videoButton[2].setIcon(VideoControlPanel.this.icon_on[2]);
                    VideoControlPanel.this.videoButton[2].setBackground(VideoControlPanel.this.color2);
                }
                VideoControlPanel.this.mode = 2;
                VideoControlPanel.this.setReverseIndex();
                VideoControlPanel.this.setIntervalTime(d);
                VideoControlPanel.this.setAlphaMode(VideoControlPanel.this.mode);
                VideoControlPanel.this.setAlphaReset();
            } else if (string.equals("play")) {
                VideoControlPanel.this.playMode = 4;
                if (VideoControlPanel.this.switchNo != VideoControlPanel.this.numStep - 1) {
                    VideoControlPanel.this.videoButton[4].setIcon(VideoControlPanel.this.icon_on[4]);
                    VideoControlPanel.this.videoButton[4].setBackground(VideoControlPanel.this.color2);
                }
                VideoControlPanel.this.mode = 1;
                VideoControlPanel.this.setAlphaMode(VideoControlPanel.this.mode);
                VideoControlPanel.this.setPlayIndex();
                VideoControlPanel.this.setIntervalTime(d);
                VideoControlPanel.this.setAlphaReset();
            } else if (string.equals("back")) {
                VideoControlPanel.this.playMode = 1;
                VideoControlPanel.this.videoButton[2].setIcon(VideoControlPanel.this.icon[2]);
                VideoControlPanel.this.videoButton[4].setIcon(VideoControlPanel.this.icon[4]);
                VideoControlPanel.this.videoButton[2].setBackground(VideoControlPanel.this.color1);
                VideoControlPanel.this.videoButton[4].setBackground(VideoControlPanel.this.color1);
                VideoControlPanel.this.setBackIndex();
                VideoControlPanel.this.mode = 2;
                VideoControlPanel.this.setAlphaMode(VideoControlPanel.this.mode);
                VideoControlPanel.this.setAlphaReset();
            } else if (string.equals("stop")) {
                VideoControlPanel.this.playMode = 3;
                VideoControlPanel.this.videoButton[2].setIcon(VideoControlPanel.this.icon[2]);
                VideoControlPanel.this.videoButton[4].setIcon(VideoControlPanel.this.icon[4]);
                VideoControlPanel.this.videoButton[2].setBackground(VideoControlPanel.this.color1);
                VideoControlPanel.this.videoButton[4].setBackground(VideoControlPanel.this.color1);
                VideoControlPanel.this.setStopIndex();
                VideoControlPanel.this.setAlphaReset();
            } else if (string.equals("forward")) {
                VideoControlPanel.this.playMode = 5;
                VideoControlPanel.this.videoButton[2].setIcon(VideoControlPanel.this.icon[2]);
                VideoControlPanel.this.videoButton[4].setIcon(VideoControlPanel.this.icon[4]);
                VideoControlPanel.this.videoButton[2].setBackground(VideoControlPanel.this.color1);
                VideoControlPanel.this.videoButton[4].setBackground(VideoControlPanel.this.color1);
                VideoControlPanel.this.setForwardIndex();
                VideoControlPanel.this.mode = 1;
                VideoControlPanel.this.setAlphaMode(VideoControlPanel.this.mode);
                VideoControlPanel.this.setAlphaReset();
            } else if (string.equals("top")) {
                VideoControlPanel.this.playMode = 0;
                VideoControlPanel.this.videoButton[2].setIcon(VideoControlPanel.this.icon[2]);
                VideoControlPanel.this.videoButton[4].setIcon(VideoControlPanel.this.icon[4]);
                VideoControlPanel.this.videoButton[2].setBackground(VideoControlPanel.this.color1);
                VideoControlPanel.this.videoButton[4].setBackground(VideoControlPanel.this.color1);
                VideoControlPanel.this.setTopIndex();
                VideoControlPanel.this.mode = 2;
                VideoControlPanel.this.setAlphaMode(VideoControlPanel.this.mode);
                VideoControlPanel.this.setAlphaReset();
            } else if (string.equals("tail")) {
                VideoControlPanel.this.playMode = 6;
                VideoControlPanel.this.videoButton[2].setIcon(VideoControlPanel.this.icon[2]);
                VideoControlPanel.this.videoButton[4].setIcon(VideoControlPanel.this.icon[4]);
                VideoControlPanel.this.videoButton[2].setBackground(VideoControlPanel.this.color1);
                VideoControlPanel.this.videoButton[4].setBackground(VideoControlPanel.this.color1);
                VideoControlPanel.this.setTailIndex();
                VideoControlPanel.this.mode = 1;
                VideoControlPanel.this.setAlphaMode(VideoControlPanel.this.mode);
                VideoControlPanel.this.setAlphaReset();
            }
        }
    }
}

