/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Viewer;

import AbinitMp.AbinitMpFile.GridFile;
import AbinitMp.Common.GaussianCubeFile;
import AbinitMp.Display.CellTool;
import AbinitMp.Display.FringeNode;
import AbinitMp.Display.IsoLineNode;
import AbinitMp.Display.IsosurfaceValue;
import AbinitMp.Display.SectionAssignNode;
import AbinitMp.Display.SectionAssignValue;
import AbinitMp.Structure.CoordInfo;
import AbinitMp.Tool.GridBagLayoutPanel;
import AbinitMp.Tool.MyButton;
import AbinitMp.Tool.MyComboBox;
import AbinitMp.Tool.MyLabel;
import AbinitMp.Tool.MyPanel;
import AbinitMp.Tool.MyRadioButton;
import AbinitMp.Tool.MyResourceBundle;
import AbinitMp.Viewer.AbinitMpViewer;
import AbinitMp.Viewer.FileItem;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.j3d.Node;
import javax.media.j3d.Switch;
import javax.media.j3d.Transform3D;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class SectionAssignPanel
extends GridBagLayoutPanel {
    private AbinitMpViewer viewer;
    private FileItem fileItem;
    private JTabbedPane assignTabPanel;
    private JButton addButton;
    private JButton deleteButton;
    private JTextField xCenterText;
    private JTextField yCenterText;
    private JTextField zCenterText;
    private JSlider xCenterSlider;
    private JSlider yCenterSlider;
    private JSlider zCenterSlider;
    private MyRadioButton rotationRadioButton;
    private MyRadioButton vectorRadioButton;
    private MyLabel thetaLabel;
    private MyLabel phaiLabel;
    private MyLabel cLabel;
    private MyLabel transparencyLabel;
    private JTextField xVectorText;
    private JTextField yVectorText;
    private JTextField zVectorText;
    private JSlider thetaSlider;
    private JSlider phaiSlider;
    private JSlider cSlider;
    private JSlider transparencySlider;
    private JTextField minValueText;
    private JTextField maxValueText;
    private JTextField lineNumText;
    private MyRadioButton onRadioButton;
    private MyRadioButton offRadioButton;
    private MyComboBox valueComboBox;
    private MyComboBox sectionNumComboBox;
    private MyComboBox planeComboBox;
    private MyRadioButton fringeRadioButton;
    private MyRadioButton lineRadioButton;
    private Vector assignValues;
    private int currentNo;
    private IsosurfaceValue isovalue;

    public SectionAssignPanel(AbinitMpViewer abinitMpViewer, final FileItem fileItem, IsosurfaceValue isosurfaceValue) {
        Object object;
        this.viewer = abinitMpViewer;
        this.fileItem = fileItem;
        this.isovalue = isosurfaceValue;
        this.assignValues = isosurfaceValue.sectionAssignValueVector;
        if (this.assignValues.size() == 0) {
            object = this.createNewSectionAssignValue();
            this.assignValues.add(object);
        }
        object = new MyPanel(new FlowLayout(0));
        ((Container)object).add(new JLabel("No."));
        String[] stringArray = new String[this.assignValues.size()];
        for (int i = 0; i < this.assignValues.size(); ++i) {
            stringArray[i] = Integer.toString(i + 1);
        }
        this.sectionNumComboBox = new MyComboBox(stringArray);
        ((Container)object).add(this.sectionNumComboBox);
        this.sectionNumComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getSource();
                if (itemEvent.getStateChange() == 1 && SectionAssignPanel.this.currentNo >= 0) {
                    SectionAssignPanel.this.setAssignToVector(SectionAssignPanel.this.currentNo);
                    SectionAssignPanel.this.currentNo = jComboBox.getSelectedIndex();
                    SectionAssignPanel.this.setAssignToGui(SectionAssignPanel.this.currentNo);
                }
            }
        });
        this.addButton = new JButton(MyResourceBundle.getResourceString("SectionAssignPanel.add"));
        this.deleteButton = new JButton(MyResourceBundle.getResourceString("SectionAssignPanel.delete"));
        ((Container)object).add(this.addButton);
        ((Container)object).add(this.deleteButton);
        this.addButton.addActionListener(new addListener());
        this.deleteButton.addActionListener(new deleteListener());
        this.assignTabPanel = new JTabbedPane();
        GridBagLayoutPanel gridBagLayoutPanel = new GridBagLayoutPanel();
        gridBagLayoutPanel.setBorder(new TitledBorder(MyResourceBundle.getResourceString("SectionAssignPanel.assignPlaneTitle")));
        GridBagLayoutPanel gridBagLayoutPanel2 = new GridBagLayoutPanel();
        this.xCenterText = new JTextField();
        this.xCenterText.setPreferredSize(new Dimension(50, 25));
        this.yCenterText = new JTextField();
        this.yCenterText.setPreferredSize(new Dimension(50, 25));
        this.zCenterText = new JTextField();
        this.zCenterText.setPreferredSize(new Dimension(50, 25));
        float[] fArray = this.getMinMax();
        MyPanel myPanel = new MyPanel();
        myPanel.add(this.xCenterText);
        this.xCenterSlider = this.createPositionSlider(this.xCenterText, fArray[0], fArray[3]);
        myPanel.add(this.xCenterSlider);
        MyPanel myPanel2 = new MyPanel();
        myPanel2.add(this.yCenterText);
        this.yCenterSlider = this.createPositionSlider(this.yCenterText, fArray[1], fArray[4]);
        myPanel2.add(this.yCenterSlider);
        MyPanel myPanel3 = new MyPanel();
        myPanel3.add(this.zCenterText);
        this.zCenterSlider = this.createPositionSlider(this.zCenterText, fArray[2], fArray[5]);
        myPanel3.add(this.zCenterSlider);
        this.xCenterText.addActionListener(new returnCenterListener());
        this.yCenterText.addActionListener(new returnCenterListener());
        this.zCenterText.addActionListener(new returnCenterListener());
        gridBagLayoutPanel2.layoutObject(new MyLabel("X"), 0, 0, 3, 1, 1.0, 0.0);
        gridBagLayoutPanel2.layoutObject(myPanel, 3, 0, 20, 1, 1.0, 0.0);
        gridBagLayoutPanel2.layoutObject(new MyLabel("Y"), 0, 1, 3, 1, 1.0, 0.0);
        gridBagLayoutPanel2.layoutObject(myPanel2, 3, 1, 20, 1, 1.0, 0.0);
        gridBagLayoutPanel2.layoutObject(new MyLabel("Z"), 0, 2, 3, 1, 1.0, 0.0);
        gridBagLayoutPanel2.layoutObject(myPanel3, 3, 2, 20, 1, 1.0, 0.0);
        GridBagLayoutPanel gridBagLayoutPanel3 = new GridBagLayoutPanel();
        this.rotationRadioButton = new MyRadioButton(MyResourceBundle.getResourceString("SectionAssignPanel.rotation"));
        this.vectorRadioButton = new MyRadioButton(MyResourceBundle.getResourceString("SectionAssignPanel.vector"));
        this.rotationRadioButton.setSelected(true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rotationRadioButton);
        buttonGroup.add(this.vectorRadioButton);
        MyPanel myPanel4 = new MyPanel(new FlowLayout(0));
        myPanel4.add(this.rotationRadioButton);
        myPanel4.add(this.vectorRadioButton);
        this.rotationRadioButton.addActionListener(new rotationVectorListener(true));
        this.vectorRadioButton.addActionListener(new rotationVectorListener(false));
        gridBagLayoutPanel3.layoutObject(new MyLabel("Type"), 0, 0, 3, 1, 1.0, 0.0);
        gridBagLayoutPanel3.layoutObject(myPanel4, 3, 0, 0, 1, 1.0, 0.0);
        gridBagLayoutPanel3.layoutObject(new JSeparator(), 0, 1, 0, 1, 1.0, 0.0);
        this.thetaLabel = new MyLabel();
        this.thetaLabel.setPreferredSize(new Dimension(50, 25));
        this.thetaLabel.setHorizontalAlignment(4);
        MyPanel myPanel5 = new MyPanel();
        myPanel5.add(this.thetaLabel);
        this.phaiLabel = new MyLabel();
        this.phaiLabel.setPreferredSize(new Dimension(50, 25));
        this.phaiLabel.setHorizontalAlignment(4);
        MyPanel myPanel6 = new MyPanel();
        myPanel6.add(this.phaiLabel);
        this.cLabel = new MyLabel();
        this.cLabel.setPreferredSize(new Dimension(50, 25));
        this.cLabel.setHorizontalAlignment(4);
        MyPanel myPanel7 = new MyPanel();
        myPanel7.add(this.cLabel);
        MyLabel myLabel = new MyLabel(MyResourceBundle.getResourceString("SectionAssignPanel.theta"));
        myLabel.setForeground(new Color(0.75f, 0.0f, 0.75f));
        gridBagLayoutPanel3.layoutObject(myLabel, 0, 2, 2, 1, 1.0, 0.0);
        gridBagLayoutPanel3.layoutObject(myPanel5, 2, 2, 3, 1, 1.0, 0.0);
        this.thetaSlider = this.createSlider(this.thetaLabel, 0);
        gridBagLayoutPanel3.layoutObject(this.thetaSlider, 4, 2, 10, 1, 1.0, 0.0);
        MyLabel myLabel2 = new MyLabel(MyResourceBundle.getResourceString("SectionAssignPanel.phai"));
        myLabel2.setForeground(new Color(1.0f, 0.25f, 0.0f));
        gridBagLayoutPanel3.layoutObject(myLabel2, 0, 3, 2, 1, 1.0, 0.0);
        gridBagLayoutPanel3.layoutObject(myPanel6, 2, 3, 2, 1, 1.0, 0.0);
        this.phaiSlider = this.createSlider(this.phaiLabel, 1);
        gridBagLayoutPanel3.layoutObject(this.phaiSlider, 4, 3, 10, 1, 1.0, 0.0);
        gridBagLayoutPanel3.layoutObject(new MyLabel(MyResourceBundle.getResourceString("SectionAssignPanel.c")), 0, 4, 2, 1, 1.0, 0.0);
        gridBagLayoutPanel3.layoutObject(myPanel7, 2, 4, 2, 1, 1.0, 0.0);
        this.cSlider = this.createSlider(this.cLabel, 2);
        gridBagLayoutPanel3.layoutObject(this.cSlider, 4, 4, 10, 1, 1.0, 0.0);
        gridBagLayoutPanel3.layoutObject(new JSeparator(), 0, 5, 0, 1, 1.0, 0.0);
        gridBagLayoutPanel3.layoutObject(new MyLabel("Vector"), 0, 5, 1, 1, 1.0, 0.0);
        MyPanel myPanel8 = new MyPanel();
        this.xVectorText = new JTextField("0");
        this.xVectorText.setPreferredSize(new Dimension(40, 25));
        this.yVectorText = new JTextField("1");
        this.yVectorText.setPreferredSize(new Dimension(40, 25));
        this.zVectorText = new JTextField("0");
        this.zVectorText.setPreferredSize(new Dimension(40, 25));
        this.xVectorText.addActionListener(new returnVectorListener());
        this.yVectorText.addActionListener(new returnVectorListener());
        this.zVectorText.addActionListener(new returnVectorListener());
        myPanel8.add(new MyLabel("x"));
        myPanel8.add(this.xVectorText);
        myPanel8.add(new MyLabel("y"));
        myPanel8.add(this.yVectorText);
        myPanel8.add(new MyLabel("z"));
        myPanel8.add(this.zVectorText);
        gridBagLayoutPanel3.layoutObject(myPanel8, 3, 5, 0, 1, 1.0, 0.0);
        this.assignTabPanel.addTab("Center", gridBagLayoutPanel2);
        this.assignTabPanel.addTab("Angle", gridBagLayoutPanel3);
        gridBagLayoutPanel.layoutObject(this.assignTabPanel, 0, 0, 1, 5, 1.0, 0.0);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        MyButton myButton = new MyButton(MyResourceBundle.getResourceString("reset"));
        myButton.addActionListener(new resetListener());
        this.planeComboBox = new MyComboBox(new String[]{"xy", "yz", "xz"});
        this.planeComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getSource();
                if (itemEvent.getStateChange() == 1) {
                    String string;
                    String string2;
                    String string3;
                    int n = jComboBox.getSelectedIndex();
                    if (n == 0) {
                        string3 = "0";
                        string2 = "0";
                        string = "1";
                    } else if (n == 1) {
                        string3 = "1";
                        string2 = "0";
                        string = "0";
                    } else {
                        string3 = "0";
                        string2 = "1";
                        string = "1";
                    }
                    DecimalFormat decimalFormat = new DecimalFormat("###0.0000");
                    SectionAssignPanel.this.thetaSlider.setValue(0);
                    SectionAssignPanel.this.phaiSlider.setValue(0);
                    SectionAssignPanel.this.cSlider.setValue(0);
                    SectionAssignPanel.this.thetaLabel.setText("0");
                    SectionAssignPanel.this.phaiLabel.setText("0");
                    SectionAssignPanel.this.cLabel.setText("0");
                    SectionAssignPanel.this.xCenterSlider.setValue((int)fileItem.coordInfo.xcenter * 10);
                    SectionAssignPanel.this.yCenterSlider.setValue((int)fileItem.coordInfo.ycenter * 10);
                    SectionAssignPanel.this.zCenterSlider.setValue((int)fileItem.coordInfo.zcenter * 10);
                    SectionAssignPanel.this.xCenterText.setText(decimalFormat.format(fileItem.coordInfo.xcenter));
                    SectionAssignPanel.this.yCenterText.setText(decimalFormat.format(fileItem.coordInfo.ycenter));
                    SectionAssignPanel.this.zCenterText.setText(decimalFormat.format(fileItem.coordInfo.zcenter));
                    SectionAssignPanel.this.xVectorText.setText(string3);
                    SectionAssignPanel.this.yVectorText.setText(string2);
                    SectionAssignPanel.this.zVectorText.setText(string);
                    SectionAssignPanel.this.getCurrentSectionAssignNode().reset(n);
                }
            }
        });
        MyLabel myLabel3 = new MyLabel(MyResourceBundle.getResourceString("SectionAssignPanel.setPlane"));
        myLabel3.setPreferredSize(new Dimension(100, 25));
        jPanel.add(myLabel3);
        jPanel.add(this.planeComboBox);
        gridBagLayoutPanel.layoutObject(jPanel, 0, 8, 0, 1, 1.0, 0.0);
        GridBagLayoutPanel gridBagLayoutPanel4 = new GridBagLayoutPanel();
        gridBagLayoutPanel4.setBorder(new TitledBorder(MyResourceBundle.getResourceString("SectionAssignPanel.sectionTitle")));
        this.onRadioButton = new MyRadioButton(MyResourceBundle.getResourceString("on"));
        this.offRadioButton = new MyRadioButton(MyResourceBundle.getResourceString("off"));
        this.onRadioButton.setSelected(true);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.onRadioButton);
        buttonGroup2.add(this.offRadioButton);
        MyPanel myPanel9 = new MyPanel(new FlowLayout(0));
        myPanel9.add(this.onRadioButton);
        myPanel9.add(this.offRadioButton);
        gridBagLayoutPanel4.layoutObject(new MyLabel(MyResourceBundle.getResourceString("SectionAssignPanel.display")), 0, 0, 3, 1, 1.0, 0.0);
        gridBagLayoutPanel4.layoutObject(myPanel9, 3, 0, 3, 1, 1.0, 0.0);
        String[] stringArray2 = null;
        if (fileItem.type == 0 || fileItem.type == 8 || fileItem.type == 14) {
            stringArray2 = new String[]{"Density"};
        } else if (fileItem.type == 3 || fileItem.type == 10) {
            stringArray2 = new String[]{"MO"};
        } else if (fileItem.type == 2 || fileItem.type == 12) {
            stringArray2 = new String[]{"Electrostatic Potential", "Density"};
        } else if (fileItem.type == 1 || fileItem.type == 9) {
            stringArray2 = new String[]{"Electrostatic Potential"};
        }
        this.valueComboBox = new MyComboBox(stringArray2);
        this.valueComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getSource();
                if (itemEvent.getStateChange() == 1) {
                    if (jComboBox.getSelectedIndex() == 0) {
                        SectionAssignPanel.this.minValueText.setText("-0.02");
                        SectionAssignPanel.this.maxValueText.setText("0.02");
                        SectionAssignPanel.this.lineNumText.setText("9");
                    } else {
                        SectionAssignPanel.this.minValueText.setText("1e-8");
                        SectionAssignPanel.this.maxValueText.setText("0.1");
                        SectionAssignPanel.this.lineNumText.setText("8");
                    }
                }
            }
        });
        gridBagLayoutPanel4.layoutObject(new MyLabel(MyResourceBundle.getResourceString("SectionAssignPanel.value")), 0, 1, 3, 1, 1.0, 0.0);
        gridBagLayoutPanel4.layoutObject(this.valueComboBox, 3, 1, 3, 1, 1.0, 0.0);
        gridBagLayoutPanel4.layoutObject(new MyLabel(MyResourceBundle.getResourceString("SectionAssignPanel.range")), 0, 2, 3, 1, 1.0, 0.0);
        MyPanel myPanel10 = new MyPanel(new FlowLayout(0));
        myPanel10.add(new MyLabel("Min"));
        this.minValueText = new JTextField();
        this.minValueText.setPreferredSize(new Dimension(50, 25));
        myPanel10.add(this.minValueText);
        myPanel10.add(new MyLabel("Max"));
        this.maxValueText = new JTextField();
        this.maxValueText.setPreferredSize(new Dimension(50, 25));
        myPanel10.add(this.maxValueText);
        gridBagLayoutPanel4.layoutObject(myPanel10, 3, 2, 5, 1, 1.0, 0.0);
        this.fringeRadioButton = new MyRadioButton(MyResourceBundle.getResourceString("SectionAssignPanel.fringe"));
        this.lineRadioButton = new MyRadioButton(MyResourceBundle.getResourceString("SectionAssignPanel.line"));
        this.fringeRadioButton.setSelected(true);
        ButtonGroup buttonGroup3 = new ButtonGroup();
        buttonGroup3.add(this.fringeRadioButton);
        buttonGroup3.add(this.lineRadioButton);
        MyPanel myPanel11 = new MyPanel(new FlowLayout(0));
        myPanel11.add(this.fringeRadioButton);
        myPanel11.add(this.lineRadioButton);
        this.fringeRadioButton.addActionListener(new fringeLineListener(false));
        this.lineRadioButton.addActionListener(new fringeLineListener(true));
        gridBagLayoutPanel4.layoutObject(new MyLabel("Type"), 0, 3, 3, 1, 1.0, 0.0);
        gridBagLayoutPanel4.layoutObject(myPanel11, 3, 3, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel4.layoutObject(new MyLabel(MyResourceBundle.getResourceString("SectionAssignPanel.transparency")), 0, 4, 2, 1, 1.0, 0.0);
        this.transparencyLabel = new MyLabel();
        this.transparencyLabel.setPreferredSize(new Dimension(30, 25));
        this.transparencyLabel.setHorizontalAlignment(4);
        MyPanel myPanel12 = new MyPanel();
        myPanel12.add(this.transparencyLabel);
        gridBagLayoutPanel4.layoutObject(myPanel12, 2, 4, 3, 1, 1.0, 0.0);
        this.transparencySlider = new JSlider(0, 100, 0);
        this.transparencySlider.setPreferredSize(new Dimension(150, 40));
        this.transparencySlider.setPaintTicks(true);
        this.transparencySlider.setMajorTickSpacing(50);
        this.transparencySlider.setPaintTrack(true);
        this.transparencySlider.setPaintLabels(true);
        this.transparencySlider.addChangeListener(new transparencySliderListener(this.transparencyLabel));
        gridBagLayoutPanel4.layoutObject(this.transparencySlider, 5, 4, 10, 1, 1.0, 0.0);
        this.lineNumText = new JTextField();
        this.lineNumText.setPreferredSize(new Dimension(50, 25));
        MyPanel myPanel13 = new MyPanel(new FlowLayout(0));
        myPanel13.add(this.lineNumText);
        gridBagLayoutPanel4.layoutObject(new MyLabel(MyResourceBundle.getResourceString("SectionAssignPanel.lineNum")), 0, 5, 3, 1, 1.0, 0.0);
        gridBagLayoutPanel4.layoutObject(myPanel13, 3, 5, 5, 1, 1.0, 0.0);
        this.lineNumText.setEnabled(false);
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        MyButton myButton2 = new MyButton(MyResourceBundle.getResourceString("draw"));
        myButton2.addActionListener(new drawListener());
        jPanel2.add(myButton2);
        gridBagLayoutPanel4.layoutObject(jPanel2, 0, 6, 0, 1, 1.0, 0.0);
        this.layoutObject(object, 0, 0, 1, 1, 1.0, 0.0);
        this.layoutObject(gridBagLayoutPanel, 0, 1, 1, 1, 1.0, 0.0);
        this.layoutObject(gridBagLayoutPanel4, 0, 2, 1, 1, 1.0, 0.0);
        this.setAssignToGui(this.currentNo);
    }

    public void createSectionNode(Switch switch_) {
        CoordInfo coordInfo = this.viewer.getCoordInfo();
        Point3f point3f = new Point3f(coordInfo.xcenter, coordInfo.ycenter, coordInfo.zcenter);
        this.fileItem.sectionFileRootNode.detach();
        for (int i = 0; i < this.assignValues.size(); ++i) {
            BitSet bitSet;
            Object object;
            SectionAssignValue sectionAssignValue = (SectionAssignValue)this.assignValues.get(i);
            Vector vector = null;
            Vector vector2 = null;
            Vector<Integer> vector3 = null;
            SectionAssignNode sectionAssignNode = sectionAssignValue.getSectionAssignNode();
            Switch switch_2 = switch_ == null ? sectionAssignValue.getSectionRootNode() : switch_;
            if (sectionAssignValue.getDisplay()) {
                vector = new Vector();
                vector2 = new Vector();
                vector3 = new Vector<Integer>();
                object = new Transform3D();
                sectionAssignNode.getTransform((Transform3D)object);
                bitSet = new Vector3f();
                Matrix3f matrix3f = new Matrix3f();
                object.get(matrix3f, (Vector3f)bitSet);
                float f = ((Vector3f)bitSet).x + coordInfo.xcenter;
                float f2 = ((Vector3f)bitSet).y + coordInfo.ycenter;
                float f3 = ((Vector3f)bitSet).z + coordInfo.zcenter;
                Vector3f vector3f = new Vector3f(matrix3f.m01, matrix3f.m11, matrix3f.m21);
                Point3f point3f2 = new Point3f(f, f2 + 1.0E-5f, f3);
                float[] fArray = null;
                int n = 0;
                GridFile gridFile = (GridFile)this.fileItem.file;
                if (this.fileItem.type == 0 || this.fileItem.type == 14 || this.fileItem.type == 8) {
                    fArray = gridFile.densityValue;
                } else if (this.fileItem.type == 2 || this.fileItem.type == 12) {
                    if (sectionAssignValue.getValueType() == 0) {
                        fArray = gridFile.potentialValue;
                        n = 1;
                    } else {
                        fArray = gridFile.densityValue;
                    }
                } else if (this.fileItem.type == 10 || this.fileItem.type == 3) {
                    fArray = gridFile.densityValue;
                } else if (this.fileItem.type == 1 || this.fileItem.type == 9) {
                    fArray = gridFile.densityValue;
                    n = 1;
                }
                float[][][] fArray2 = new float[gridFile.nx][gridFile.ny][gridFile.nz];
                for (int j = 0; j < gridFile.nz - 1; ++j) {
                    for (int k = 0; k < gridFile.ny - 1; ++k) {
                        for (int i2 = 0; i2 < gridFile.nx - 1; ++i2) {
                            int n2;
                            Point3f[] point3fArray = this.fileItem.type == 0 || this.fileItem.type == 2 || this.fileItem.type == 12 || this.fileItem.type == 3 || this.fileItem.type == 1 || this.fileItem.type == 14 ? CellTool.getCellApexCoordinate(i2, k, j, gridFile.xx, gridFile.yy, gridFile.zz) : CellTool.getCellApexCoordinate(i2, k, j, gridFile.x, gridFile.y, gridFile.z, gridFile.nx, gridFile.ny, gridFile.nz);
                            if (point3fArray == null || !CellTool.isCross(point3fArray, vector3f, point3f2) || (n2 = CellTool.crossPoint(point3fArray, vector3f, point3f2, i2, k, j, vector, vector2, gridFile.x, gridFile.y, gridFile.z, gridFile.xx, gridFile.yy, gridFile.zz, gridFile.nx, gridFile.ny, gridFile.nz, fArray, n, this.fileItem.type)) == 0) continue;
                            vector3.add(new Integer(n2));
                        }
                    }
                }
            }
            object = null;
            if (vector != null && vector.size() > 0) {
                object = sectionAssignValue.getFringeOrLine() ? new FringeNode(vector, vector2, vector3, this.fileItem, sectionAssignValue, this.isovalue.potentialColor, point3f) : new IsoLineNode(vector, vector2, vector3, this.fileItem, sectionAssignValue, this.isovalue.potentialColor, point3f);
            }
            bitSet = new BitSet();
            bitSet.set(1);
            if (switch_2.numChildren() == 2) {
                switch_2.removeChild(1);
            }
            switch_2.setChildMask(bitSet);
            if (object == null) continue;
            switch_2.addChild((Node)object);
        }
        this.viewer.addSectionFileRootNode(this.fileItem.sectionFileRootNode);
    }

    public void moveSectionAssignNode() {
        CoordInfo coordInfo = this.viewer.getCoordInfo();
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (int i = 0; i < this.assignValues.size(); ++i) {
            SectionAssignValue sectionAssignValue = (SectionAssignValue)this.assignValues.get(i);
            Point3f point3f = sectionAssignValue.getCenter();
            f = point3f.x - coordInfo.xcenter;
            f2 = point3f.y - coordInfo.ycenter;
            f3 = point3f.z - coordInfo.zcenter;
            sectionAssignValue.getSectionAssignNode().translation(f, f2, f3);
        }
    }

    private JSlider createPositionSlider(JTextField jTextField, float f, float f2) {
        int n = ((int)(f2 *= 10.0f) - (int)(f *= 10.0f)) / 2 + (int)f;
        JSlider jSlider = new JSlider((int)f, (int)f2, n);
        jSlider.setMajorTickSpacing((int)f2 - (int)f);
        jSlider.setMinorTickSpacing(10);
        jSlider.setPreferredSize(new Dimension(150, 40));
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer((int)f), new JLabel(Integer.toString((int)f / 10)));
        hashtable.put(new Integer((int)f2), new JLabel(Integer.toString((int)f2 / 10)));
        jSlider.setLabelTable(hashtable);
        jSlider.setPaintTicks(true);
        jSlider.setPaintTrack(true);
        jSlider.setPaintLabels(true);
        jSlider.addChangeListener(new CenterSliderListener(jTextField));
        return jSlider;
    }

    private JSlider createSlider(MyLabel myLabel, int n) {
        JSlider jSlider = new JSlider(-180, 180, 0);
        jSlider.setPreferredSize(new Dimension(150, 40));
        jSlider.setPaintTicks(true);
        jSlider.setMajorTickSpacing(180);
        jSlider.setPaintTrack(true);
        jSlider.setPaintLabels(true);
        jSlider.addChangeListener(new SliderListener(myLabel, n));
        return jSlider;
    }

    private void setCenterCoordinate() {
        CoordInfo coordInfo = this.viewer.getCoordInfo();
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        f = this.getFloatValue(this.xCenterText) - coordInfo.xcenter;
        f2 = this.getFloatValue(this.yCenterText) - coordInfo.ycenter;
        f3 = this.getFloatValue(this.zCenterText) - coordInfo.zcenter;
        this.getCurrentSectionAssignNode().translation(f, f2, f3);
    }

    private void reset() {
        DecimalFormat decimalFormat = new DecimalFormat("###0.0000");
        this.xCenterSlider.setValue((int)this.fileItem.coordInfo.xcenter * 10);
        this.yCenterSlider.setValue((int)this.fileItem.coordInfo.ycenter * 10);
        this.zCenterSlider.setValue((int)this.fileItem.coordInfo.zcenter * 10);
        this.xCenterText.setText(decimalFormat.format(this.fileItem.coordInfo.xcenter));
        this.yCenterText.setText(decimalFormat.format(this.fileItem.coordInfo.ycenter));
        this.zCenterText.setText(decimalFormat.format(this.fileItem.coordInfo.zcenter));
        this.thetaSlider.setValue(0);
        this.phaiSlider.setValue(0);
        this.cSlider.setValue(0);
        this.thetaLabel.setText("0");
        this.phaiLabel.setText("0");
        this.cLabel.setText("0");
        this.xVectorText.setText("0");
        this.yVectorText.setText("1");
        this.zVectorText.setText("0");
        this.getCurrentSectionAssignNode().reset(0);
    }

    private void setAssignToVector(int n) {
        int n2;
        float f = this.getFloatValue(this.xCenterText);
        float f2 = this.getFloatValue(this.yCenterText);
        float f3 = this.getFloatValue(this.zCenterText);
        Point3f point3f = new Point3f(f, f2, f3);
        boolean bl = this.rotationRadioButton.isSelected();
        if (bl) {
            f = this.getFloatValue(this.thetaLabel);
            f2 = this.getFloatValue(this.phaiLabel);
            f3 = this.getFloatValue(this.cLabel);
        } else {
            f = this.getFloatValue(this.xVectorText);
            f2 = this.getFloatValue(this.yVectorText);
            f3 = this.getFloatValue(this.zVectorText);
        }
        Point3f point3f2 = new Point3f(f, f2, f3);
        int n3 = this.valueComboBox.getSelectedIndex();
        float f4 = this.getFloatValue(this.minValueText);
        float f5 = this.getFloatValue(this.maxValueText);
        try {
            n2 = Integer.parseInt(this.lineNumText.getText());
        }
        catch (Exception exception) {
            n2 = 10;
        }
        boolean bl2 = this.onRadioButton.isSelected();
        boolean bl3 = this.fringeRadioButton.isSelected();
        int n4 = (int)this.getFloatValue(this.transparencyLabel);
        SectionAssignValue sectionAssignValue = (SectionAssignValue)this.assignValues.get(n);
        sectionAssignValue.set(point3f, point3f2, bl, bl2, n3, f4, f5, bl3, n4, n2);
    }

    private void setAssignToGui(int n) {
        SectionAssignValue sectionAssignValue = (SectionAssignValue)this.assignValues.get(n);
        DecimalFormat decimalFormat = new DecimalFormat("###0.0000");
        this.xCenterText.setText(decimalFormat.format(sectionAssignValue.getCenter().x));
        this.yCenterText.setText(decimalFormat.format(sectionAssignValue.getCenter().y));
        this.zCenterText.setText(decimalFormat.format(sectionAssignValue.getCenter().z));
        if (sectionAssignValue.getRotationOrVector()) {
            this.rotationRadioButton.setSelected(true);
            this.vectorRadioButton.setSelected(false);
            this.thetaSlider.setEnabled(true);
            this.phaiSlider.setEnabled(true);
            this.cSlider.setEnabled(true);
            this.thetaLabel.setEnabled(true);
            this.phaiLabel.setEnabled(true);
            this.cLabel.setEnabled(true);
            this.xVectorText.setEnabled(false);
            this.yVectorText.setEnabled(false);
            this.zVectorText.setEnabled(false);
            this.thetaSlider.setValue((int)sectionAssignValue.getAngle().x);
            this.phaiSlider.setValue((int)sectionAssignValue.getAngle().y);
            this.thetaLabel.setText(Float.toString(sectionAssignValue.getAngle().x));
            this.phaiLabel.setText(Float.toString(sectionAssignValue.getAngle().y));
            this.cLabel.setText(Float.toString(sectionAssignValue.getAngle().z));
        } else {
            this.rotationRadioButton.setSelected(false);
            this.vectorRadioButton.setSelected(true);
            this.thetaSlider.setEnabled(false);
            this.phaiSlider.setEnabled(false);
            this.cSlider.setEnabled(false);
            this.thetaLabel.setEnabled(false);
            this.phaiLabel.setEnabled(false);
            this.cLabel.setEnabled(false);
            this.xVectorText.setEnabled(true);
            this.yVectorText.setEnabled(true);
            this.zVectorText.setEnabled(true);
            this.xVectorText.setText(Float.toString(sectionAssignValue.getAngle().x));
            this.yVectorText.setText(Float.toString(sectionAssignValue.getAngle().y));
            this.zVectorText.setText(Float.toString(sectionAssignValue.getAngle().z));
            this.thetaLabel.setText("0");
            this.phaiLabel.setText("0");
            this.cLabel.setText("0");
            this.thetaSlider.setValue(0);
            this.phaiSlider.setValue(0);
            this.cSlider.setValue(0);
        }
        if (sectionAssignValue.getDisplay()) {
            this.onRadioButton.setSelected(true);
            this.offRadioButton.setSelected(false);
        } else {
            this.onRadioButton.setSelected(false);
            this.offRadioButton.setSelected(true);
        }
        if (sectionAssignValue.getFringeOrLine()) {
            this.fringeRadioButton.setSelected(true);
            this.lineRadioButton.setSelected(false);
            this.lineNumText.setEnabled(false);
            this.transparencyLabel.setEnabled(true);
            this.transparencySlider.setEnabled(true);
        } else {
            this.fringeRadioButton.setSelected(false);
            this.lineRadioButton.setSelected(true);
            this.lineNumText.setEnabled(true);
            this.transparencyLabel.setEnabled(false);
            this.transparencySlider.setEnabled(false);
        }
        this.valueComboBox.setSelectedIndex(sectionAssignValue.getValueType());
        this.minValueText.setText(Float.toString(sectionAssignValue.getMin()));
        this.maxValueText.setText(Float.toString(sectionAssignValue.getMax()));
        this.lineNumText.setText(Integer.toString(sectionAssignValue.getLineNum()));
        this.transparencyLabel.setText(Integer.toString(sectionAssignValue.getTransparency()));
        this.transparencySlider.setValue(sectionAssignValue.getTransparency());
    }

    private Switch createSectionAssignNode() {
        Switch switch_ = new Switch(-3);
        switch_.setCapability(14);
        switch_.setCapability(12);
        switch_.setCapability(13);
        switch_.setCapability(18);
        switch_.setCapability(17);
        switch_.setUserData((Object)new String("Section"));
        BitSet bitSet = new BitSet();
        bitSet.set(0);
        switch_.setChildMask(bitSet);
        if (this.fileItem.type == 12) {
            this.fileItem.electricFieldAssignValue.sectionRoot = switch_;
        } else {
            this.fileItem.isosurfaceValue.sectionRoot = switch_;
        }
        SectionAssignNode sectionAssignNode = new SectionAssignNode(this.viewer, this.fileItem);
        sectionAssignNode.reset(0);
        switch_.addChild((Node)sectionAssignNode);
        this.viewer.addSectionRootNode(this.fileItem, (Node)switch_);
        return switch_;
    }

    private void displaySectionPlane() {
        SectionAssignValue sectionAssignValue = (SectionAssignValue)this.assignValues.get(this.currentNo);
        Switch switch_ = sectionAssignValue.getSectionRootNode();
        BitSet bitSet = new BitSet();
        bitSet.set(0);
        bitSet.set(1);
        switch_.setChildMask(bitSet);
    }

    public void undisplaySectionPlane() {
        SectionAssignValue sectionAssignValue = (SectionAssignValue)this.assignValues.get(this.currentNo);
        Switch switch_ = sectionAssignValue.getSectionRootNode();
        BitSet bitSet = new BitSet();
        switch_.setChildMask(bitSet);
    }

    private SectionAssignNode getCurrentSectionAssignNode() {
        SectionAssignValue sectionAssignValue = (SectionAssignValue)this.assignValues.get(this.currentNo);
        return sectionAssignValue.getSectionAssignNode();
    }

    private float getFloatValue(JTextField jTextField) {
        float f;
        try {
            f = Float.parseFloat(jTextField.getText());
        }
        catch (Exception exception) {
            f = 0.0f;
        }
        return f;
    }

    private float getFloatValue(JLabel jLabel) {
        float f;
        try {
            f = Float.parseFloat(jLabel.getText());
        }
        catch (Exception exception) {
            f = 0.0f;
        }
        return f;
    }

    private SectionAssignValue createNewSectionAssignValue() {
        float f = 0.0f;
        float f2 = 0.0f;
        int n = 8;
        if (this.fileItem.type == 0 || this.fileItem.type == 8) {
            f = 1.0E-8f;
            f2 = 0.1f;
            n = 8;
        } else if (this.fileItem.type == 2 || this.fileItem.type == 12) {
            f = -0.02f;
            f2 = 0.02f;
            n = 9;
        } else if (this.fileItem.type == 10 || this.fileItem.type == 3) {
            f = -0.1f;
            f2 = 0.1f;
            n = 15;
        } else if (this.fileItem.type == 14) {
            f = -0.001f;
            f2 = 0.001f;
            n = 15;
        } else if (this.fileItem.type == 1 || this.fileItem.type == 9) {
            f = -0.02f;
            f2 = 0.02f;
            n = 9;
        }
        return new SectionAssignValue(new Point3f(this.fileItem.coordInfo.xcenter, this.fileItem.coordInfo.ycenter, this.fileItem.coordInfo.zcenter), new Point3f(), true, true, 0, f, f2, true, 0, n, this.createSectionAssignNode());
    }

    private float[] getMinMax() {
        float[] fArray = new float[6];
        if (this.fileItem.type == 8 || this.fileItem.type == 9 || this.fileItem.type == 10) {
            GaussianCubeFile gaussianCubeFile = (GaussianCubeFile)this.fileItem.file;
            fArray[0] = gaussianCubeFile.cubeXmin;
            fArray[1] = gaussianCubeFile.cubeYmin;
            fArray[2] = gaussianCubeFile.cubeZmin;
            fArray[3] = gaussianCubeFile.cubeXmax;
            fArray[4] = gaussianCubeFile.cubeYmax;
            fArray[5] = gaussianCubeFile.cubeZmax;
        } else if (this.fileItem.type == 0 || this.fileItem.type == 1 || this.fileItem.type == 2 || this.fileItem.type == 3 || this.fileItem.type == 12 || this.fileItem.type == 14) {
            GridFile gridFile = (GridFile)this.fileItem.file;
            fArray[0] = gridFile.xx[0];
            fArray[1] = gridFile.yy[0];
            fArray[2] = gridFile.zz[0];
            fArray[3] = gridFile.xx[gridFile.xx.length - 1];
            fArray[4] = gridFile.yy[gridFile.yy.length - 1];
            fArray[5] = gridFile.zz[gridFile.zz.length - 1];
        }
        return fArray;
    }

    class deleteListener
    extends AbstractAction {
        deleteListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = SectionAssignPanel.this.sectionNumComboBox.getItemCount();
            if (n > 0) {
                int n2 = SectionAssignPanel.this.sectionNumComboBox.getSelectedIndex();
                SectionAssignPanel.this.viewer.deleteSectionNode(SectionAssignPanel.this.fileItem, SectionAssignPanel.this.currentNo);
                SectionAssignPanel.this.assignValues.removeElementAt(n2);
                if (n - 1 == SectionAssignPanel.this.currentNo) {
                    SectionAssignPanel.this.currentNo--;
                }
                if (n > 1) {
                    SectionAssignPanel.this.setAssignToGui(SectionAssignPanel.this.currentNo);
                }
                SectionAssignPanel.this.sectionNumComboBox.removeItemAt(n - 1);
            }
        }
    }

    class updateListener
    extends AbstractAction {
        updateListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SectionAssignPanel.this.displaySectionPlane();
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            f = SectionAssignPanel.this.getFloatValue(SectionAssignPanel.this.xCenterText) - ((SectionAssignPanel)SectionAssignPanel.this).fileItem.coordInfo.xcenter;
            f2 = SectionAssignPanel.this.getFloatValue(SectionAssignPanel.this.yCenterText) - ((SectionAssignPanel)SectionAssignPanel.this).fileItem.coordInfo.ycenter;
            f3 = SectionAssignPanel.this.getFloatValue(SectionAssignPanel.this.zCenterText) - ((SectionAssignPanel)SectionAssignPanel.this).fileItem.coordInfo.zcenter;
            boolean bl = SectionAssignPanel.this.rotationRadioButton.isSelected();
            if (bl) {
                float f4 = 0.0f;
                float f5 = 0.0f;
                float f6 = 0.0f;
                f4 = SectionAssignPanel.this.getFloatValue(SectionAssignPanel.this.thetaLabel);
                f5 = SectionAssignPanel.this.getFloatValue(SectionAssignPanel.this.phaiLabel);
                f6 = SectionAssignPanel.this.getFloatValue(SectionAssignPanel.this.cLabel);
                SectionAssignPanel.this.getCurrentSectionAssignNode().translationRotation(f, f2, f3, f4, f5, f6);
            } else {
                float f7 = 0.0f;
                float f8 = 0.0f;
                float f9 = 0.0f;
                f7 = SectionAssignPanel.this.getFloatValue(SectionAssignPanel.this.xVectorText);
                f8 = SectionAssignPanel.this.getFloatValue(SectionAssignPanel.this.yVectorText);
                f9 = SectionAssignPanel.this.getFloatValue(SectionAssignPanel.this.zVectorText);
                SectionAssignPanel.this.getCurrentSectionAssignNode().translationVector(f, f2, f3, f7, f8, f9);
            }
        }
    }

    class resetListener
    extends AbstractAction {
        resetListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SectionAssignPanel.this.reset();
        }
    }

    class addListener
    extends AbstractAction {
        addListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = SectionAssignPanel.this.sectionNumComboBox.getSelectedIndex();
            if (SectionAssignPanel.this.currentNo >= 0) {
                SectionAssignPanel.this.setAssignToVector(n);
            }
            int n2 = SectionAssignPanel.this.sectionNumComboBox.getItemCount();
            SectionAssignValue sectionAssignValue = SectionAssignPanel.this.createNewSectionAssignValue();
            SectionAssignPanel.this.assignValues.add(sectionAssignValue);
            SectionAssignPanel.this.sectionNumComboBox.addItem(Integer.toString(n2 + 1));
            SectionAssignPanel.this.sectionNumComboBox.setSelectedIndex(n2);
            SectionAssignPanel.this.currentNo = n2;
            SectionAssignPanel.this.reset();
        }
    }

    class rotationVectorListener
    extends AbstractAction {
        boolean tf;

        public rotationVectorListener(boolean bl) {
            this.tf = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SectionAssignPanel.this.thetaSlider.setEnabled(this.tf);
            SectionAssignPanel.this.phaiSlider.setEnabled(this.tf);
            SectionAssignPanel.this.cSlider.setEnabled(this.tf);
            SectionAssignPanel.this.thetaLabel.setEnabled(this.tf);
            SectionAssignPanel.this.phaiLabel.setEnabled(this.tf);
            SectionAssignPanel.this.cLabel.setEnabled(this.tf);
            SectionAssignPanel.this.xVectorText.setEnabled(!this.tf);
            SectionAssignPanel.this.yVectorText.setEnabled(!this.tf);
            SectionAssignPanel.this.zVectorText.setEnabled(!this.tf);
        }
    }

    class fringeLineListener
    extends AbstractAction {
        boolean tf;

        public fringeLineListener(boolean bl) {
            this.tf = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SectionAssignPanel.this.lineNumText.setEnabled(this.tf);
            SectionAssignPanel.this.transparencyLabel.setEnabled(!this.tf);
            SectionAssignPanel.this.transparencySlider.setEnabled(!this.tf);
        }
    }

    private class transparencySliderListener
    implements ChangeListener {
        MyLabel tf;

        public transparencySliderListener(MyLabel myLabel) {
            this.tf = myLabel;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            this.tf.setText(Integer.toString(jSlider.getValue()));
        }
    }

    private class CenterSliderListener
    implements ChangeListener {
        JTextField tf;

        public CenterSliderListener(JTextField jTextField) {
            this.tf = jTextField;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (SectionAssignPanel.this.rotationRadioButton.isSelected()) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                SectionAssignPanel.this.displaySectionPlane();
                this.tf.setText(Float.toString((float)jSlider.getValue() / 10.0f));
                SectionAssignPanel.this.setCenterCoordinate();
            }
        }
    }

    private class SliderListener
    implements ChangeListener {
        MyLabel tf;
        int axis;

        public SliderListener(MyLabel myLabel, int n) {
            this.tf = myLabel;
            this.axis = n;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (SectionAssignPanel.this.rotationRadioButton.isSelected()) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                SectionAssignPanel.this.displaySectionPlane();
                float f = SectionAssignPanel.this.getFloatValue(this.tf);
                this.tf.setText(Integer.toString(jSlider.getValue()));
                f = (float)jSlider.getValue() - f;
                SectionAssignPanel.this.getCurrentSectionAssignNode().rotation(this.axis, f);
            }
        }
    }

    class returnVectorListener
    extends AbstractAction {
        returnVectorListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SectionAssignPanel.this.displaySectionPlane();
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            CoordInfo coordInfo = SectionAssignPanel.this.viewer.getCoordInfo();
            f = SectionAssignPanel.this.getFloatValue(SectionAssignPanel.this.xCenterText) - coordInfo.xcenter;
            f2 = SectionAssignPanel.this.getFloatValue(SectionAssignPanel.this.yCenterText) - coordInfo.ycenter;
            f3 = SectionAssignPanel.this.getFloatValue(SectionAssignPanel.this.zCenterText) - coordInfo.zcenter;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            f4 = SectionAssignPanel.this.getFloatValue(SectionAssignPanel.this.xVectorText);
            f5 = SectionAssignPanel.this.getFloatValue(SectionAssignPanel.this.yVectorText);
            f6 = SectionAssignPanel.this.getFloatValue(SectionAssignPanel.this.zVectorText);
            SectionAssignPanel.this.getCurrentSectionAssignNode().translationVector(f, f2, f3, f4, f5, f6);
        }
    }

    class returnCenterListener
    extends AbstractAction {
        returnCenterListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SectionAssignPanel.this.displaySectionPlane();
            SectionAssignPanel.this.setCenterCoordinate();
        }
    }

    private class drawListener
    implements ActionListener {
        private drawListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = SectionAssignPanel.this.sectionNumComboBox.getSelectedIndex();
            if (n != -1) {
                SectionAssignPanel.this.setAssignToVector(n);
            }
            SectionAssignPanel.this.createSectionNode(null);
        }
    }
}

