/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Viewer;

import AbinitMp.AbinitMpFile.TrajectoryFile;
import AbinitMp.Common.BaseDialog;
import AbinitMp.Common.MOL2File;
import AbinitMp.Tool.MyButton;
import AbinitMp.Tool.MyCheckBox;
import AbinitMp.Tool.MyLabel;
import AbinitMp.Tool.MyPanel;
import AbinitMp.Viewer.AbinitMpViewer;
import AbinitMp.Viewer.FileItem;
import AbinitMp.Viewer.MoGraphWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.vecmath.Color3f;

public class FileListPanel
extends MyPanel {
    public Object file;
    public String filename;
    public int type;
    public FileItem[] fileItems;
    public MyCheckBox[] checkBoxes;
    public Color3f[] color;
    private AbinitMpViewer viewer;
    private BaseDialog dialog;

    public FileListPanel(AbinitMpViewer abinitMpViewer, Vector vector) {
        this.viewer = abinitMpViewer;
        this.setLayout(new BorderLayout());
        MyPanel myPanel = new MyPanel(new GridLayout(0, 1));
        JScrollPane jScrollPane = new JScrollPane(myPanel, 22, 31);
        this.add((Component)jScrollPane, "Center");
        MyPanel[] myPanelArray = new MyPanel[vector.size()];
        this.fileItems = new FileItem[vector.size()];
        this.checkBoxes = new MyCheckBox[vector.size()];
        this.color = new Color3f[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            JComponent jComponent;
            FileItem fileItem;
            this.fileItems[i] = fileItem = (FileItem)vector.get(i);
            myPanelArray[i] = new MyPanel();
            String string = fileItem.filename;
            if (fileItem.type == 6 && ((MOL2File)fileItem.file).gridFile == 1) {
                string = string.concat(" (grid file)");
            }
            this.checkBoxes[i] = new MyCheckBox(string);
            this.checkBoxes[i].setPreferredSize(new Dimension(250, 28));
            this.checkBoxes[i].setSelected(fileItem.visible);
            myPanelArray[i].add(this.checkBoxes[i]);
            if (fileItem.type == 0 || fileItem.type == 1 || fileItem.type == 3 || fileItem.type == 2 || fileItem.type == 12 || fileItem.type == 8 || fileItem.type == 9 || fileItem.type == 10 || fileItem.type == 13 || fileItem.type == 14) {
                jComponent = new MyButton("Value");
                ((AbstractButton)jComponent).setActionCommand(Integer.toString(i));
                jComponent.setPreferredSize(new Dimension(70, 28));
                ((AbstractButton)jComponent).addActionListener(new valueListener());
                myPanelArray[i].add(jComponent);
            } else {
                jComponent = new MyLabel();
                jComponent.setPreferredSize(new Dimension(70, 28));
                myPanelArray[i].add(jComponent);
            }
            myPanel.add(myPanelArray[i]);
        }
    }

    public FileItem[] getValue() {
        for (int i = 0; i < this.checkBoxes.length; ++i) {
            this.fileItems[i].visible = this.checkBoxes[i].isSelected();
        }
        return this.fileItems;
    }

    public void setDialog(BaseDialog baseDialog) {
        this.dialog = baseDialog;
    }

    private class valueListener
    implements ActionListener {
        private valueListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MyButton myButton = (MyButton)actionEvent.getSource();
            String string = myButton.getActionCommand();
            int n = Integer.parseInt(string);
            if (FileListPanel.this.fileItems[n].type == 3 || FileListPanel.this.fileItems[n].type == 10) {
                FileListPanel.this.dialog.setVisible(false);
                MoGraphWindow moGraphWindow = new MoGraphWindow(FileListPanel.this.viewer, FileListPanel.this.fileItems[n]);
                FileListPanel.this.viewer.setMoGraphWindow(moGraphWindow);
                moGraphWindow.setVisible(true);
            } else if (FileListPanel.this.fileItems[n].type == 12) {
                FileListPanel.this.fileItems[n].electricFieldAssignWindow.setVisible(true);
            } else if (FileListPanel.this.fileItems[n].type == 13) {
                ((TrajectoryFile)FileListPanel.this.fileItems[n].file).getTrajectoryControlWindow().setVisible(true);
            } else {
                FileListPanel.this.fileItems[n].isosurfaceValueWindow.setVisible(true);
            }
        }
    }
}

