/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Common;

import AbinitMp.Common.PdbFile;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class MDLFile {
    public String filename = null;
    public int numberOfAtom;
    public int numberOfConnect;
    public float[] x;
    public float[] y;
    public float[] z;
    public String[] atomName;
    public int[][] connect;
    public PdbFile pdbFile;

    public MDLFile(String string) {
        this.readFile(string);
        if (this.filename != null) {
            this.pdbFile = new PdbFile(this);
        }
    }

    public void readFile(String string) {
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            bufferedReader.readLine();
            bufferedReader.readLine();
            bufferedReader.readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(bufferedReader.readLine());
            this.numberOfAtom = Integer.parseInt(stringTokenizer.nextToken());
            this.numberOfConnect = Integer.parseInt(stringTokenizer.nextToken());
            this.x = new float[this.numberOfAtom];
            this.y = new float[this.numberOfAtom];
            this.z = new float[this.numberOfAtom];
            this.atomName = new String[this.numberOfAtom];
            this.connect = new int[2][this.numberOfConnect];
            for (n = 0; n < this.numberOfAtom; ++n) {
                stringTokenizer = new StringTokenizer(bufferedReader.readLine());
                this.x[n] = Float.parseFloat(stringTokenizer.nextToken());
                this.y[n] = Float.parseFloat(stringTokenizer.nextToken());
                this.z[n] = Float.parseFloat(stringTokenizer.nextToken());
                this.atomName[n] = new String(stringTokenizer.nextToken());
            }
            for (n = 0; n < this.numberOfConnect; ++n) {
                stringTokenizer = new StringTokenizer(bufferedReader.readLine());
                this.connect[0][n] = Integer.parseInt(stringTokenizer.nextToken());
                this.connect[1][n] = Integer.parseInt(stringTokenizer.nextToken());
            }
            this.filename = string;
            bufferedReader.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(new JFrame(), "MDL File read error (" + string + ").\n" + exception.getMessage(), "Error message", 0);
        }
    }

    public void debugPrint(PrintStream printStream) {
        printStream.println("Mdl File (" + this.filename + ")");
        printStream.println("Number of atom " + this.numberOfAtom);
        for (int i = 0; i < this.numberOfAtom; ++i) {
            printStream.println(this.x[i] + " " + this.y[i] + " " + this.z[i] + " " + this.atomName[i]);
        }
        this.pdbFile.debugPrint(printStream);
    }

    public static void main(String[] stringArray) {
        MDLFile mDLFile = new MDLFile(stringArray[0]);
        mDLFile.debugPrint(System.out);
    }
}

