/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Common;

import AbinitMp.Common.AtomData;
import AbinitMp.Common.ResidueData;
import AbinitMp.Common.SsData;
import java.io.PrintStream;
import java.util.Vector;

public class ChainData {
    public String id = null;
    public Vector atomTable;
    public Vector hemTable;
    public Vector residueTable;
    public Vector hemResidueTable;
    public Vector ssTable;
    public Vector[] atomConnect;
    public Vector[] boneConnect;
    public Vector[] caConnect;
    public Vector caAtoms;
    public Vector dnaC3Atoms;
    public Vector[] dnaC3Connect;
    public Vector dnaNAtoms;
    public float[] caSplineCoord;
    public float[] dnaC3SplineCoord;
    public Vector[] hemConnect;
    public Vector hBondsPeptideConnect;
    public Vector hBondsHemConnect;

    public ChainData() {
        this.initTable();
    }

    private void initTable() {
        this.id = null;
        this.atomTable = new Vector();
        this.hemTable = new Vector();
        this.residueTable = new Vector();
        this.hemResidueTable = new Vector();
        this.ssTable = new Vector();
    }

    public int getStartResidueNo() {
        int n = this.residueTable != null ? ((ResidueData)this.residueTable.get((int)0)).no : -1;
        return n;
    }

    public int getStartHemResidueNo() {
        int n = this.hemResidueTable != null ? ((ResidueData)this.hemResidueTable.get((int)0)).no : -1;
        return n;
    }

    public int getEndResidueNo() {
        int n = this.residueTable != null ? ((ResidueData)this.residueTable.get((int)(this.residueTable.size() - 1))).no : -1;
        return n;
    }

    public int getEndHemResidueNo() {
        int n = this.hemResidueTable != null ? ((ResidueData)this.hemResidueTable.get((int)(this.hemResidueTable.size() - 1))).no : -1;
        return n;
    }

    public ResidueData isElement(ResidueData residueData) {
        ResidueData residueData2;
        int n;
        int n2;
        if (this.residueTable.size() > 0) {
            n2 = ((ResidueData)this.residueTable.get((int)0)).no;
            n = ((ResidueData)this.residueTable.get((int)(this.residueTable.size() - 1))).no;
            if (n2 <= residueData.no && residueData.no <= n && (residueData2 = (ResidueData)this.residueTable.get(residueData.no - n2)).equals(residueData)) {
                return residueData;
            }
        }
        if (this.hemResidueTable.size() > 0) {
            n2 = ((ResidueData)this.hemResidueTable.get((int)0)).no;
            n = ((ResidueData)this.hemResidueTable.get((int)(this.hemResidueTable.size() - 1))).no;
            if (n2 <= residueData.no && residueData.no <= n && (residueData2 = (ResidueData)this.hemResidueTable.get(residueData.no - n2)).equals(residueData)) {
                return residueData;
            }
        }
        return null;
    }

    public String toString() {
        return this.id;
    }

    public void debugPrint(PrintStream printStream) {
        int n;
        printStream.println("ID " + this.id);
        printStream.println("atomTable ");
        for (n = 0; n < this.atomTable.size(); ++n) {
            printStream.print(n + " ");
            ((AtomData)this.atomTable.get(n)).debugPrint(printStream);
        }
        printStream.println("hemTable ");
        for (n = 0; n < this.hemTable.size(); ++n) {
            printStream.print(n + " ");
            ((AtomData)this.hemTable.get(n)).debugPrint(printStream);
        }
        printStream.println("residueTable ");
        for (n = 0; n < this.residueTable.size(); ++n) {
            printStream.print(n + " ");
            ((ResidueData)this.residueTable.get(n)).debugPrint(printStream);
        }
        printStream.println("hemResidueTable ");
        for (n = 0; n < this.hemResidueTable.size(); ++n) {
            printStream.print(n + " ");
            ((ResidueData)this.hemResidueTable.get(n)).debugPrint(printStream);
        }
        printStream.println("ssTable ");
        for (n = 0; n < this.ssTable.size(); ++n) {
            printStream.print(n + " ");
            ((SsData)this.ssTable.get(n)).debugPrint(printStream);
        }
    }
}

