/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.xml;

import hep.aida.IAnalysisFactory;
import hep.aida.IBaseStyle;
import hep.aida.IPlotterStyle;
import hep.aida.ref.plotter.BaseStyle;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.freehep.xml.util.XMLWriter;

public class AidaStyleXMLWriter
extends XMLWriter {
    static /* synthetic */ Class class$java$lang$String;

    public static void writeStyleToDisk(String fileName, IPlotterStyle style) throws IOException {
        AidaStyleXMLWriter.writeStyleToDisk(fileName, style, false);
    }

    public static void writeStyleToDisk(String fileName, IPlotterStyle style, boolean writeAllParameters) throws IOException {
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        AidaStyleXMLWriter xmlWriter = new AidaStyleXMLWriter(writer);
        xmlWriter.plotterStyleToXML(style, writeAllParameters);
        xmlWriter.close();
    }

    public AidaStyleXMLWriter(Writer writer) throws IOException {
        super(writer);
        this.openDoc("1.0", "ISO-8859-1", false);
        this.referToDTD("aidaPlotterStyle", "http://java.freehep.org/schemas/jaida/1.0/aidaPlotterStyle.dtd");
    }

    public void close() throws IOException {
        super.close();
    }

    public void plotterStyleToXML(IPlotterStyle style) {
        this.plotterStyleToXML(style, false);
    }

    public void plotterStyleToXML(IPlotterStyle style, boolean writeAllParameters) {
        if (this.isStyleEmpty((IBaseStyle)style, writeAllParameters)) {
            return;
        }
        this.openTag("aidaPlotterStyle");
        IBaseStyle[] children = style.children();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                this.toXML(children[i], writeAllParameters);
            }
        }
        this.parametersToXML((IBaseStyle)style, writeAllParameters);
        this.closeTag();
    }

    void toXML(IBaseStyle style) {
        this.toXML(style, false);
    }

    void toXML(IBaseStyle style, boolean writeAllParameters) {
        if (this.isStyleEmpty(style, writeAllParameters)) {
            return;
        }
        this.setAttribute("type", style.name());
        this.openTag("aidaStyle");
        IBaseStyle[] children = style.children();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                this.toXML(children[i], writeAllParameters);
            }
        }
        this.parametersToXML(style, writeAllParameters);
        this.closeTag();
    }

    void parametersToXML(IBaseStyle style, boolean writeAllParameters) {
        String[] parNames = style.availableParameters();
        if (parNames != null) {
            for (int i = 0; i < parNames.length; ++i) {
                String name = parNames[i];
                String value = style.parameterValue(name);
                if (value == null) {
                    value = "null";
                }
                boolean isSet = true;
                String type = (class$java$lang$String == null ? AidaStyleXMLWriter.class$("java.lang.String") : class$java$lang$String).getName();
                if (style instanceof BaseStyle) {
                    isSet = ((BaseStyle)style).isParameterSet(name);
                    type = ((BaseStyle)style).parameter(name).type().getName();
                }
                if (!isSet && !writeAllParameters) continue;
                this.setAttribute("attributeName", name);
                this.setAttribute("attributeValue", value);
                this.printTag("aidaStyleAttribute");
            }
        }
    }

    boolean isStyleEmpty(IBaseStyle style) {
        return this.isStyleEmpty(style, false);
    }

    boolean isStyleEmpty(IBaseStyle style, boolean writeAllParameters) {
        IBaseStyle[] children;
        boolean isEmpty = true;
        String[] parNames = style.availableParameters();
        if (parNames != null) {
            for (int i = 0; i < parNames.length; ++i) {
                String name = parNames[i];
                boolean isSet = true;
                if (style instanceof BaseStyle) {
                    isSet = ((BaseStyle)style).isParameterSet(name);
                }
                if (!isSet && !writeAllParameters) continue;
                return false;
            }
        }
        if ((children = style.children()) != null) {
            for (int i = 0; i < children.length; ++i) {
                if (this.isStyleEmpty(children[i])) continue;
                return false;
            }
        }
        return isEmpty;
    }

    public void printStyle(IBaseStyle style) {
        AidaStyleXMLWriter.printStyle(style, false);
    }

    public static void printStyle(IBaseStyle style, boolean writeAllParameters) {
        String[] parNames;
        System.out.println("<" + style.name() + " type=" + style.type().getName() + " >");
        IBaseStyle[] children = style.children();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                AidaStyleXMLWriter.printStyle(children[i], writeAllParameters);
            }
        }
        if ((parNames = style.availableParameters()) != null) {
            for (int i = 0; i < parNames.length; ++i) {
                String name = parNames[i];
                String value = style.parameterValue(name);
                boolean isSet = true;
                if (style instanceof BaseStyle) {
                    isSet = ((BaseStyle)style).isParameterSet(name);
                }
                if (!isSet && !writeAllParameters) continue;
                System.out.println("\t\t<parameter name=" + name + " value=" + value + " />");
            }
        }
        System.out.println("</" + style.name() + ">");
    }

    public static void main(String[] args) throws IOException {
        String fileName = "C:/work/Projects/Tests/PlotterStyle.xml";
        boolean writeAllParameters = true;
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        AidaStyleXMLWriter xmlWriter = new AidaStyleXMLWriter(writer);
        IPlotterStyle style = IAnalysisFactory.create().createPlotterFactory().createPlotterStyle();
        style.xAxisStyle().setLabel("xxxxxAxisLabel");
        style.dataStyle().markerStyle().setShape("box");
        style.yAxisStyle().setLabel("yyyyyAxisLabel");
        AidaStyleXMLWriter.printStyle((IBaseStyle)style.xAxisStyle(), true);
        xmlWriter.plotterStyleToXML(style, writeAllParameters);
        xmlWriter.close();
    }
}

