/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.adapter;

import hep.aida.IHistogram;
import hep.aida.IHistogram1D;
import hep.aida.ref.plotter.adapter.AIDAHistogramAdapter;
import hep.aida.ref.plotter.adapter.AIDAHistogramStatistics1D;
import jas.hist.HasStatistics;
import jas.hist.Rebinnable1DHistogramData;
import jas.hist.Statistics;

public class AIDAHistogramAdapter1D
extends AIDAHistogramAdapter
implements Rebinnable1DHistogramData,
HasStatistics {
    private IHistogram1D h1d;

    AIDAHistogramAdapter1D(IHistogram1D histo) {
        super((IHistogram)histo);
        this.h1d = histo;
        String tmp = null;
        try {
            tmp = histo.annotation().value("xAxisType");
            if (tmp != null && tmp.equalsIgnoreCase("date")) {
                this.xAxisType = 3;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public double[][] rebin(int bins, double min, double max, boolean wantErrors, boolean hurry) {
        double[][] data = new double[2][this.h1d.axis().bins()];
        for (int i = 0; i < this.h1d.axis().bins(); ++i) {
            data[0][i] = this.h1d.binHeight(i);
            if (Double.isInfinite(data[0][i])) {
                data[0][i] = Double.NaN;
            }
            data[1][i] = this.h1d.binError(i);
        }
        this.setValid();
        return data;
    }

    public double getMin() {
        return this.h1d.axis().lowerEdge();
    }

    public double getMax() {
        return this.h1d.axis().upperEdge();
    }

    public int getBins() {
        return this.h1d.axis().bins();
    }

    public boolean isRebinnable() {
        return false;
    }

    public int getAxisType() {
        return this.xAxisType;
    }

    public void setAxisType(int type) {
        this.xAxisType = type;
    }

    public String[] getAxisLabels() {
        return null;
    }

    public String getTitle() {
        return this.h1d.title();
    }

    public Statistics getStatistics() {
        return new AIDAHistogramStatistics1D(this.h1d);
    }
}

