/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.cgm;

import java.awt.Component;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.cgm.CGMGraphics2D;
import org.freehep.graphicsio.exportchooser.AbstractExportFileType;
import org.freehep.graphicsio.exportchooser.BackgroundPanel;
import org.freehep.graphicsio.exportchooser.InfoPanel;
import org.freehep.graphicsio.exportchooser.OptionCheckBox;
import org.freehep.graphicsio.exportchooser.OptionPanel;
import org.freehep.util.UserProperties;

public class CGMExportFileType
extends AbstractExportFileType {
    public String getDescription() {
        return "Computer Graphics Metafile";
    }

    public String[] getExtensions() {
        return new String[]{"cgm"};
    }

    public String[] getMIMETypes() {
        return new String[]{"image/cgm"};
    }

    public boolean hasOptionPanel() {
        return true;
    }

    public JPanel createOptionPanel(Properties user) {
        UserProperties options = new UserProperties(user, CGMGraphics2D.getDefaultProperties());
        OptionPanel formatPanel = new OptionPanel("Format");
        formatPanel.add("0 * * 1 [5 15 5 15] w", (Component)new OptionCheckBox((Properties)options, CGMGraphics2D.BINARY, "Binary"));
        String rootKey = CGMGraphics2D.class.getName();
        InfoPanel infoPanel = new InfoPanel((Properties)options, rootKey, new String[]{"Author", "Title", "Subject", "Keywords"});
        OptionPanel leftPanel = new OptionPanel();
        leftPanel.add("0 * wt", (Component)formatPanel);
        leftPanel.add("0 * wh", new JLabel());
        OptionPanel rightPanel = new OptionPanel();
        rightPanel.add("0 * wt", (Component)new BackgroundPanel((Properties)options, rootKey, false));
        rightPanel.add("0 * wh", new JLabel());
        OptionPanel optionsPanel = new OptionPanel();
        optionsPanel.add("0 0 [5 5 5 5] wt", (Component)leftPanel);
        optionsPanel.add("1 0 [5 5 5 5] wt", (Component)rightPanel);
        optionsPanel.add("0 1 2 1 [5 5 5 5] wt", (Component)infoPanel);
        optionsPanel.add("0 * wh", (Component)new JLabel());
        return optionsPanel;
    }

    public VectorGraphics getGraphics(OutputStream os, Component target) throws IOException {
        return new CGMGraphics2D(os, target);
    }
}

