/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : InternalFileChooser.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.common;

import java.awt.Dimension;
import java.util.Vector;

import javax.swing.JFileChooser;

import ciss.phase_viewer.mainpanel.InternalFrameChase;

public class InternalFileChooser extends JFileChooser {
    private int cond = -9999999;

    private InternalFrameFileChooser iffc;

    private Vector listeners = new Vector();

    public InternalFileChooser() {
        super();
    }

    public void showFileChooser(String btntext) {
        this.setApproveButtonText(btntext);
        iffc = new InternalFrameFileChooser(getDialogTitle());
        iffc.add(this);
    }

    /**
     * 
     * @uml.property name="cond"
     */
    public int getCond() {
        return cond;
    }

    public void addFileChooserListener(FileChooserListener listener) {
        listeners.add(listener);
    }

    public void approveSelection() {
        cond = JFileChooser.APPROVE_OPTION;
        for (int i = 0; i < listeners.size(); i++) {
            ((FileChooserListener) listeners.elementAt(i))
                    .approvedSelection(this);
        }
        iffc.dispose();
    }

    public void cancelSelection() {
        cond = JFileChooser.CANCEL_OPTION;
        iffc.dispose();
    }

}

class InternalFrameFileChooser extends InternalFrameChase {
    protected InternalFrameFileChooser(String title) {
        super(title, true, true, true, true, new Dimension(500, 350));
    }
}

/*
 * class Wait implements Runnable { private InternalFileChooser parent;
 * 
 * protected Wait(InternalFileChooser parent) { this.parent = parent; }
 * 
 * public void run() { while ( parent.getCond() != JFileChooser.APPROVE_OPTION
 * && parent.getCond() != JFileChooser.CANCEL_OPTION ){} }
 * 
 * }
 */
