/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/01/23, 17:19
!  AUTHOR(S): KOGA, Junichiro
!  File : ImporterGUIPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.atomcoord.io;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

import ciss.phase_viewer.common.ChaseFileChooser;
import ciss.phase_viewer.main.PluginLoader;

/**
 * C|[gpGUI̓̃pl. light-weightȃR|[lgheavy-weightȃR|[lg̃plł͗p.
 * 
 * @author
 */
class ImporterGUIPanel extends JPanel {
    private Logger logger = Logger.getLogger(ImporterGUIPanel.class.getName());
    private Importable caller;
    private Importer[] importers;
    private JInternalFrame frame;
    private JFrame jframe;

    /**
     * light-weightR|[lg痘pꍇ͂̃RXgN^[𗘗p.
     * 
     * @param caller
     *            C|[gȊ`NX
     * @param frame
     *            eR|[lg
     */
    ImporterGUIPanel(Importable caller, JInternalFrame frame) {
        this.caller = caller;
        this.frame = frame;
        init();
    }

    /**
     * heavy-weightR|[lg痘pꍇ͂̃RXgN^[𗘗p.
     * 
     * @param caller
     *            C|[gȊ`NX
     * @param frame
     *            eR|[lg
     */
    ImporterGUIPanel(Importable caller, JFrame jframe) {
        this.caller = caller;
        this.jframe = jframe;
        init();
    }

    private JComboBox comboType;
    private JTextField pathTF;
    private JButton bootChooser;
    private JButton btnopt;

    private void init() {
        createImporters();
        String[] types = new String[importers.length];
        for (int i = 0; i < importers.length; i++) {
            types[i] = importers[i].getType();
        }
        comboType = new JComboBox(types);
        pathTF = new JTextField(20);
        bootChooser = new JButton("choose...");

        JPanel panel1 = new JPanel();

        JPanel pcomboType = new JPanel();
        pcomboType.setBorder(new TitledBorder("file type"));
        pcomboType.add(comboType);
        JPanel pchooser = new JPanel();
        btnopt = new JButton("options");

        pchooser.setLayout(new BoxLayout(pchooser, BoxLayout.X_AXIS));
        pchooser.add(pathTF);
        pchooser.add(bootChooser);
        pchooser.add(btnopt);

        panel1.add(pcomboType);
        panel1.add(pchooser);

        JPanel pbtns = new JPanel();
        pbtns.setLayout(new BoxLayout(pbtns, BoxLayout.X_AXIS));
        JButton importbtn = new JButton("import selected");
        JButton btncancel = new JButton("cancel");
        pbtns.add(importbtn);
        pbtns.add(btncancel);

        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
        panel.add(panel1);
        panel.add(pbtns);

        comboType.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if (importers[comboType.getSelectedIndex()].hasOptions()) {
                    btnopt.setEnabled(true);
                } else {
                    btnopt.setEnabled(false);
                }
            }
        });

        bootChooser.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                chooser();
            }
        });

        importbtn.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                String file = pathTF.getText();
                if (file == null || file.length() == 0
                        || !new java.io.File(file).exists()) {
                    logger.error("the file you've specified does not exist.");
                    return;
                }
                caller.coordsImported(importers[comboType.getSelectedIndex()]
                        .getAtomCoordsFrom(file), comboType.getSelectedItem()
                        .toString(), file);
                // new Thread(new doImport()).start();
                if (frame != null) {
                    frame.dispose();
                } else if (jframe != null) {
                    jframe.dispose();
                }
            }
        });

        btnopt.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                boolean isHeavy = true;
                if (frame != null) {
                    isHeavy = false;
                }
                importers[comboType.getSelectedIndex()].createOptionsPanel(
                        isHeavy, null, "");
            }
        });

        btncancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if (frame != null) {
                    frame.dispose();
                } else if (jframe != null) {
                    jframe.dispose();
                }
            }
        });

        add(panel);
        comboType.setSelectedIndex(0);
    }

    /**
     * importƂ͕ʃXbhōs. ̂߂RunnableC^[tF[XNX
     */
    class doImport implements Runnable {
        public void run() {
            String file = pathTF.getText();
            if (file == null || file.length() == 0
                    || !new java.io.File(file).exists()) {
                logger.error("the file you've specified does not exist.");
                return;
            }
            caller.coordsImported(importers[comboType.getSelectedIndex()]
                    .getAtomCoordsFrom(file), comboType.getSelectedItem()
                    .toString(), file);
        }
    }

    private void createImporters() {
        Document doc = ciss.phase_viewer.jdom.XMLUtils
                .getDocumentFromURL(AtomCoordsIO.SUPPORTED_FILETYPE);
        Element root = doc.getRootElement();
        java.util.List list = root.getChildren("importer");
        Vector vec = new Vector();
        for (int i = 0; i < list.size(); i++) {
            String loadClass = ((Element) list.get(i))
                    .getChildTextTrim("loadclass");
            vec.addElement(loadClass);
        }
        importers = new Importer[vec.size()];
        for (int i = 0; i < vec.size(); i++) {
            String load = (String) vec.get(i);
            importers[i] = (Importer) PluginLoader.instantiate(load, null);
        }
    }

    private void chooser() {
        ChaseFileChooser fdlg = new ChaseFileChooser(ChaseFileChooser.atom,
                true);

        fdlg.setDialogType(JFileChooser.CUSTOM_DIALOG);
        fdlg.setDialogTitle("select atomic configuration file");
        fdlg.setFileSelectionMode(JFileChooser.FILES_ONLY);
        javax.swing.filechooser.FileFilter filter = importers[comboType
                .getSelectedIndex()].getFileFilter();
        if (filter != null) {
            fdlg.addChoosableFileFilter(filter);
        }

        if (fdlg.showOpenDialog(this) != JFileChooser.APPROVE_OPTION) {
            return;
        }
        pathTF.setText(fdlg.getSelectedFile().getAbsolutePath());
    }

}
