/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : MyProgressMonitor.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.ssh.sftp;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;

import ciss.phase_viewer.mainpanel.ChaseProgressMonitor;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.mainpanel.ProgressInfo;
import ciss.phase_viewer.settings.PropertiesManager;

import com.jcraft.jsch.SftpProgressMonitor;

public class MyProgressMonitor extends InternalFrameChase implements
        SftpProgressMonitor, ActionListener, ProgressInfo {
    private static org.apache.log4j.Logger logger = org.apache.log4j.Logger
            .getLogger(MyProgressMonitor.class.getName());
    private JProgressBar progress;
    private long count = 0;
    private long max = 0;
    private JPanel p;
    private boolean isCanceled = false;
    private TitledBorder title = new TitledBorder("transfering file ...");

    private String src;

    private Timer timer;
    private int time = 1000;
    private String name;

    public MyProgressMonitor(String name) {
        super("progress", true, true, true, true, new Dimension(500, 110),
                false);
        this.name = name;
        String time_ = PropertiesManager.getGlobalProperties(
                PropertiesManager.PROPERTIES_PVIEWER).getProperty(
                "sftp_progmon_delay");
        if (time_ != null) {
            try {
                time = Integer.parseInt(time_);
            } catch (NumberFormatException nfe) {
                time = 1000;
            }
        }
        ChaseProgressMonitor monitor = ChaseProgressMonitor.getMonitor();
        monitor.setProgress(this);
    }

    public void init(int op, String src, String dest, long max) {
        timer = new Timer(time, this);
        timer.start();

        this.max = max;
        this.src = src;

        String mode = "getting file: ";
        if (op == SftpProgressMonitor.PUT) {
            mode = "putting file: ";
        }
        mode = mode + src;
        setTitle(mode);

        progress = new JProgressBar(0, (int) max);
        progress.setValue(0);
        progress.setStringPainted(true);

        JButton cancel = new JButton("cancel");
        cancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                isCanceled = true;
            }
        });

        p = new JPanel();
        p.setLayout(new BoxLayout(p, BoxLayout.Y_AXIS));
        progress.setBorder(title);
        p.add(progress);
        JPanel pbtn = new JPanel();
        pbtn.add(cancel);
        p.add(pbtn);

        getContentPane().add(p);
        count = 0;
    }

    public void actionPerformed(ActionEvent e) {
        logger.debug("long transfer");
        this.setVisible(true);
        timer.stop();
    }

    public boolean count(long count) {
        this.count += count;
        progress.setValue((int) this.count);
        title.setTitle("Completed " + this.count + " out of " + max + ".");
        if (count == max || isCanceled) {
            isDone = true;
        }
        return !isCanceled;
    }

    public void end() {
        isDone = true;
        dispose();
    }

    private boolean isDone = false;

    public boolean isDone() {
        return isDone;
    }

    public int getLength() {
        return (int) this.max;
    }

    public String getCurrentMessage() {
        return null;
    }

    public int getCurrent() {
        return (int) this.count;
    }

    public String getNameOfProgress() {
        return this.name;
    }

    public void done() {
    }

}
