/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2007/03/27 19:35:07
!  AUTHOR(S): KOGA, Junichiro
!  File : PerlScriptOption.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.primitiveguis.perlscriptexecuters;

import javax.swing.JComponent;

import org.apache.log4j.Logger;

/**
 * PerlXNvg̃IvVJvZ
 * 
 * @author jkoga
 * 
 */
public abstract class PerlScriptOption {
    private Logger logger = Logger.getLogger(PerlScriptOption.class.getName());

    public static String OPTION = "OPTION";

    protected String[] choices = null;

    protected String optionName;

    public PerlScriptOption(String optionName) {
        this.optionName = optionName;
    }

    public PerlScriptOption(String optionName, String[] choices) {
        this.optionName = optionName;
        this.choices = choices;
    }

    public String getOptionName() {
        return this.optionName;
    }

    public String[] getChoices() {
        return this.choices;
    }

    public abstract String getOptionType();

    public abstract String generateOptions();

    public abstract JComponent[] getAssociatedGUI();

    protected Object value;

    public void setValue(Object value) {
        this.value = value;
    }

}
