/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/08/17, 11:43
!  AUTHOR(S): KOGA, Junichiro
!  File : AddButton.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.primitiveguis;

import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Vector;

import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

import ciss.phase_viewer.common.Command;
import ciss.phase_viewer.common.Utils;

/**
 * 
 * @author KOGA, Junichiro
 */
public class AddButton extends JButton implements Command {
    private PhaseInputPanelInterface[] guis;
    private JTable table;

    public AddButton(JTable table, PhaseInputPanelInterface[] guis,
            EventListener el) {
        super("add");
        this.table = table;
        this.guis = guis;
        addActionListener((ActionListener) el);
    }

    public void execute(EventObject e) {
        Vector regvec = new Vector();
        Utils.stop(table);
        for (int i = 0; i < guis.length; i++) {
            if (guis[i] == null) {
                regvec.addElement("");
                continue;
            }
            String val = guis[i].getValue();
            if (val == null || val.trim().length() == 0) {
                val = "*";
            }
            regvec.addElement(val);
        }
        ((DefaultTableModel) table.getModel()).addRow(regvec);
        table.revalidate();
    }

}
