/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/09/21, 18:57
!  AUTHOR(S): KOGA, Junichiro
!  File : ProjectionPolicyToggler.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.viewer.view;

import javax.media.j3d.View;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.ACVAction;
import ciss.phase_viewer.acviewer.BaseJ3DPanel;

/**
 * e@gO
 * 
 * @author
 */
public class ProjectionPolicyToggler extends ACVAction {
    private Logger logger = Logger.getLogger(ProjectionPolicyToggler.class
            .getName());

    /** Creates a new instance of ProjectionPolicyToggler */
    public ProjectionPolicyToggler(BaseJ3DPanel panel) {
        super(panel);
    }

    public void actionPerformed(java.awt.event.ActionEvent e) {
        int proj = parent.getProjectionPolicy();
        if (proj == View.PARALLEL_PROJECTION) {
            parent.setProjectionPolicy(View.PERSPECTIVE_PROJECTION);
        } else if (proj == View.PERSPECTIVE_PROJECTION) {
            parent.setProjectionPolicy(View.PARALLEL_PROJECTION);
        }
    }

}
