/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/11/09, 13:21
!  AUTHOR(S): KOGA, Junichiro
!  File : NfEnfParser.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel.parsers;

import java.io.IOException;
import java.util.Vector;

import org.apache.log4j.Logger;

import ciss.phase_viewer.outputinterface.OutputData;
import ciss.phase_viewer.outputinterface.OutputParser;

/**
 * F_ENFt@Cparse.
 * 
 * @author
 */
public class NfEnfParser extends OutputParser {
    private Logger logger = Logger.getLogger(NfEnfParser.class.getName());
    private final String START = "iter_ion";
    private String[] idents;
    private Vector dataVector = new Vector();

    /** Creates a new instance of NfEnfParser */
    public NfEnfParser(String fileName) {
        super(fileName);
    }

    protected boolean parse() {
        String line = "";
        if (readers != null) {
            for (int i = 0; i < readers.length; i++) {
                dataVector = new Vector();
                try {
                    logger.debug("at file:" + fileNames.get(i).toString());
                    while ((line = readers[i].readLine()) != null) {
                        logger.debug(line);
                        parseLine(line.trim());
                    }
                } catch (IOException e) {
                }
                try {
                    readers[i].close();
                } catch (IOException io) {
                }
                String[][] d2d = new String[dataVector.size()][idents.length];
                try {
                    dataVector.copyInto(d2d);
                } catch (ArrayIndexOutOfBoundsException aiob) {
                    logger.error("corrupted F_ENF file: "
                            + fileNames.get(i).toString());
                    return false;
                }
                String[] id = fileNames.get(i).toString().split("\\.");
                if (id[id.length - 1].trim().equals("converged")) {
                    idents = new String[] { "reac_coord", "iter_ion",
                            "hartree", "eV", "kcal/mol", "kJ/mol" };
                }
                OutputData outputData = new OutputData(id[id.length - 1],
                        "energy at each ionic loop", idents, d2d, "");
                outputData.setFileName(fileNames.get(i).toString());
                addOutputData(outputData);
            }
            if (readers.length != 0)
                isDone = true;
        }
        if (reader == null) {
            return false;
        }

        dataVector = new Vector();
        try {
            while ((line = reader.readLine()) != null) {
                parseLine(line.trim());
            }
        } catch (IOException ioe) {
            logger.error("failed parse of file: " + fileName);
            return false;
        } finally {
            isDone = true;
            try {
                reader.close();
            } catch (IOException ioe) {
                logger.error("failed to close file: " + fileName);
            }
        }
        if (idents == null || dataVector.size() == 0) {
            return false;
        }
        String[][] data2d = new String[dataVector.size()][idents.length];
        try {
            dataVector.copyInto(data2d);
        } catch (ArrayIndexOutOfBoundsException aiob) {
            logger.error("corrupted F_ENF file");
            return false;
        }
        OutputData outputData = new OutputData("energy",
                "energy at each ionic loop", idents, data2d, "");
        outputData.setFileName(fileName);
        addOutputData(outputData);
        return true;
    }

    private void parseLine(String line) {
        if (line.startsWith(START) || line.startsWith("#step")) {
            idents = line.split("\\s+");
            if (idents != null) {
                for (int i = 0; i < idents.length; i++) {
                    String[] foo = idents[i].split(",");
                    if (foo != null) {
                        idents[i] = foo[0];
                    }
                }
            }
            return;
        }

        String[] data = line.split("\\s+");
        dataVector.addElement(data);
    }

    public String getCurrentMessage() {
        return null;
    }

}
