/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/09/12, 16:16
!  AUTHOR(S): KOGA, Junichiro
!  File : ComboBoxChoices.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.inputinterface.inputinterfacetable;

/**
 * an interface for combo box choices.
 * 
 * @author
 */
public interface ComboBoxChoices {
    /**
     * implement this method to get the default choices.
     * 
     * @return array of combobox choices.
     */
    public Object[] getChoices();

    /**
     * implement this method to get choices whose 'choicetype' is specified in
     * the argument.
     * 
     * @param index
     *            the index
     * @return an array of combobox choices.
     */
    public Object[] getChoices(int index);

    /**
     * implement this method to get choices whose 'choicetype' is specified in
     * the argument.
     * 
     * @param index
     *            the index, in String representation.
     * @return an array of combobox choices.
     */
    public Object[] getChoices(String index);

    /**
     * implement this method to show 'tooltiptext' corresponding to each choice.
     * 
     * @param index
     *            the index of the selected combobox choice.
     * @return tooltip text corresponding to a selected combobox choice.
     */
    public String getToolTipTexts(int index);

}
