/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : InputInterfaceBlock.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.inputinterface;

import java.io.Serializable;
import java.util.LinkedList;

import org.apache.log4j.Logger;

public class InputInterfaceBlock extends LinkedList implements
        InputInterfaceData, Serializable {
    private Logger logger = Logger.getLogger(InputInterfaceBlock.class
            .getName());
    private String name = new String();

    private boolean table = false;
    private boolean defaultUnits = false;
    private boolean defaultValues = false;
    private String fullName;

    public InputInterfaceBlock() {
    }

    public InputInterfaceBlock(String name) {
        this.name = name;
    }

    public InputInterfaceBlock(String name, String fullName) {
        this.name = name;
        this.fullName = fullName;
    }

    protected void init(String name) {
        clear();
        add(null);
        setName(name);
    }

    /**
     * sets the 'full name' for this block, where a 'full name' is something
     * like structure.atom_list.atoms.
     * 
     * @param fullName
     *            the 'full name' corresponding to this block.
     */
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    /**
     * returns the 'full name' for this block. a 'full name' is something like
     * structure.atom_list.atoms
     * 
     * @return the fullname string.
     */
    public String getFullName() {
        return this.fullName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isBlock() {
        return true;
    }

    public boolean hasTable() {
        return this.table;
    }

    public boolean hasDefaults() {
        return this.defaultValues;
    }

    public boolean hasUnits() {
        return this.defaultUnits;
    }

    protected void setHasTable(boolean table) {
        this.table = table;
    }

    protected void setHasDefaults(boolean defaultValues) {
        this.defaultValues = defaultValues;
    }

    protected void setHasUnits(boolean defaultUnits) {
        this.defaultUnits = defaultUnits;
    }

    public String toString() {
        return "blockName: " + name + " fullname: " + getFullName();
    }

    /**
     * 艺ʂ̃Gg[XL, loggerɓfo.
     */
    public void scan() {
        for (int i = 1; i < size(); i++) {
            InputInterfaceData data = (InputInterfaceData) get(i);
            logger.info(data);
            if (data.isBlock()) {
                ((InputInterfaceBlock) data).scan();
            }
        }
    }

}
