/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/05/25, 10:37
!  AUTHOR(S): KOGA, Junichiro
!  File : FileBrowserNode.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.filebrowser;

import java.awt.event.MouseEvent;

import javax.swing.tree.DefaultMutableTreeNode;

import org.apache.log4j.Logger;

import ciss.phase_viewer.main.PluginLoader;
import ciss.phase_viewer.ssh.filechooser.RemoteFile;

/**
 * @author KOGA, Junichiro
 */
public abstract class FileBrowserNode extends DefaultMutableTreeNode {
    private static Logger logger = Logger.getLogger(FileBrowserNode.class
            .getName());

    /** Creates a new instance of FIleBrowserNode */
    public FileBrowserNode() {
        super();
    }

    public FileBrowserNode(Object userObject) {
        super(userObject);
    }

    public FileBrowserNode(Object userObject, boolean allowsChildren) {
        super(userObject, allowsChildren);
    }

    abstract public void mousePressed(MouseEvent e, FileBrowserTree tree);

    abstract public void mouseClicked(MouseEvent e, FileBrowserTree tree);

    public static FileBrowserNode getInstance(String loadClass, Object[] args) {
        Object obj = PluginLoader.instantiate(loadClass, args);
        if (obj == null || !(obj instanceof FileBrowserNode)) {
            return null;
        }
        return (FileBrowserNode) obj;
    }

    public String toString() {
        if (userObject instanceof RemoteFile) {
            RemoteFile file = (RemoteFile) userObject;
            if (file.isRoot()) {
                return file.getAbsolutePath();
            }
            return file.getName();
        } else {
            return super.toString();
        }
    }

}
