/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/08/30, 21:20
!  AUTHOR(S): KOGA, Junichiro
!  File : AtomFilledCircle.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.acviewer.scenegraphelements.atom;

import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.OrientedShape3D;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleFanArray;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;

import org.apache.log4j.Logger;

/**
 * "y"q; zgɌy?
 * 
 * @author
 */
public class AtomFilledCircle extends OrientedShape3D {
    private Logger logger = Logger.getLogger(AtomFilledCircle.class.getName());
    private Shape3D shape;

    private float radius = 0.5f;
    private int resolution = 12;
    private int length = resolution;
    private float resolutionh = (float) resolution * 0.5f;

    private AtomObject parent;
    private Color3f c;

    /** Creates a new instance of AtomFilledCircle */
    public AtomFilledCircle(AtomObject parent, float radius, Color3f c) {
        super();
        this.parent = parent;
        this.radius = radius * 0.9f;
        this.c = c;
        shape = createShape();
        setGeometry(shape.getGeometry());
        setAppearance(shape.getAppearance());
        setAlignmentMode(OrientedShape3D.ROTATE_ABOUT_POINT);
        setRotationPoint(new Point3f(0, 0, 0));
    }

    public AtomObject getAtomObject() {
        return this.parent;
    }

    private Shape3D createShape() {
        Appearance appearance = new Appearance();
        appearance.setColoringAttributes(new ColoringAttributes(c.x, c.y, c.z,
                ColoringAttributes.FASTEST));

        TriangleFanArray tsa = new TriangleFanArray(length + 2,
                GeometryArray.COORDINATES, new int[] { length + 2 });
        Point3f center = new Point3f(0, 0, 0);
        Point3f pt0 = new Point3f(radius, 0.0f, 0.0f);
        Point3f p0 = center;
        Point3f p1 = new Point3f();
        Point3f p2 = new Point3f();
        int count = 0;
        tsa.setCoordinate(0, center);
        for (int i = 0; i <= resolution; i++) {
            p1.x = (float) (radius * Math.cos(i * Math.PI / resolutionh));
            p1.y = (float) (radius * Math.sin(i * Math.PI / resolutionh));
            tsa.setCoordinate(i, p1);
        }
        try {
            tsa.setCapability(Geometry.ALLOW_INTERSECT);
        } catch (RestrictedAccessException rae) {
        }
        Shape3D circle = new Shape3D(tsa, appearance);
        return circle;
    }

}
