/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/07/20, 13:25
!  AUTHOR(S): KOGA, Junichiro
!  File : SymmetryPoint.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.acviewer.fbz;

import javax.media.j3d.Appearance;
import javax.media.j3d.Material;
import javax.media.j3d.Shape3D;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3f;

import org.apache.log4j.Logger;

import com.sun.j3d.utils.geometry.Sphere;

/**
 * Ώ̓_
 * 
 * @author
 */
public class SymmetryPoint extends Sphere {
    private Logger logger = Logger.getLogger(SymmetryPoint.class.getName());
    private Appearance appearance;
    private Material material;

    private Color3f selectedColor = new Color3f(1f, 0.8f, 0.4f);
    private Color3f unselectedColor = new Color3f(0f, 0.2f, 0.6f);
    private WignerSeitzAttributes wsattrs;

    /** Creates a new instance of SymmetryPoint */
    public SymmetryPoint(float rad, WignerSeitzAttributes wsattrs) {
        super(rad);
        if (wsattrs != null) {
            unselectedColor = wsattrs.symmetricPointColor;
            selectedColor = wsattrs.selectedSymmetricPointColor;
        }
        appearance = new Appearance();
        material = new Material();
        material.setCapability(Material.ALLOW_COMPONENT_WRITE);
        material.setCapability(Material.ALLOW_COMPONENT_READ);
        material.setDiffuseColor(unselectedColor);
        appearance.setMaterial(material);
        appearance.setCapability(Appearance.ALLOW_MATERIAL_WRITE);

        setAppearance(appearance);
        getShape().setCapability(Shape3D.ALLOW_APPEARANCE_WRITE);
        getShape().setCapability(Shape3D.ALLOW_COLLISION_BOUNDS_READ);
        getShape().setCapability(Shape3D.ALLOW_COLLISION_BOUNDS_WRITE);
        setCapability(Shape3D.ALLOW_BOUNDS_READ);
        setCapability(Shape3D.ALLOW_BOUNDS_WRITE);
        setCapability(Shape3D.ALLOW_APPEARANCE_WRITE);
    }

    private SymmetryPointBG parent;

    void setBG(SymmetryPointBG parent) {
        this.parent = parent;
    }

    public SymmetryPointBG getParentBG() {
        return this.parent;
    }

    private boolean selected = false;

    /**
     * I/I؂ւ
     */
    public void toggleSelected() {
        selected = !selected;
        doSelection();
    }

    private void doSelection() {
        if (selected) {
            material.setDiffuseColor(selectedColor);
        } else {
            material.setDiffuseColor(unselectedColor);
        }
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        doSelection();
    }

    /**
     * ̑Ώ̓_I𒆂ۂ擾.
     */
    public boolean isSelected() {
        return selected;
    }

    public String toString() {
        Vector3f v3f = parent.getPos();
        int[] xbunsu = FBZUtils.getBunsu(v3f.x);
        int[] ybunsu = FBZUtils.getBunsu(v3f.y);
        int[] zbunsu = FBZUtils.getBunsu(v3f.z);
        String str = "pos: " + xbunsu[1] + "/" + xbunsu[2] + ", " + ybunsu[1]
                + "/" + ybunsu[2] + ", " + zbunsu[1] + "/" + zbunsu[2];
        return str;
    }

}
