/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : TextFieldPhase.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.primitiveguis;

import javax.swing.JTextField;
import javax.swing.event.CaretListener;

import org.apache.log4j.Logger;

import ciss.phase_viewer.common.Command;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfaceEntry;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeEvent;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeListener;
import ciss.phase_viewer.inputinterface.InputInterfacePrimitiveEntry;

public class TextFieldPhase extends JTextField implements Command,
        InputInterfaceEntryChangeListener {
    private static Logger logger = Logger.getLogger(TextFieldPhase.class
            .getName());
    private String[] inputSpecifications;
    private InputInterface inputinterface;
    private boolean isDoubleQuoted = false;

    public TextFieldPhase(int columns, String[] inputSpecifications,
            InputInterface inputinterface, boolean isDoubleQuoted) {
        super(columns);
        this.inputSpecifications = inputSpecifications;
        this.inputinterface = inputinterface;
        this.isDoubleQuoted = isDoubleQuoted;
        inputinterface.addInputInterfaceEntryChangeListener(this);
        logger.debug("inputSpec: " + inputSpecifications[0] + " is DQ? "
                + this.isDoubleQuoted);
    }

    public void execute(java.util.EventObject e) {
        inputinterface.selectRoot();
        String inp = inputSpecifications[0];
        InputInterfacePrimitiveEntry entry = inputinterface
                .getInputInterfacePrimitiveEntry(inp);
        String[] fname = inp.split("\\.");
        String name = fname[fname.length - 1];
        String value = super.getText().trim();

        entry.saveState();

        entry.setName(name);
        entry.setValue(value);
        entry.setDoubleQuoted(isDoubleQuoted);
        logger.debug(" primitive entry: " + entry);

        if (value.length() == 0) {
            inputinterface.removeEntry(entry, this);
        } else {
            inputinterface.replaceEntry(entry, this);
        }
    }

    public void inputInterfaceInitialized() {

    }

    public void inputInterfaceInitializing() {
        CaretListener[] lists = getCaretListeners();
        for (int i = 0; i < lists.length; i++) {
            removeCaretListener(lists[i]);
        }
        setText("");
        for (int i = 0; i < lists.length; i++) {
            addCaretListener(lists[i]);
        }
    }

    public void inputInterfaceEntryChanged(InputInterfaceEntryChangeEvent evt) {
        logger.debug("at inputInterfaceEntryChanged... evt.getTag(): "
                + evt.getTag());
        if (evt.getSource() == this) {
            return;
        }

        String tag = evt.getTag();
        InputInterfaceEntry entry = evt.getEntry();
        if (entry.getEntryType() != InputInterfaceEntry.PRIMITIVE) {
            return;
        }

        InputInterfacePrimitiveEntry pentry = (InputInterfacePrimitiveEntry) entry;
        String fullName = tag + "." + pentry.getName();
        logger.debug("caught change of inputinterface object at: " + fullName
                + " and I'm " + inputSpecifications[0]);
        logger.debug("specifically, the change is : " + pentry.getValue());

        CaretListener[] listeners = getCaretListeners();
        for (int i = 0; i < listeners.length; i++) {
            removeCaretListener(listeners[i]);
        }

        for (int i = 0; i < inputSpecifications.length; i++)
            if (fullName.trim().equalsIgnoreCase(inputSpecifications[i].trim())) {
                setText(pentry.getValue());
                break;
            }

        for (int i = 0; i < listeners.length; i++) {
            addCaretListener(listeners[i]);
        }
    }

}
