/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : ChoicePanelPhase.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.primitiveguis;

import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.Vector;

import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.border.TitledBorder;
import javax.swing.event.PopupMenuListener;

import org.apache.log4j.Logger;

import ciss.phase_viewer.inputinterface.InputInterface;

public class ChoicePanelPhase extends PrimitiveInputComponents implements
        PhaseInputPanelInterface {
    private ComboBoxPhase combobox;
    public static String NO_SELECTION = ciss.phase_viewer.common.ConstParameters.NO_SELECTION;
    private static Logger logger = Logger.getLogger(ChoicePanelPhase.class
            .getName());

    private String[] choices;
    private String[] fullName;
    private String title;
    private Vector dupli = null;

    /**
     * ̃NXS̓t@C̏ȂǂɎRXgN^[.
     * 
     * @param inputSpecifications
     *            ͂́uށv̎w. Condition.cpumaxȂǂƎw.
     * @param inputinterface
     *            ̓t@C̑SێIuWFNg.
     * @param title
     *            GUIɂBorderedTitle. nullnĂ悢. ̏ꍇBorderedTitle͕tȂ.
     * @param choices
     *            GUĨR{{bNXɗpI̔z.
     * @param parent
     *            ̃NX̌Ăяo. EventListener̃TuNXCvgĂKv.
     */
    public ChoicePanelPhase(String[] inputSpecifications,
            InputInterface inputinterface, String title, String[] choices,
            EventListener parent) {
        super(inputSpecifications, inputinterface);
        this.title = title;
        this.choices = choices;

        this.createGUI();
        this.addListeners(parent);
    }

    /**
     * ̃NXS̓t@C̏ȂǂɎRXgN^[.
     * 
     * @param inputSpecifications
     *            ͂́uށv̎w. Condition.cpumaxȂǂƎw.
     * @param inputinterface
     *            ̓t@C̑SێIuWFNg.
     * @param title
     *            GUIɂBorderedTitle. nullnĂ悢. ̏ꍇBorderedTitle͕tȂ.
     * @param choices
     *            GUĨR{{bNXɗpI̔z.
     * @param dupli
     *            ̓t@C̃^OƂĕ̌₪L蓾ꍇ̂̌.
     * @param parent
     *            ̃NX̌Ăяo. EventListener̃TuNXCvgĂKv.
     */
    public ChoicePanelPhase(String[] inputSpecifications,
            InputInterface inputinterface, String title, String[] choices,
            Vector dupli, EventListener parent) {
        super(inputSpecifications, inputinterface);
        this.title = title;
        this.choices = choices;
        this.dupli = dupli;

        this.createGUI();
        this.addListeners(parent);
    }

    public ChoicePanelPhase(String[] inputSpecifications,
            InputInterface inputinterface, String title, String[] choices) {
        super(inputSpecifications, inputinterface);
        this.title = title;
        this.choices = choices;

        this.createGUI();
    }

    public ChoicePanelPhase(String[] inputSpecifications,
            InputInterface inputinterface, String title, String[] choices,
            Vector dupli) {
        super(inputSpecifications, inputinterface);
        this.title = title;
        this.choices = choices;
        this.dupli = dupli;

        this.createGUI();
    }

    public void setToolTips(String[] tips) {
        if (combobox != null) {
            combobox.setToolTips(tips);
        }
    }

    private void createGUI() {
        super.setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
        this.createComboBox();
        super.add(combobox);
        if (title != null) {
            super.setBorder(new TitledBorder(title));
        }
    }

    private void createComboBox() {
        combobox = new ComboBoxPhase(choices, inputSpecifications,
                inputInterface, false);
        String value = entry.getValue().trim();
        for (int i = 0; i < choices.length; i++) {
            logger.debug("choice at: " + i + " is " + choices[i]);
            if (choices[i].equalsIgnoreCase(value)) {
                combobox.setSelectedIndex(i);
                continue;
            }
        }
        if (dupli != null) {
            for (int i = 0; i < dupli.size(); i++) {
                String[] d = (String[]) dupli.get(i);
                int index = Integer.parseInt(d[0]);
                String newval = d[1];
                if (newval.equalsIgnoreCase(value)) {
                    combobox.setSelectedIndex(index);
                }
            }
        }
    }

    /**
     * ̃NXێR{{bNX, ANVXi[t郁\bh.
     */
    public void addListeners(EventListener listener) {
        if (listener instanceof ActionListener) {
            combobox.addActionListener((ActionListener) listener);
        }
        if (listener instanceof PopupMenuListener) {
            combobox.addPopupMenuListener((PopupMenuListener) listener);
        }
    }

    /**
     * ̃R{{bNX̑Ił͖ԂƂȂׂGUIR|[lgo^. o^ꍇ, ׂĂɑ΂čp.
     * ̂Ƃo^p\bh͗pӂĂȂ. Ƃ, ԖxXCb`It̂Ƃ͏Ԗx̌vZ@dEȂǂ͕ҏWsɂ,
     * Ƃꍇɗp.
     * 
     * @param index
     *            ̔ẑǂꂩ̒l̂Ƃ, o^ꂽGUI𖳌ɂ.
     * @param jcomponent
     *            IɂĂ͖ɂGUIR|[lg.
     */
    public void registerDisabableGUI(int[] index, JComponent jcomponent) {
        combobox.removeListeners();
        combobox.setDisabableGUI(index, jcomponent);
        combobox.disableRegisteredGUI();
        combobox.restoreListeners();
    }

    public void setEnabled(boolean enabled) {
        combobox.setEnabled(enabled);
    }

    public String getValue() {
        return (String) combobox.getSelectedItem();
    }

    public String getUnit() {
        return new String();
    }

    public JComboBox getComboBox() {
        return this.combobox;
    }

}
