/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/10/13, 20:35
!  AUTHOR(S): KOGA, Junichiro
!  File : NLOPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.uvsorepsilon.resultsviewerpanel;

import java.io.File;

import javax.swing.BoxLayout;
import javax.swing.JPanel;

import org.apache.log4j.Logger;

import ciss.phase_viewer.outputinterface.OutputParser;
import ciss.phase_viewer.outputinterface.OutputParserListener;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import ciss.phase_viewer.projectbrowser.tools.LoadingFilePanel;
import ciss.phase_viewer.projectbrowser.tools.NoFilePanel;

/**
 * UVSOR-EpsilonɂČvZꂽSHG̃f[^\GUI
 * 
 * @author
 */
public class NLOPanel extends ProjectManipulator implements
        OutputParserListener {
    private Logger logger = Logger.getLogger(NLOPanel.class.getName());

    private OutputParser parser;

    /** Creates a new instance of NLOPanel */
    public NLOPanel(ProjectInfo projectInfo) {
        super(projectInfo);
        setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
    }

    public void recreate() {
        projectInfo.getOutputInterface().initCache();
        init();
        revalidate();
    }

    public void parseFinished() {
        removeAll();
        JPanel button = new JPanel();
        JPanel dataPanel = projectInfo.getOutputInterface().getDataPanel(
                "F_NLO");
        add(dataPanel);

        revalidate();
    }

    public void initializeProject() {
    }

    public void init() {
        removeAll();
        try {
            String fname = projectInfo.getProjectDirectory()
                    + System.getProperty("file.separator")
                    + projectInfo.getChaseFileManager().getFile("F_NLO")
                            .getFileName();
            if (!new File(fname).exists()) {
                add(new NoFilePanel("F_NLO"));
                return;
            }
        } catch (Exception exc) {
            exc.printStackTrace();
        }
        add(new LoadingFilePanel("F_NLO"));
        if (parser == null) {
            parser = projectInfo.getOutputInterface().getParser("F_NLO", this);
        }
        parser.setParsed(false);
        parser.doParse();
    }

}
