/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/10/19, 18:26
!  AUTHOR(S): KOGA, Junichiro
!  File : MouseMotionListenerManager.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.acviewer.mouselistener;

import java.awt.event.MouseEvent;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.MainPanel;

/**
 * 
 * @author
 */
public class MouseMotionListenerManager {
    private Logger logger = Logger.getLogger(MouseMotionListenerManager.class
            .getName());
    private MainPanel parent;

    private RightClickAction rightClickAction;
    private LeftClickAction leftClickAction;

    /** Creates a new instance of MouseMotionListenerManager */
    public MouseMotionListenerManager(MainPanel parent) {
        this.parent = parent;
    }

    private int rightClick = MouseEvent.BUTTON3_DOWN_MASK;
    private int rightClickCtrl = MouseEvent.BUTTON3_DOWN_MASK
            + MouseEvent.CTRL_DOWN_MASK;

    private int leftClick = MouseEvent.BUTTON1_DOWN_MASK;
    private int leftClickCtrl = MouseEvent.BUTTON1_DOWN_MASK
            + MouseEvent.CTRL_DOWN_MASK;

    public MouseMotionListenerAction getAction(MouseEvent e) {
        int modifier = e.getModifiersEx();
        if (modifier == rightClick || modifier == rightClickCtrl
                || e.getButton() == MouseEvent.BUTTON3) {
            if (rightClickAction == null) {
                rightClickAction = new RightClickAction(parent);
            }
            return rightClickAction;
        }

        if (modifier == leftClickCtrl || e.getButton() == MouseEvent.BUTTON1) {
            if (leftClickAction == null) {
                leftClickAction = new LeftClickAction(parent);
            }
            return leftClickAction;
        }
        return null;
    }
}
