/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Common;

import AbinitMp.Common.ResidueData;
import java.io.PrintStream;

public class AtomData {
    public int no;
    public String atomName;
    public String allAtomName;
    public String altLoc;
    public String residueName;
    public String chain;
    public int residueNo;
    public String iCode;
    public float x;
    public float y;
    public float z;
    public float occupancy;
    public float tempFactor;
    public String segID;
    public String element;
    public String charge;
    public float coordX;
    public float coordY;
    public float coordZ;
    public String extention;
    public int fragmentNo;
    public float mulliken;
    public ResidueData residueData;
    public boolean cutFlag = false;
    public float vx;
    public float vy;
    public float vz;
    public float vLength;
    public int atomNo = 0;

    public AtomData() {
        this.no = 0;
        this.atomName = null;
        this.allAtomName = null;
        this.altLoc = null;
        this.residueName = null;
        this.chain = null;
        this.residueNo = 0;
        this.iCode = null;
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.occupancy = 0.0f;
        this.tempFactor = 0.0f;
        this.segID = null;
        this.element = null;
        this.charge = null;
        this.fragmentNo = 0;
        this.mulliken = 0.0f;
    }

    public AtomData(int n, String string, String string2, String string3, String string4, String string5, int n2, String string6, float f, float f2, float f3, float f4, float f5, String string7, String string8, String string9) {
        this.no = n;
        this.atomName = string;
        this.allAtomName = string2;
        this.altLoc = string3;
        this.residueName = string4;
        this.chain = string5;
        this.residueNo = n2;
        this.iCode = string6;
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.occupancy = f4;
        this.tempFactor = f5;
        this.segID = string7;
        this.element = string8;
        this.charge = string9;
        this.fragmentNo = 0;
        this.mulliken = 0.0f;
        int n3 = 0;
        char c = string2.charAt(0);
        if (Character.isDigit(c)) {
            n3 = 1;
        }
        this.extention = string2.substring(n3 + string.length(), string2.length());
        if (this.extention.length() == 0) {
            this.extention = "_";
        }
    }

    public AtomData(int n, String string, String string2, String string3, String string4, String string5, int n2, String string6, float f, float f2, float f3, float f4, float f5, String string7, String string8, String string9, int n3, float f6) {
        this.no = n;
        this.atomName = string;
        this.allAtomName = string2;
        this.altLoc = string3;
        this.residueName = string4;
        this.chain = string5;
        this.residueNo = n2;
        this.iCode = string6;
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.occupancy = f4;
        this.tempFactor = f5;
        this.segID = string7;
        this.element = string8;
        this.charge = string9;
        this.fragmentNo = n3;
        this.mulliken = f6;
        int n4 = 0;
        char c = string2.charAt(0);
        if (Character.isDigit(c)) {
            n4 = 1;
        }
        this.extention = string2.substring(n4 + string.length(), string2.length());
        if (this.extention.length() == 0) {
            this.extention = "_";
        }
    }

    public void set(int n, String string, String string2, String string3, String string4, String string5, int n2, String string6, float f, float f2, float f3, float f4, float f5, String string7, String string8, String string9) {
        this.no = n;
        this.atomName = string;
        this.allAtomName = string2;
        this.altLoc = string3;
        this.residueName = string4;
        this.chain = string5;
        this.residueNo = n2;
        this.iCode = string6;
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.occupancy = f4;
        this.tempFactor = f5;
        this.segID = string7;
        this.element = string8;
        this.charge = string9;
        int n3 = 0;
        char c = string2.charAt(0);
        if (Character.isDigit(c)) {
            n3 = 1;
        }
        this.extention = string2.substring(n3 + string.length(), string2.length());
        if (this.extention.length() == 0) {
            this.extention = "_";
        }
    }

    public void set(AtomData atomData) {
        this.no = atomData.no;
        this.atomName = atomData.atomName;
        this.allAtomName = atomData.allAtomName;
        this.altLoc = atomData.altLoc;
        this.residueName = atomData.residueName;
        this.chain = atomData.chain;
        this.residueNo = atomData.residueNo;
        this.iCode = atomData.iCode;
        this.x = atomData.x;
        this.y = atomData.y;
        this.z = atomData.z;
        this.occupancy = atomData.occupancy;
        this.tempFactor = atomData.tempFactor;
        this.segID = atomData.segID;
        this.element = atomData.element;
        this.charge = atomData.charge;
        this.fragmentNo = atomData.fragmentNo;
        this.mulliken = atomData.mulliken;
        int n = 0;
        char c = this.allAtomName.charAt(0);
        if (Character.isDigit(c)) {
            n = 1;
        }
        this.extention = this.allAtomName.substring(n + this.atomName.length(), this.allAtomName.length());
        if (this.extention.length() == 0) {
            this.extention = "_";
        }
    }

    public float distance(AtomData atomData) {
        return (float)Math.sqrt((atomData.x - this.x) * (atomData.x - this.x) + (atomData.y - this.y) * (atomData.y - this.y) + (atomData.z - this.z) * (atomData.z - this.z));
    }

    public float distance2(AtomData atomData) {
        return (atomData.x - this.x) * (atomData.x - this.x) + (atomData.y - this.y) * (atomData.y - this.y) + (atomData.z - this.z) * (atomData.z - this.z);
    }

    public void setVector(float f, float f2, float f3, float f4) {
        this.vx = f;
        this.vy = f2;
        this.vz = f3;
        this.vLength = f4;
    }

    public boolean isDnaAtom() {
        return !this.residueData.isResidue() && (this.residueName.equalsIgnoreCase("A") || this.residueName.equalsIgnoreCase("G") || this.residueName.equalsIgnoreCase("C") || this.residueName.equalsIgnoreCase("T"));
    }

    public void debugPrint(PrintStream printStream) {
        printStream.println(" no " + this.no + " name " + this.atomName + " " + this.allAtomName + " residue name " + this.residueName + " chain " + this.chain + " residue no " + this.residueNo + " x " + this.x + " y " + this.y + " z " + this.z + " charge " + this.charge);
        printStream.println(" cx " + this.coordX + " cy " + this.coordY + " cz " + this.coordZ + " ext " + this.extention);
    }
}

